/*
 * strtab.c - build string table.
 * Copyright (C) 1995 - 2001 Michael Riepe <michael@stud.uni-hannover.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	 02111-1307	 USA
 */

#include <common.h>
#include <elftools.h>

#ifndef lint
static const char rcsid[] = "@(#) $Id: strtab.c,v 1.1 2002/12/27 18:17:36 michael Exp $";
#endif /* lint */

static const unsigned blocksize = 1024;

size_t
et_build_string_table(Elf_Data *data, const char *str) {
	size_t n, len;

	if (str) {
		len = strlen(str) + 1;
		n = data->d_size + blocksize - 1, n -= n % blocksize;
		if (data->d_size + len > n) {
			n = data->d_size + len + blocksize - 1, n -= n % blocksize;
			data->d_buf = xrealloc(data->d_buf, n);
		}
		n = data->d_size, data->d_size += len;
		strcpy((char*)data->d_buf + n, str);
		return n;
	}
	data->d_buf = NULL;
	data->d_size = 0;
	data->d_type = ELF_T_BYTE;
	data->d_version = EV_CURRENT;
	data->d_align = 1;
	data->d_off = 0;
	return 0;
}
