/*
 * elfext.c -- handle ELF extensions
 * Copyright (C) 2002 Michael Riepe <michael@stud.uni-hannover.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	 02111-1307	 USA
 */

#include <common.h>
#include <elftools.h>

#ifndef lint
static const char rcsid[] = "@(#) $Id: elfext.c,v 1.1 2002/12/30 16:04:51 michael Exp $";
#endif /* lint */

GElf_Addr
et_get_shstrndx(Elf *elf) {
	Elf_Scn *scn;
	GElf_Ehdr eh;
	GElf_Shdr sh;

	if (!gelf_getehdr(elf, &eh)) {
		return 0;
	}
	if (eh.e_shstrndx != SHN_XINDEX) {
		return eh.e_shstrndx;
	}
	if (!gelf_getshdr(elf_getscn(elf, 0), &sh)) {
		return 0;
	}
	if (sh.sh_link < SHN_LORESERVE) {
		return 0;
	}
	return sh.sh_link;
}

int
et_set_shstrndx(Elf *elf, GElf_Addr shstrndx) {
	Elf_Scn *scn;
	GElf_Ehdr eh;
	GElf_Shdr sh;

	if (!gelf_getehdr(elf, &eh)) {
		return -1;
	}
	if (shstrndx >= SHN_LORESERVE) {
		if (!gelf_getshdr(scn = elf_getscn(elf, 0), &sh)) {
			return -1;
		}
		sh.sh_link = shstrndx;
		if (!gelf_update_shdr(scn, &sh)) {
			return -1;
		}
		shstrndx = SHN_XINDEX;
	}
	eh.e_shstrndx = shstrndx;
	if (!gelf_update_ehdr(elf, &eh)) {
		return -1;
	}
	return 0;
}

GElf_Addr
et_get_shnum(Elf *elf) {
	GElf_Ehdr eh;
	GElf_Shdr sh;
	GElf_Addr shnum;

	if (!gelf_getehdr(elf, &eh)) {
		return 0;
	}
	if ((shnum = eh.e_shnum) || !eh.e_shoff) {
		return shnum;
	}
	if (!gelf_getshdr(elf_getscn(elf, 0), &sh)) {
		return 0;
	}
	if (sh.sh_size < SHN_LORESERVE) {
		return 0;
	}
	return sh.sh_size;
}
