/*
 * elf_FCPU.h -- ELF definitions for F-CPU processors
 * Copyright (C) 2000 - 2002 Michael Riepe <michael@stud.uni-hannover.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* $Id: elf_FCPU.h,v 1.2 2002/12/23 13:53:40 michael Exp $ */

#ifndef _ELF_FCPU_H
#define _ELF_FCPU_H

/* Interim value for F-CPU architecture (NOT official) */
#define EM_FCPU		0xFC0	/* of course, the pun is intended :-) */

/*
 * F-CPU relocation types
 * Note that we use explicit addends!
 */
#define R_FCPU_NONE      0
#define R_FCPU_PC17      1  /* (S + A - P) & 0x1ffff          | loadaddri symbol */
#define R_FCPU_LE_64     2  /* S + A                          | .le_long symbol   */
#define R_FCPU_LE_PC64   3  /* S + A - P                      | .le_long symbol-. */
#define R_FCPU_BE_64     4  /* S + A                          | .be_long symbol   */
#define R_FCPU_BE_PC64   5  /* S + A - P                      | .be_long symbol-. */
#define R_FCPU_U_16      6  /* ((S + A) >>  0) & 0xffff       | loadcons[x].0 symbol */
#define R_FCPU_U_32      7  /* ((S + A) >> 16) & 0xffff       | loadcons[x].1 symbol */
#define R_FCPU_U_48      8  /* ((S + A) >> 32) & 0xffff       | loadcons[x].2 symbol */
#define R_FCPU_U_64      9  /* ((S + A) >> 48) & 0xffff       | loadcons[x].3 symbol */
#define R_FCPU_U_PC16   10  /* ((S + A - P) >>  0) & 0xffff   | loadcons[x].0 symbol-. */
#define R_FCPU_U_PC32   11  /* ((S + A - P) >> 16) & 0xffff   | loadcons[x].1 symbol-. */
#define R_FCPU_U_PC48   12  /* ((S + A - P) >> 32) & 0xffff   | loadcons[x].2 symbol-. */
#define R_FCPU_U_PC64   13  /* ((S + A - P) >> 48) & 0xffff   | loadcons[x].3 symbol-. */
#define R_FCPU_NUM      14  /* so far */

#endif /* _ELF_FCPU_H */
