-- regfile_generic.vhdl -- F-CPU Register File Implementations
-- Copyright (C) 2003 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-- @(#) $Id$

architecture Behave_Generic of RegFile is
	type F_REGISTER_FILE is array(63 downto 0) of F_VECTOR;

	function decode3to8 (X : in std_ulogic_vector(2 downto 0))
						return std_ulogic_vector is
		variable yy : std_ulogic_vector(7 downto 0);
	begin
		yy(0) := not X(2) and not X(1) and not X(0);
		yy(1) := not X(2) and not X(1) and     X(0);
		yy(2) := not X(2) and     X(1) and not X(0);
		yy(3) := not X(2) and     X(1) and     X(0);
		yy(4) :=     X(2) and not X(1) and not X(0);
		yy(5) :=     X(2) and not X(1) and     X(0);
		yy(6) :=     X(2) and     X(1) and not X(0);
		yy(7) :=     X(2) and     X(1) and     X(0);
		return yy;
	end decode3to8;

	function decode6to64 (X : in std_ulogic_vector(5 downto 0);
						  E : in std_ulogic)
						 return std_ulogic_vector is
		variable aa, bb : std_ulogic_vector(7 downto 0);
		variable yy : std_ulogic_vector(63 downto 0);
	begin
		aa := decode3to8(X(5 downto 3));
		bb := decode3to8(X(2 downto 0));
		for i in 7 downto 0 loop
			for j in 7 downto 0 loop
				yy(8*i+j) := aa(i) and bb(j) and E;
			end loop;
		end loop;
		return yy;
	end decode6to64;

	function mux64 (X : in F_REGISTER_FILE;
					Y : in std_ulogic_vector(5 downto 0)) return F_VECTOR is
	begin
		case Y is
			when "000000" => return X(0);
			when "000001" => return X(1);
			when "000010" => return X(2);
			when "000011" => return X(3);
			when "000100" => return X(4);
			when "000101" => return X(5);
			when "000110" => return X(6);
			when "000111" => return X(7);
			when "001000" => return X(8);
			when "001001" => return X(9);
			when "001010" => return X(10);
			when "001011" => return X(11);
			when "001100" => return X(12);
			when "001101" => return X(13);
			when "001110" => return X(14);
			when "001111" => return X(15);
			when "010000" => return X(16);
			when "010001" => return X(17);
			when "010010" => return X(18);
			when "010011" => return X(19);
			when "010100" => return X(20);
			when "010101" => return X(21);
			when "010110" => return X(22);
			when "010111" => return X(23);
			when "011000" => return X(24);
			when "011001" => return X(25);
			when "011010" => return X(26);
			when "011011" => return X(27);
			when "011100" => return X(28);
			when "011101" => return X(29);
			when "011110" => return X(30);
			when "011111" => return X(31);
			when "100000" => return X(32);
			when "100001" => return X(33);
			when "100010" => return X(34);
			when "100011" => return X(35);
			when "100100" => return X(36);
			when "100101" => return X(37);
			when "100110" => return X(38);
			when "100111" => return X(39);
			when "101000" => return X(40);
			when "101001" => return X(41);
			when "101010" => return X(42);
			when "101011" => return X(43);
			when "101100" => return X(44);
			when "101101" => return X(45);
			when "101110" => return X(46);
			when "101111" => return X(47);
			when "110000" => return X(48);
			when "110001" => return X(49);
			when "110010" => return X(50);
			when "110011" => return X(51);
			when "110100" => return X(52);
			when "110101" => return X(53);
			when "110110" => return X(54);
			when "110111" => return X(55);
			when "111000" => return X(56);
			when "111001" => return X(57);
			when "111010" => return X(58);
			when "111011" => return X(59);
			when "111100" => return X(60);
			when "111101" => return X(61);
			when "111110" => return X(62);
			when "111111" => return X(63);
			when others => return (others => 'X');
		end case;
	end mux64;

	signal RF : F_REGISTER_FILE;
begin
	-- write part
	process (WD0, WD1, WA0, WA1, WE0, WE1)
		variable w0, w1 : std_ulogic_vector(63 downto 0);
	begin
		w0 := decode6to64(WA0, WE0);
		w1 := decode6to64(WA1, WE1);
		-- latches
		for reg in 63 downto 0 loop
			if to_X01(w0(reg) or w1(reg)) = '1' then
				-- write port 0 takes precedence
				if to_X01(w0(reg)) = '1' then
					RF(reg) <= WD0;
				else
					RF(reg) <= WD1;
				end if;
			end if;
		end loop;
	end process;

	-- read part
	process (RF, RA0, RA1, RA2, RE0, RE1, RE2)
	begin
		if to_X01(RE0) = '1' then
			RD0 <= mux64(RF, to_X01(RA0));
		else
			RD0 <= (others => 'Z');
		end if;
		if to_X01(RE1) = '1' then
			RD1 <= mux64(RF, to_X01(RA1));
		else
			RD1 <= (others => 'Z');
		end if;
		if to_X01(RE2) = '1' then
			RD2 <= mux64(RF, to_X01(RA2));
		else
			RD2 <= (others => 'Z');
		end if;
	end process;
end Behave_Generic;

-- vi: set ts=4 sw=4 equalprg="fmt -72 -p--": please
