/*

YGTK2.C : Whygee's dirty & small X11 library, version 1.0 rebuild

Big thanks to the 9wm guys, their source helped me a lot :-)))

   rev 0.2 : if (gc!=NULL)... 
   rev 0.3 : ifndef... pour eviter l'inclusion multiple, et aussi
    KeyPressMask pour gerer le clavier, MotionNotify pour la souris...
   rev 0.4 pour le F-CPU
   rev 0.5 : english...
   rev 0.6 : added min_size, position etc in xsh
   rev 0.7 : better font support, better windowing...
       and discovery of XMoveWindow, keysyms etc :-)

   rev 1.0 : colormap management Wed Feb 14 10:33:30 MET 2001

*/

#ifndef YGTK
#define YGTK

#include <string.h>
#include <stdio.h>

/* external files */
#include <X11/Xlib.h>
#include <X11/Xutil.h>

char *fontlist[] = {
 "-ADOBE-NEW CENTURY SCHOOLBOOK-MEDIUM-R-NORMAL--*-140-*-*-P-*",
 "lucm.latin1.9",
 "blit",
 "9x15bold",
 "lucidasanstypewriter-12",
 "fixed",
 "*",
 0,
};

/*  Window attribute when creating it...  */
#define HIDDEN 1
#define SHOWN 0

#define TRUE 1
#define FALSE 0

/* color definition : */
typedef enum {
  private_color_black=0,
  private_color_white,
  private_color_dark_slate_blue,
  private_color_light_grey,
  private_color_firebrick,
  private_color_blue,
  private_color_red,
  private_color_green,
  private_color_grey,
  private_color_yellow,
  private_color_orange,
  private_color_seagreen,
  private_color_dim_grey,
  private_color_grey18,
  private_color_grey25,
  private_color_grey34,
  private_color_grey40,
  private_color_grey55,
  private_color_last_color
} private_color_set;

unsigned char rgb_vals[private_color_last_color][3]= {
  {0,0,0},
  {255,255,255},
  {72,61,139},
  {211,211,211},
  {178,34,34},
  {0,0,255},
  {255,0,0},
  {0,255,0},
  {190,190,190},
  {255,255,0},
  {255,165,0},
  {46,139,87},
  {105,105,105},
  {46,46,46},
  {64,64,64},
  {87,87,87},
  {102,102,102},
  {140,140,140}
};

/* Some global variables that makes life a lot easier */

int display_is_open=0,
 cmap_is_installed=0;
XFontStruct *font;
Display *dpy;
Screen *screen;
XSetWindowAttributes xswa;
XSizeHints xsh;
XGCValues xgcv;
XColor private_color;
Colormap private_cmap;

static void exitX ()
{
  if (cmap_is_installed)
    XUninstallColormap(dpy,private_cmap);
  XFreeColormap(dpy, private_cmap);
  XCloseDisplay (dpy);
}

/* to be called before any window is displayed */
static void init_X ()
{
  char *fname;
  int i=0;

  /* open dpy */
  dpy = XOpenDisplay(0);
  if (!dpy) {
    printf ("Can't open display !\n");
    exit(2);
  }
  display_is_open=1;
  screen = XDefaultScreenOfDisplay (dpy);
  XSynchronize (dpy, 1);

  /* alloc cmap */
  private_cmap = XCreateColormap(dpy,DefaultRootWindow(dpy),
    DefaultVisualOfScreen(screen),AllocNone);
  private_color.flags= DoRed | DoGreen | DoBlue;
  do {
    private_color.red  = rgb_vals[i][0]<<8;
    private_color.green= rgb_vals[i][1]<<8;
    private_color.blue = rgb_vals[i][2]<<8;
    private_color.pixel=i;
    if (!XAllocColor(dpy,private_cmap,&private_color))
      fprintf(stderr,"%c\nProblem with color %d",7,i);
    i++;
  } while (i<private_color_last_color);

  /* alloc font */
  i=0;
  for (;;) {
    fname = fontlist[i++];
    if (fname == 0) {
      fprintf(stderr, "warning: can't find a font\n");
      break;
    }
    font = XLoadQueryFont(dpy, fname);
    if (font != 0) {
      /* fprintf(stderr, "loaded font %s\n",fname);*/
      break;
    }
  }

  xgcv.font = font->fid;
  xgcv.line_width = 1;
  xgcv.line_style = LineSolid;
  XSynchronize (dpy, 1);
}

static void open_window (Window *win_, int win_x, int win_y, int win_width,
      int win_height, int min_width, int min_height,
      GC *gc, long int win_foreground, long int win_background, char *win_name, int hidden)
{
  xsh.x = win_x;
  xsh.y = win_y;
  xsh.width = win_width;
  xsh.height = win_height;
  xsh.min_width = min_width;
  xsh.min_height = min_height;
  xsh.flags = PPosition | PSize | PMinSize;
  xswa.background_pixel = win_background;
  xgcv.background = xswa.background_pixel;
  xgcv.foreground = win_foreground;
  xswa.backing_store = WhenMapped;
  xswa.save_under = TRUE;
  xswa.colormap = private_cmap;
  xswa.event_mask =
    ButtonPressMask |
    ExposureMask |
    KeyPressMask |
    KeyReleaseMask |
    PointerMotionMask |
    ButtonReleaseMask ;
  *win_ = XCreateWindow( dpy,XRootWindowOfScreen (screen),
    win_x, win_y, win_width, win_height, 0, XDefaultDepthOfScreen (screen), InputOutput,
      XDefaultVisualOfScreen (screen), CWEventMask | CWBackPixel | CWBackingStore
       | CWSaveUnder |CWColormap, &xswa);
  XStoreName (dpy, *win_,win_name);
  if (gc!=NULL)
    *gc = XCreateGC (dpy, *win_, GCForeground | GCBackground | GCFont
           | GCLineWidth | GCLineStyle, &xgcv);
  XSetNormalHints (dpy, *win_,&xsh);
  if (hidden!=HIDDEN)
    XMapWindow (dpy, *win_);
}

static void open_daughter_window (Window *win_,
   Window mother_win, int pos_x, int pos_y, int win_width, int win_height,
   GC *gc, int win_foreground, int win_background, int thickness)
{
  xsh.x = pos_x;
  xsh.y = pos_y;
  xsh.width = win_width;
  xsh.height = win_height;
  xsh.flags = PPosition | PSize;
  xswa.event_mask =
    ButtonPressMask |
    ExposureMask |
    KeyPressMask |
    KeyReleaseMask |
    PointerMotionMask |
    ButtonReleaseMask ;
  xswa.background_pixel = win_background;
  xgcv.background = xswa.background_pixel;
  xgcv.foreground = win_foreground;
  *win_ = XCreateWindow (dpy, mother_win, pos_x, pos_y, win_width,
     win_height, thickness,XDefaultDepthOfScreen(screen), InputOutput,
     XDefaultVisualOfScreen(screen),CWEventMask | CWBackPixel | CWBackingStore
       | CWSaveUnder |CWColormap , &xswa);
  XMapWindow (dpy, *win_);
  XSetNormalHints (dpy, *win_, &xsh);
  if (gc!=NULL)
    *gc = XCreateGC (dpy, *win_,GCForeground | GCBackground | GCFont
           | GCLineWidth | GCLineStyle, &xgcv);
}

static void close_window (Window *win_)
{
  XUnmapWindow (dpy, *win_);
  XDestroyWindow (dpy, *win_);
}

#endif
