/*
dct1d_test.c
created mer jan  2 13:55:12 GMT 2002
by Yann Guidon <whygee@f-cpu.org>

this is a "wrapper" for the other files
which allows to test them.
Here we use "float" because the code
doesn't contain the shifts and sign
corrections required by integer
arithmetics.

compile with gcc -lm dct1d_test.c -Wall

*/

#include <stdio.h>
#include <math.h>

/* typedef signed short int sample; */
typedef double sample;

sample
  m1, m2, m3, m4,                  /* twiddle factors */
  a0, a1, a2, a3, a4, a5, a6, a7,  /* the inputs */
  S0, S1, S2, S3, S4, S5, S6, S7;  /* the outputs */

static void DCT1D_01() {

#include "dct1d_01.c"

}

static void DCT1D_05() {

#include "dct1d_05.c"

}

int main() {
  sample l[8];
  int i;

  m1 = cos(4*M_PI/16);
  m2 = cos(6*M_PI/16);
  m3 = cos(2*M_PI/16) - cos(6*M_PI/16);
  m4 = cos(2*M_PI/16) + cos(6*M_PI/16);

  for (i=0; i<8; i++) {
    l[i] = cos((i * M_PI)/4);
  }

  a0=l[0];
  a1=l[1];
  a2=l[2];
  a3=l[3];
  a4=l[4];
  a5=l[5];
  a6=l[6];
  a7=l[7];

  DCT1D_01();

  printf("\n DCT8 intput :             DCT8 output :\n\
 a0 = %+.15f   S0 = %+.15f\n\
 a1 = %+.15f   S1 = %+.15f\n\
 a2 = %+.15f   S2 = %+.15f\n\
 a3 = %+.15f   S3 = %+.15f\n\
 a4 = %+.15f   S4 = %+.15f\n\
 a5 = %+.15f   S5 = %+.15f\n\
 a6 = %+.15f   S6 = %+.15f\n\
 a7 = %+.15f   S7 = %+.15f\n\n",
  a0, S0, a1, S1, a2, S2, a3, S3, a4, S4, a5, S5, a6, S6, a7, S7);

  S0=S1=S2=S3=S4=S5=S6=S7=0;

  DCT1D_05();

  printf("\n DCT8 intput :             DCT8 output :\n\
 a0 = %+.15f   S0 = %+.15f\n\
 a1 = %+.15f   S1 = %+.15f\n\
 a2 = %+.15f   S2 = %+.15f\n\
 a3 = %+.15f   S3 = %+.15f\n\
 a4 = %+.15f   S4 = %+.15f\n\
 a5 = %+.15f   S5 = %+.15f\n\
 a6 = %+.15f   S6 = %+.15f\n\
 a7 = %+.15f   S7 = %+.15f\n\n",
  a0, S0, a1, S1, a2, S2, a3, S3, a4, S4, a5, S5, a6, S6, a7, S7);

  return 0;

}
