--------------------------------------------------------------------------
-- f-cpu/vhdl/eu_rop2/test_rop2.vhdl - Yet Another ROP2 Testbench for the F-CPU
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
--
-- created sam dec  1 05:17:51 GMT 2001
-- 
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- This is a little testbench for the ROP2 set of units. Nothing wonderful.
--
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
-- text I/O
    use IEEE.std_logic_textio.all;
    use std.textio.all;
-- local functions
LIBRARY work;
    USE work.FCPU_config.ALL;
    USE work.eu_rop2_xbar;
    USE work.eu_rop2;

Entity test_rop2 is
  -- empty : no external connexion.
end test_rop2;

Architecture arch1 of test_rop2 is

  component eu_rop2_xbar
    port (
      ROP2_function : in Std_ulogic_vector(2 downto 0);
      ROP2_function_bit0,
      ROP2_function_bit1,
      ROP2_function_bit2,
      ROP2_function_bit3 : out Std_ulogic_vector((MAXSIZE *2)-1 downto 0)
    );
  end component;

  component eu_rop2
    port (
      ROP2_in_A,
      ROP2_in_B,
      ROP2_in_C : in F_VECTOR;
      ROP2_function_bit0,
      ROP2_function_bit1,
      ROP2_function_bit2,
      ROP2_function_bit3 : in Std_ulogic_vector((MAXSIZE *2)-1 downto 0);
      ROP2_mode : in Std_ulogic_vector(1 downto 0);
      ROP2_out : out F_VECTOR
    );
  end component;

  signal l_ROP2_function : Std_ulogic_vector(2 downto 0);
  signal l_ROP2_function_bit0, l_ROP2_function_bit1, l_ROP2_function_bit2,
    l_ROP2_function_bit3 : Std_ulogic_vector((MAXSIZE *2)-1 downto 0);
  signal l_ROP2_in_A, l_ROP2_in_B, l_ROP2_in_C, l_ROP2_out : F_VECTOR;
  signal l_ROP2_mode : Std_ulogic_vector(1 downto 0);

begin

-- Components under test :
  xbar: component eu_rop2_xbar port map (
      ROP2_function => l_ROP2_function,
      ROP2_function_bit0 => l_ROP2_function_bit0,
      ROP2_function_bit1 => l_ROP2_function_bit1,
      ROP2_function_bit2 => l_ROP2_function_bit2,
      ROP2_function_bit3 => l_ROP2_function_bit3
  );

  rop2: component eu_rop2 port map (
      ROP2_in_A => l_ROP2_in_A,
      ROP2_in_B => l_ROP2_in_B,
      ROP2_in_C => l_ROP2_in_C,
      ROP2_function_bit0 => l_ROP2_function_bit0,
      ROP2_function_bit1 => l_ROP2_function_bit1,
      ROP2_function_bit2 => l_ROP2_function_bit2,
      ROP2_function_bit3 => l_ROP2_function_bit3,
      ROP2_mode  => l_ROP2_mode,
      ROP2_out => l_ROP2_out
    );

-- test vectors :
  testbench : process is
    variable i, j : integer;
    variable lout : line;
  begin
    l_ROP2_in_A <= X"123456789ABCDEF0";
    l_ROP2_in_B <= X"0123456789ABCDEF";
    l_ROP2_in_C <= X"F0123456789ABCDE";

    for j in 0 to 3 loop
      l_ROP2_mode <= std_ulogic_vector(to_unsigned(j,2));
      write(lout, string'("mode #"));
      write(lout, j);
      writeline(output, lout);
      for i in 0 to 7 loop
        l_ROP2_function <= std_ulogic_vector(to_unsigned(i,3));
        wait for 1 ns;

        write(lout, string'(" round #"));
        write(lout, i);
        write(lout, string'("  out="));
        write(lout, l_ROP2_out);
        writeline(output, lout);

      end loop;  -- i
    end loop;  -- j
    wait;  -- stop the simulation counter.
  end process;

end;
