-------------------------------------------------------------------------
-- WARNING !  This file is a manual, shortened version !
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- (c) Yann GUIDON, oct. 21, 2000 <whygee@f-cpu.org>
-- v0.2 : Michael Riepe changed F_RANGE
-- v0.3 : YG specified the user-modifiable constants + GPL
-- v0.4 : MR proposed LOGMAXSIZE, YG added the ROP2 constants.
-- v0.5 : nov. 17, 2000, YG added SR_IRQ_BASE, SR_TRAP_BASE,
--         SR_SYSCALL_BASE, SR_URL etc.
-- v0.6 : nov. 26, 2000, YG moved some SR stuff to /VHDL/EU_sr
-- v0.7 : aug. 19, 2001, YG hacked for m4 preprocessing.
--        run f-cpu/configure.sh to update this file.
-- v0.8 : aug. 28, 2001 : YG + MR modified some stuffs.
--        MR hinted the "eval(radix)" trick, status is satisfying.
--
-- This version is for demonstration only.
--
-- This package defines the "characteristic widths" of
-- the internal units. Please respect the restrictions.
--
-- **************************************************************
-- WARNING : All the user-modifiable values are defined in the 
-- f-cpu/configuration/f-cpu_user.m4 file.
-- **************************************************************
--
--  * LOGMAXSIZE : Log2 of the Size of the registers in bytes.
--  Can be any integer above or equal to 2. 2 corresponds to
--  a 32-bit implementation, 3 corresponds to a 64-bit version.
--  This is the most important parameter, the first with
--  which one can play. Be careful anyway. The 32-bit version will
--  not work yet.
--

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;

package FCPU_config is

------------------------------------------------------
-- Most important F-CPU constants :
------------------------------------------------------

-- Number >=2, 3 corresponds to 64-bit registers
  constant LOGMAXSIZE : natural := 3;
    -- defined in f-cpu/configuration/f-cpu_user.m4

-- Size of the registers in bytes
  constant MAXSIZE : natural := 2**LOGMAXSIZE;

-- Size of the registers in bits.
  constant UMAX : natural := MAXSIZE * 8;

-- Range of a register width declaration.
  subtype F_RANGE is natural range UMAX-1 downto 0 ;

-- shortcut for a very common declaration.
  subtype F_VECTOR is std_ulogic_vector(F_RANGE) ;


-------------------------------------------------------
-- The ROP2 unit : these constants specify the
-- correspondance between the binary code and the actual
-- operation. These data are copied here for convenience
-- only, for example if you want to make an assembler in
-- VHDL. Check the file rop2_xbar.vhdl for more informations.
--------------------------------------------------------

  constant ROP2_DIRECT_MODE : std_ulogic_vector(1 downto 0) := "00";
  constant ROP2_AND_MODE :    std_ulogic_vector(1 downto 0) := "01";
  constant ROP2_OR_MODE :     std_ulogic_vector(1 downto 0) := "10";
  constant ROP2_MUX_MODE :    std_ulogic_vector(1 downto 0) := "11";

  constant ROP2_AND   : std_ulogic_vector(2 downto 0) := "000";
  constant ROP2_ANDN  : std_ulogic_vector(2 downto 0) := "001";
  constant ROP2_XOR   : std_ulogic_vector(2 downto 0) := "010";
  constant ROP2_OR    : std_ulogic_vector(2 downto 0) := "011";
  constant ROP2_NOR   : std_ulogic_vector(2 downto 0) := "100";
  constant ROP2_XNOR  : std_ulogic_vector(2 downto 0) := "101";
  constant ROP2_ORN   : std_ulogic_vector(2 downto 0) := "110";
  constant ROP2_NAND  : std_ulogic_vector(2 downto 0) := "111";

  constant ROP2_VALUE_AND   : std_ulogic_vector(3 downto 0) := "0001";
  constant ROP2_VALUE_ANDN  : std_ulogic_vector(3 downto 0) := "0010";
  constant ROP2_VALUE_XOR   : std_ulogic_vector(3 downto 0) := "0110";
  constant ROP2_VALUE_OR    : std_ulogic_vector(3 downto 0) := "0111";
  constant ROP2_VALUE_NOR   : std_ulogic_vector(3 downto 0) := "1000";
  constant ROP2_VALUE_XNOR  : std_ulogic_vector(3 downto 0) := "1001";
  constant ROP2_VALUE_ORN   : std_ulogic_vector(3 downto 0) := "1011";
  constant ROP2_VALUE_NAND  : std_ulogic_vector(3 downto 0) := "1110";

end FCPU_config;


package body FCPU_config is

-- vide pour cette version "courte".

end FCPU_config;
