#include <gtk/gtk.h>
#define __USE_ISOC9X
#include <stdio.h>
#include "Processor.hh"
#include "Memory.hh"

Processor *processor;
Memory *memory;

GtkWidget *regWindow;
GtkWidget *regTable;
GtkWidget **regView[2];

void update_debug()
{
  Registers *regs;
  char tmp[256];
  int i;

  regs = &(processor->regs);
  for(i=1;i<64;i++)
    {
      snprintf(tmp, 256, "%llX",(regs->read_register(i)).r_uint64());
      gtk_label_set(GTK_LABEL(regView[1][i]), tmp);
    }
}

void tick_callback(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  if(processor) 
    {
      processor->tick();
      update_debug();
    }
}

void delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_main_quit ();
}

void suppress (GtkWidget *widget, gpointer data)
{
    gtk_widget_hide(widget);
    gtk_widget_destroy(widget);
}

void file_ok_sel(GtkWidget *w, GtkFileSelection *fs)
{
  int i;

  char *file = gtk_file_selection_get_filename
    (GTK_FILE_SELECTION (fs));

  gdk_window_hide(gtk_widget_get_parent_window(w));
  gdk_window_destroy(gtk_widget_get_parent_window(w));

  memory = new Memory(file);
  processor = new Processor(memory);
  
  memory->dump(stdout);

/*  if(memory) delete memory;
  memory = new RamMemory(file);

  if(simulator) delete simulator;
  simulator = new ProcessorSimulator64(memory);
  simulator->init();
*/

  regWindow = gtk_dialog_new();
  regView[0]= new GtkWidget * [64];
  regView[1]= new GtkWidget * [64];
  regTable = gtk_table_new(64,2,TRUE);

  printf("Init \n");
  
  char tmp[256];

  for(i=0;i<64;i++) 
    {
      snprintf(tmp, 256, "%llX",
	       (processor->regs.read_register(i)).r_uint64());
      regView[1][i] = gtk_label_new(tmp);
      gtk_table_attach_defaults   (GTK_TABLE(regTable),
				   regView[1][i],
				   1, 1+1, i, i+1);
      gtk_widget_show(regView[1][i]);
    }

  printf("Init \n");

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(regWindow)->vbox),regTable,
		     TRUE,TRUE,0);
  gtk_widget_show(regTable);
  gtk_widget_show(regWindow);
  delete file;
}

void select_file(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  GtkWidget *filew;
  filew = gtk_file_selection_new ("File selection");

  gtk_signal_connect 
    (GTK_OBJECT (filew), "destroy", (GtkSignalFunc) suppress, &filew); 
  gtk_signal_connect 
    (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button), "clicked", 
     (GtkSignalFunc) file_ok_sel, filew );
  gtk_signal_connect_object 
    (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),"clicked",
     (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filew));
  gtk_widget_show(filew);
}

int main(int argc, char **argv)
{
  GtkWidget *main_window;
  GtkWidget *menu;
  GtkWidget *menu_bar;
  GtkWidget *file_menu;
  GtkWidget *vbox;
  GtkWidget *open;
  GtkWidget *quit;
  GtkWidget *button;
  
  processor = NULL;
  memory = NULL;

  /* Init gtk+ */
  gtk_init(&argc,&argv);
  main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_show(main_window);
  gtk_window_set_title (GTK_WINDOW (main_window),"CPU Simulator");

  /* Menu Objects */
  menu      = gtk_menu_new();
  menu_bar  = gtk_menu_bar_new();
  quit      = gtk_menu_item_new_with_label("Quit");
  open      = gtk_menu_item_new_with_label("Open");
  file_menu = gtk_menu_item_new_with_label("File");
  button    = gtk_button_new_with_label("Tick");
  vbox      = gtk_vbox_new(FALSE, 0);

  /* Menu Construction */
  gtk_menu_append(GTK_MENU (menu), open);
  gtk_menu_append(GTK_MENU (menu), quit);
  gtk_container_add(GTK_CONTAINER(main_window), vbox);
  gtk_box_pack_start(GTK_BOX(vbox), menu_bar, FALSE, FALSE, 2);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM (file_menu), menu);
  gtk_menu_bar_append(GTK_MENU_BAR (menu_bar), file_menu);
  gtk_box_pack_start(GTK_BOX(vbox), button, TRUE, TRUE, 0);

  /* Display everything */
  gtk_widget_show(vbox);
  gtk_widget_show(menu_bar);
  gtk_widget_show(open);
  gtk_widget_show(quit);
  gtk_widget_show(file_menu);
  gtk_widget_show(button);
  
  /* Callbacks */
  gtk_signal_connect_object (GTK_OBJECT(quit), "activate",
			     GTK_SIGNAL_FUNC(delete_event), NULL);
  gtk_signal_connect_object (GTK_OBJECT(open), "activate",
			     GTK_SIGNAL_FUNC(select_file), NULL); 
  gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL); 
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (tick_callback), NULL);
  gtk_main();
  return(0);
}
