#include "ShiftUnit.hh"

void ShiftUnit::tick()
{
}


void ShiftUnit::launch_instruction(unsigned char op, Instruction inst,
				   int reg_src[], int reg_dest[])
{
  uint64 source1 = regs().read_register(reg_src[0]).r_uint64();
  uint64 source2 = regs().read_register(reg_src[1]).r_uint64();
  uint64 result;

  switch(op)
    {
    case OP_SHIFT:
      if (inst.value() & SHIFTROT_LEFT)
	result = source1 << source2;
      else /* SHIFTROT_RIGHT */
	result = source1 >> source2;
      break;

    case OP_ROT:
      if (inst.value() & SHIFTROT_LEFT)
	result = (source1<<(source2%64))|(source1>>(64-source2%64));
      else /* SHIFTROT_RIGHT */
	result = (source1>>(source2%64))|(source1<<(64-source2%64));
      break;
     
    default:
      return;
      break;
    }
  regs().write_register(reg_dest[0], Register(result));

}
