#ifndef REGISTERS_HH
#define REGISTERS_HH

#include "Register.hh"

class Registers
{
private:
  Register *regs;

public:
  Registers() 
    {
      regs = new Register[64];
    }

  ~Registers() 
    {
      delete [] regs;
    }

  Register read_register(int n)
    {
      if((n>=0)&&(n<64))
	return regs[n];
      return 0L;
    }
  
  void write_register(int n, Register r)
    {
      if((n>0)&&(n<64))
	regs[n].set(r);
    }

  void write_partial_register(int n, uint64 value,
			      int size = 8, int offset = 0);
  void write_partial_register2(int n, uint64 value,
			       char bytemask);
};

#endif
