#include "Registers.hh"

void  Registers::write_partial_register(int n, uint64 value,
                                        int size, int offset)
{
 char cvaluenew[8];
 char cvalueold[8];

 memcpy(&cvalueold, &regs[n], 8);
 memcpy(&cvaluenew, &cvaluenew, 8);

 for (int x=offset; ( (x<8) && (x < (offset+(1<<size)) ) ); x++)
 {
   cvaluenew[x] = cvalueold[x+offset];
 }

 memcpy(&regs[n], &cvaluenew, 8);
}

void  Registers::write_partial_register2(int n, uint64 value,
					 char bytemask)
{
 char cvaluenew[8];
 char cvalueold[8];

 memcpy(&cvaluenew, &value, 8);
 memcpy(&cvalueold, &regs[n], 8);

 for (int x = 0; x<8; x++)
 {
  if (!((bytemask)&&(1<<x)))
  { 
   cvaluenew[x] = cvalueold[x];
  }
 }

 memcpy(&regs[n], &cvaluenew, 8);
}

