#ifndef PROCESSOR_HH
#define PROCESSOR_HH

#include "Registers.hh"
#include "ArithmeticUnit.hh"
#include "LoadStoreUnit.hh"
#include "BranchUnit.hh"
#include "LogicUnit.hh"
#include "ShiftUnit.hh"

#include "Decoder.hh"
#include "ScoreBoard.hh"

class Processor
{
public:
  Memory *memory;

  Registers regs;
  Register PC;
  Register MSW;

  ArithmeticUnit AU;
  LoadStoreUnit LSU;
  BranchUnit BU;
  LogicUnit LU;
  ShiftUnit SU;

  Decoder DU;
  ScoreBoard SB;

  void tick();

  Processor(Memory *mem)
    {
      memory = mem;
      DU.setProcessor(this);
      AU.setProcessor(this);
      LSU.setProcessor(this);
      BU.setProcessor(this);
      LU.setProcessor(this);
      SU.setProcessor(this);
    }
};

#endif
