#include <iostream>
#include "Memory.hh"

Register Memory::read_memory(Register p, char size)
{
  if (p<max)
    {
      if (size==8)
	{
	  return ((uint64*)memory)[p.r_uint64()>>3];
	}
      else if (size==4)
	{
	  return ((unsigned int*)memory)[p.r_uint64()>>2];
	}
      else if (size==2)
	{
	  return ((unsigned short*)memory)[p.r_uint64()>>1];
	}
      else if (size==1)
	{
	  return memory[p.r_uint64()];
	}
    }
  cout << "Warning: Trying to read outside of memory at address "
       << p.r_uint64() << endl;

  return 0;
}

void Memory::write_memory(Register p, Register data, char size)
{
  if (p<max)
    {
     if (size==8)
	{
	  ((uint64*)memory)[p.r_uint64()>>3]= data.r_uint64();
	}
      else if (size==4)
	{
	  ((unsigned int*)memory)[p.r_uint64()>>2] = data.r_uint64();
	}
      else if (size==2)
	{
	  ((unsigned short*)memory)[p.r_uint64()>>1] = data.r_uint64();
	}
      else if (size==1)
	{
	  memory[p.r_uint64()] = data.r_uint64();
	}
    }
  cout << "Warning: Trying to write outside of memory at address "
       << p.r_uint64() << endl;
}

void  Memory::dump(FILE* f)
{
  for(unsigned int i=0;i<max;i+=4)
    {
      fprintf(f, "%x\n", ((unsigned int*)memory)[i]);
    }
}
