#include "LoadStoreUnit.hh"

void LoadStoreUnit::tick()
{
}

void LoadStoreUnit::launch_instruction(unsigned char op, Instruction inst,
				       int reg_src[], int reg_dest[])
{
  uint64 address;
  uint64 source = address = regs().read_register(reg_src[0]).r_uint64();
 switch(op)
    {
    case OP_LOAD:
      address += regs().read_register(reg_src[1]).r_uint64();
      regs().write_register(reg_dest[0], mem()->read_memory((address>>3)<<3));
      break;

    case OP_STORE:
      address = regs().read_register(reg_dest[0]).r_uint64();
      address += regs().read_register(reg_dest[1]).r_uint64();
      mem()->write_memory((address>>3)<<3, source);
      break;
    }
}
