#include "ArithmeticUnit.hh"

void ArithmeticUnit::tick()
{
}

void ArithmeticUnit::launch_instruction(unsigned char op, Instruction inst,
					int reg_src[], int reg_dest[])
{
  Register src1 = regs().read_register(reg_src[0]).r_uint64();
  Register src2 = regs().read_register(reg_src[1]).r_uint64();
  Register res;

  int m = 1;
  int s = inst.size();
  bool a = inst.arith();
  bool simd = inst.simd();

  switch(op)
    {
      //    case OP_ADDI:
    case OP_ADD:
      if (s==0)
	{
	  if(simd) m = 8;
	  for (int i=0;i<m;i++)
	    if(a) res.s_int8(i,src1.r_int8(i) + src2.r_int8(i));
	    else res.s_uint8(i,src1.r_uint8(i) + src2.r_uint8(i));
	}
      else if(s==1)
	{
	  if(simd) m = 4; 
	  for (int i=0;i<m;i++)
	    if(a) res.s_int16(i,src1.r_int16(i) + src2.r_int16(i));
	    else res.s_uint16(i,src1.r_uint16(i) + src2.r_uint16(i));
	}
      else if(s==2)
	{
	  if(simd) m = 2; 
	  for (int i=0;i<m;i++)
	    if(a) res.s_int32(i,src1.r_int32(i) + src2.r_int32(i));
	    else res.s_uint32(i,src1.r_uint32(i) + src2.r_uint32(i));
	}
      else if(s==3)
	{
	  if(a) res.s_int64(src1.r_int64() + src2.r_int64()); 
	  else res.s_uint64(src1.r_uint64() + src2.r_uint64());
	}
      break;

    case OP_SUB:
      if (s==0)
	{
	  if(simd) m = 8;
	  for (int i=0;i<m;i++)
	    if(a) res.s_int8(i,src1.r_int8(i) - src2.r_int8(i));
	    else res.s_uint8(i,src1.r_uint8(i) - src2.r_uint8(i));
	}
      else if(s==1)
	{
	  if(simd) m = 4;
	  for (int i=0;i<m;i++)
	    if(a) res.s_int16(i,src1.r_int16(i) - src2.r_int16(i));
	    else res.s_uint16(i,src1.r_uint16(i) - src2.r_uint16(i));
	}
      else if(s==2)
	{
	  if(simd) m = 2;
	  for (int i=0;i<2;i++)
	    if(a) res.s_int32(i,src1.r_int32(i) - src2.r_int32(i));
	    else res.s_uint32(i,src1.r_uint32(i) - src2.r_uint32(i));
	}
      else if(s==3)
	{
	  if(a) res.s_int64(src1.r_int64() - src2.r_int64()); 
	  else res.s_uint64(src1.r_uint64() - src2.r_uint64());
	}
      break;

    case OP_MUL:
      if (s==0)
	{
	  if(simd) m = 8;
	  for (int i=0;i<m;i++)
	    if(a) res.s_int8(i,src1.r_int8(i) * src2.r_int8(i));
	    else res.s_uint8(i,src1.r_uint8(i) * src2.r_uint8(i));
	}
      else if(s==1)
	{
	  if(simd) m = 4;
	  for (int i=0;i<m;i++)
	    if(a) res.s_int16(i,src1.r_int16(i) * src2.r_int16(i));
	    else res.s_uint16(i,src1.r_uint16(i) * src2.r_uint16(i));
	}
      else if(s==2)
	{
	  if(simd) m = 2;
	  for (int i=0;i<2;i++)
	    if(a) res.s_int32(i,src1.r_int32(i) * src2.r_int32(i));
	    else res.s_uint32(i,src1.r_uint32(i) * src2.r_uint32(i));
	}
      else if(s==3)
	{
	  if(a) res.s_int64(src1.r_int64() * src2.r_int64()); 
	  else res.s_uint64(src1.r_uint64() * src2.r_uint64());
	}
      break;

    case OP_DIV:
      if (s==0)
	{
	  if(simd) m = 8;
	  for (int i=0;i<m;i++)
	    if(a) res.s_int8(i,src1.r_int8(i) / src2.r_int8(i));
	    else res.s_uint8(i,src1.r_uint8(i) / src2.r_uint8(i));
	}
      else if(s==1)
	{
	  if(simd) m = 4;
	  for (int i=0;i<m;i++)
	    if(a) res.s_int16(i,src1.r_int16(i) / src2.r_int16(i));
	    else res.s_uint16(i,src1.r_uint16(i) / src2.r_uint16(i));
	}
      else if(s==2)
	{
	  if(simd) m = 2;
	  for (int i=0;i<2;i++)
	    if(a) res.s_int32(i,src1.r_int32(i) / src2.r_int32(i));
	    else res.s_uint32(i,src1.r_uint32(i) / src2.r_uint32(i));
	}
      else if(s==3)
	{
	  if(a) res.s_int64(src1.r_int64() / src2.r_int64()); 
	  else res.s_uint64(src1.r_uint64() / src2.r_uint64());
	}
      break;

    case OP_MOD:
      if (s==0)
	{
	  if(simd) m = 8;
	  for (int i=0;i<m;i++)
	    if(a) res.s_int8(i,src1.r_int8(i) % src2.r_int8(i));
	    else res.s_uint8(i,src1.r_uint8(i) % src2.r_uint8(i));
	}
      else if(s==1)
	{
	  if(simd) m = 4;
	  for (int i=0;i<m;i++)
	    if(a) res.s_int16(i,src1.r_int16(i) % src2.r_int16(i));
	    else res.s_uint16(i,src1.r_uint16(i) % src2.r_uint16(i));
	}
      else if(s==2)
	{
	  if(simd) m = 2;
	  for (int i=0;i<2;i++)
	    if(a) res.s_int32(i,src1.r_int32(i) % src2.r_int32(i));
	    else res.s_uint32(i,src1.r_uint32(i) % src2.r_uint32(i));
	}
      else if(s==3)
	{
	  if(a) res.s_int64(src1.r_int64() % src2.r_int64()); 
	  else res.s_uint64(src1.r_uint64() % src2.r_uint64());
	}

      break;
    default:
      return;
      break;
    }

  regs().write_register (reg_dest[0], Register(res));

}
