#ifndef ASM_HH
#define ASM_HH
#include "fcpu_asm.h"
#include "flags.hh"

// struct eqstr
//
// present for hastables.
//
struct eqstr
{
  inline bool operator()(const char* s1, const char* s2) const
  {
    return strcmp(s1, s2) == 0;
  }
};

class opline
{
public:
  char* opcode;
  char* label;
  char* op[3];
  char  optype[3];
  int imm;
  int nop;

  opline()
    {
      label = opcode = NULL;
      for(int i=0;i<3;i++) 
	{
	  op[i]=NULL;
	  optype[i]=0;
	}
      imm = nop = 0;
    }

  void clear()
    {
      if(opcode!=NULL) { delete [] opcode; opcode=NULL;	}
      if(label!=NULL) { delete [] label; label=NULL;	}
      for(int i=0;i<3;i++) 
	{
	  if(op[i]!=NULL) { delete [] op[i]; op[i]=NULL; }
	  optype[i]=0;
	}
      imm = nop = 0;
    }

  ~opline() { clear(); }
};

#define O_NO  1
#define O_REG 2
#define O_NUM 4
#define O_ARR 8
#define O_ARI 16
#define O_LAB 32

typedef unsigned int flag_func(char *);

typedef struct opgen
{
  char *mnemonic;
  unsigned int opcode;
  char format;
  char operand[3][2];
  flag_func *flags;
};

opgen gen_array[] = 
{
  {"mov",    OP_MOV,    2, {{O_REG, 2},{O_REG, 1},{O_NO,  0}}, &size_flags},
  {"cmov",   OP_MOV,    3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &size_flags},  
  {"add",    OP_ADD,    3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &size_flags},
  {"sub",    OP_SUB,    3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &size_flags},
  {"mul",    OP_MUL,    3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &size_flags},
  {"div",    OP_DIV,    3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &size_flags},
  {"mod",    OP_MOD,    3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &size_flags},
  {"logic",  OP_LOGIC,  3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &size_flags},
  {"loadcons",OP_LOADCONS, 1, {{O_NUM, 16},{O_REG,1},{O_NO,  0}}, &no_flags},
  {"load",   OP_LOAD,   2, {{O_ARR, 2},{O_REG, 1},{O_NO,  0}}, &size_flags},
  {"store",  OP_STORE,  2, {{O_REG, 3},{O_ARR, 1},{O_NO,  0}}, &size_flags},
  {"get",    OP_GET,    3, {{O_REG, 2},{O_REG, 2},{O_NO,  0}}, &no_flags},
  {"put",    OP_PUT,    3, {{O_REG, 2},{O_REG, 2},{O_NO,  0}}, &no_flags},
  {"shift",  OP_SHIFT,  2, {{O_REG, 2},{O_NUM, 6},{O_REG, 1}}, &size_flags},
  {"rot",    OP_ROT,    2, {{O_REG, 2},{O_NUM, 6},{O_REG, 1}}, &size_flags},
  {"jmpa",   OP_JMPA,   1, {{O_REG, 1},{O_NO,  0},{O_NO,  0}}, &no_flags},
  {"cjmpa",  OP_JMPA,   2, {{O_REG, 2},{O_REG, 1},{O_NO,  0}}, &no_flags},
  {"loopentry",OP_LOOPENTRY,1,{{O_REG,  1},{O_NO,  0},{O_NO,  0}}, &no_flags},
  {"loop",   OP_LOOP,   2, {{O_REG, 2},{O_REG, 1},{O_NO,  0}}, &no_flags},
  {"syscall",OP_SYSCALL,1, {{O_NUM,18},{O_NO,  0},{O_NO,  0}}, &no_flags},
  {"csyscall",OP_SYSCALL,1,{{O_REG, 1},{O_NUM,18},{O_NO,  0}}, &no_flags},
  {"trap",   OP_TRAP,   1, {{O_NUM,18},{O_NO,  0},{O_NO,  0}}, &no_flags},
  {"ctrap",  OP_TRAP,   1, {{O_REG, 1},{O_NUM,18},{O_NO,  0}}, &no_flags}
};

/*
  {"addi",   OP_ADDI,   2, {{O_REG, 2},{O_NUM, 8},{O_REG, 1}}, &size_flags},
  {"subi",   OP_SUBI,   2, {{O_REG, 2},{O_NUM, 8},{O_REG, 1}}, &size_flags},
  {"muli",   OP_MULI,   2, {{O_REG, 2},{O_NUM, 8},{O_REG, 1}}, &size_flags},
  {"divi",   OP_DIVI,   2, {{O_REG, 2},{O_NUM, 8},{O_REG, 1}}, &size_flags},
  {"modi",   OP_MODI,   2, {{O_REG, 2},{O_NUM, 8},{O_REG, 1}}, &size_flags},
  {"test",   OP_TEST,   3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &size_flags},
  {"loadi",  OP_LOADI,  3, {{O_ARI, 2},{O_REG, 1},{O_NO,  0}}, &size_flags},
  {"storei", OP_STORE,  2, {{O_REG, 2},{O_ARI, 1},{O_NO,  0}}, &size_flags},
  {"geti",   OP_GETI,   2, {{O_NUM,16},{O_REG, 1},{O_NO,  0}}, &no_flags},
  {"puti",   OP_PUTI,   2, {{O_REG, 1},{O_NUM,16},{O_NO,  0}}, &no_flags},
  {"fadd",   OP_FADD,   3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &fp_flags},
  {"fsub",   OP_FSUB,   3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &fp_flags},
  {"fmul",   OP_FMUL,   3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &fp_flags},
  {"fdiv",   OP_FDIV,   3, {{O_REG, 3},{O_REG, 2},{O_REG, 1}}, &fp_flags},
  {"jmpi",   OP_JMPI,   2, {{O_REG, 2},{O_NUM,12},{O_NO,  0}}, &no_flags},
  {"cjmpi",  OP_JMPI,   2, {{O_REG, 2},{O_REG, 1},{O_NUM,12}}, &no_flags},
  {"jmpr",   OP_JMPR,   1, {{O_NUM|O_LAB,18},{O_NO,0},{O_NO,  0}}, &no_flags},
  {"cjmpr",  OP_JMPR,   1, {{O_REG, 1},{O_NUM|O_LAB,18},{O_NO,  0}}, &no_flags},

*/

#endif
