#include <fstream>
#include <hash_map>
#include <stdio.h>
#include <unistd.h>
#include "asm.hh"

// bool is_whitespace(char c)
//
// returns true if c is a white space (space or tab)
// or else it returns false.
//
inline bool is_whitespace(char c) { return ((c==' ')||(c=='\t')); }


// unsigned int parse_reg(char *str, int regn)
// 
// parses a string (str) containing a register
// reference and outputs the value in the
// right position (position regn) for the
// instruction.
//
unsigned int parse_reg(char *str, int regn)
{
  if((str[0]=='%')&&(str[1]=='r'))
    {
      unsigned int rg = atoi(str+2);
      if((rg < 64)&&(rg>=0))
	{
	  rg = rg << (32-6*regn);
	  printf("    Register %x\n", rg);
	  return rg;
	}
    }
  return 0;
}

// unsigned int parse_num(char *str, int imml, int insf)
// 
// parses a string (str) containing an
// immediate value and outputs the value
// in the right position (position insf) 
// with the right size (imml) for the
// instruction.
//

unsigned int parse_num(char *str, int imml, int insf)
{
  if(str[0]=='$')
    {
      unsigned int rg = atoi(str+1);
      rg = (rg % (1 << imml )) << 32-(insf * 6);
      printf("    Immediate %x\n", rg);
      return rg;
    }
  return 0;
}

// unsigned int parse_add(char *str, int insf)
// 
// parses a string (str) containing an
// address and outputs the value
// in the right position (position insf) 
// for the instruction.
// !! Warning supports only adresses with
// one register reference !!!!
//
unsigned int parse_add(char *str, int insf)
{
  if((str[0]=='[')&&(str[1]=='%')&&(str[2]=='r'))
    {
      unsigned int rg = atoi(str+2);
      if((rg < 64)&&(rg>=0))
	{
	  rg = rg  << ( insf * 6 );
	  printf("    Address RR %x\n", rg);
	  return rg;
	}
    }
  return 0;
}

// unsigned int assemble_instruction(opline &op)
//
// Takes an opline (op) and generates the
// corresponding instruction.
//
unsigned int assemble_instruction(opline &op)
{
  unsigned int rv = 0;
  for(int i=0;i<(sizeof(gen_array)/sizeof(opgen));i++)
    {
      int len = strlen(gen_array[i].mnemonic);
      if (strncmp(op.opcode, gen_array[i].mnemonic, len)==0)
	{
	  rv = gen_array[i].opcode;
	  printf("  Opcode %x\n", rv);
	  unsigned int fl = gen_array[i].flags(op.opcode + len);
	  printf("  Flags %x\n", fl);
	  rv = rv | fl;
	  for(int j=0;(j<3)&(op.op[j]!=NULL);j++)
	    {
	      cout << "     optype " << int(gen_array[i].operand[j][0]) <<
		" oparg " << int (gen_array[i].operand[j][1]) << 
		" arg " << op.op[j] << endl;
	      switch(gen_array[i].operand[j][0])
		{
		case O_REG:
		  cout << "    parse_reg\n";
		  rv=rv | parse_reg(op.op[j],gen_array[i].operand[j][1]);
		  break;

		case O_NUM: 
		  cout << "    parse_num\n";
		  rv =rv | parse_num(op.op[j], gen_array[i].operand[j][1],
				     gen_array[i].format);
		  break;
		case O_ARR:
		  cout << "    parse_add\n";
		  rv =rv | parse_add(op.op[j], gen_array[i].operand[j][1]);
		  break;

		case O_NO: cout << "    blank" << endl;
		default:
		  break;
		}
	    }
	  return rv;
	}
    }
  printf("Error opcode doesn't exist\n");
  return 0;
}

// bool find_statement(char *str, int *start, int *end)
//
// parses a string (str) and determinates
// if it contains a statement. returns
// true if it finds one (else returns
// false), and stores the index where the
// statement starts and ends (in start
// and end respectively)
//
bool find_statement(char *str, int *start, int *end)
{
  int i;
  for(i=0;(is_whitespace(str[i]) && (str[i]!='\0'));i++);
  if((str[i]=='\0')||(str[i]=='#')) return false;
  *start = i;
  for(;((str[i]!=':') && (str[i]!='#') && (str[i]!='\0'));i++);
  if (str[i]=='#') i--;
  *end = i;
  return true;
}

// char *strcpyspn(char* str, int start, int end)
//
// creates a new string containing a 
// substring of str (from index start
// to end).
//
char *strcpyspn(char* str, int start, int end)
{
  cout << "    Extract " << "[" << start << "," << end 
       << "] from \"" << str << "\"" << endl;
  int i = end-start+1, j;
  if (i<=1) return NULL;
  char *tmp = new char[i];
  for(j=0;j<i;j++)
    tmp[j] = str[j+start];
  tmp[j] = '\0';
  return tmp;
}

// char *find_operand(char *str, int *last)
// 
// parses a string and returns a copy
// of the first operand it finds. it
// also stores the index of the end
// of the found operand into last.
//
char *find_operand(char *str, int *last)
{
  int i, j;
  for(i = 0;(is_whitespace(str[i]))&&(str[i]!='\0');i++);
  if(str[i]=='\0') return NULL;
  for(j = 0;(str[j]!=',')&&(str[j]!='\0');j++);
  *last = j; 
  return strcpyspn(str, i, j-1);
}

// unsigned int decompose_instruction(char *string, opline &op)
//
// parses a string (str) and creates an
// opline object.
//
unsigned int decompose_instruction(char *str, opline &op)
{ 
  int i, j, k;
  char *hello;

  cout << "    Found instruction \"" << str << "\"\n";

  for(i=0;(!is_whitespace(str[i]))&&(str[i]!='\0');i++);

  op.opcode = strcpyspn(str, 0, i - 1);

  cout << "    Opcode : \"" << op.opcode << "\"" << endl;
  
  for(k=0;k<3;k++)
    {
      op.op[k] = find_operand(str + i, &j);
      cout << "    Operand " << k << ": \"" << op.op[k] << "\"" << endl;
      i += j;
      if (op.op[k]==NULL) k=3;
      else
	{
	  op.nop++;
	  if (str[i]=='\0') k=3;
	  else i++;
	}
    }
}

int main(int argc, char **argv)
{
  hash_map<const char*, int, hash<const char*>, eqstr> labels;
  char string[256], *tmp;
  int start = 0, end = 0, i, j;
  int line, nop;
  bool statement;
  int instructions = 0;

  if(argc<2) return -1;

  ifstream source(argv[1]);

  if(argc==3)
    tmp = argv[2];
  else
    tmp = "out.o";

  ofstream object(tmp);

  while(source)
    {
      source.getline(string, 256);
      cout << "New Line" << endl;
      statement = find_statement(string, &start, &end);
      tmp = strcpyspn(string, start, end);
      
      if (statement)
	{

	  if (string[end]==':')
	    {
	      if(labels.count(tmp)!=0)
		cout << "Warning label \"" << tmp 
		     << "\" already exists.";
	      labels[tmp] = instructions;
	      cout << "found label \"" << tmp << "\" at adress ";
	      cout << instructions << endl;
	    }
	  else 	
	    {
	      opline op;
	      instructions++;
	      printf("  Decomposing\n");
	      decompose_instruction(tmp, op);
	      printf("  Assembling\n");
	      unsigned int inst = assemble_instruction(op);
	      printf("  Instruction # %d: %x \n", instructions, inst);

	      unsigned char tmp[5];
	      memcpy(tmp, &inst, 4);
	      tmp[4]='\0';
	      printf("  %.2x %.2x %.2x %.2x\n", int(tmp[0]), int(tmp[1]),
		     int(tmp[2]), int(tmp[3]));
	      printf("  %.2x %.2x %.2x %.2x\n", int(tmp[3]), int(tmp[2]), 
		     int(tmp[1]), int(tmp[0]));
	      object.write(&inst, 4);
	    }
	}
      else
	{
	  cout << "Found nothing \"" << string + start << "\"\n";
	}
      delete [] tmp;
      string[0]='\0';
      start = 0;
    }
  source.close();
  object.close();
}
