#ifndef __FCPU_ASM_H__
#define __FCPU_ASM_H__

#define SIZE_B                   0 // byte (8bit)
#define SIZE_D                   1 // double byte (16bit)
#define SIZE_Q                   2 // quad byte (32bit)
#define SIZE_W                   3 // word (64bit)

#define ARITHM_UNSIGNED          8   
#define ARITHM_SIMD             16  
#define ARITHM_SUB              32   
#define ARITHM_MOD              32   

#define TEST_EQ                  0 // equal to
#define TEST_NQ                  1 // not equal to
#define TEST_GT                  2 // greater than
#define TEST_GE                  3 // greater than or equal
#define TEST_LT                  4 // less than
#define TEST_LE                  5 // less than or equal to
#define TEST_CF                  6 // carry flag set
#define TEST_CZ                  7 // zero flag set

#define SHIFT_LEFT               0 // shift/rotate left
#define SHIFT_RIGHT              8 // shift/rotate right
#define SHIFT_ARITHMETIC         4 // arithmetic shift/rotate

#define LOGIC_AND                1 // 0001
#define LOGIC_XOR                6 // 0110
#define LOGIC_OR                 7 // 0111

#define FLOAT_DOUBLE             0 // double size float op
#define FLOAT_FLOAT              1 // float size float op
#define FLOAT_SIMD               2 // SIMD float instruction
#define FLOAT_INT2F              0 // int2float flag
#define FLOAT_F2INT             32 // float2int flag
#define FLOAT_ROUND_UP           0 // round up
#define FLOAT_ROUND_DOWN         4 // round down
#define FLOAT_ROUND_NEAREST      8 // round to nearest
#define FLOAT_ROUND_TRUNCATE    12 // truncate the fraction

#define PR_NONE                  0 // no prediction register
#define PR_1                     1 // prediction register 1
#define PR_2                     2 // prediction register 2
#define PR_3                     3 // prediction register 3

#define OP_ADD                   0
#define OP_SUB                   0 // Same as OP_ADD
#define OP_ADDI                  2
#define OP_SUBI                  2 // Same as OP_ADDI
#define OP_MUL                   4
#define OP_MULI                  5
#define OP_DIV                   6
#define OP_MOD                   6 // Same as OP_DIV
#define OP_DIVI                  8
#define OP_MODI                  9 // Same as OP_DIVI
#define OP_LOGIC                10
#define OP_TEST                 11
#define OP_LOAD                 12
#define OP_STORE                13
#define OP_MOV                  14
#define OP_GET                  15
#define OP_PUT                  16
#define OP_PREFETCH             17
#define OP_SHIFT                18
#define OP_ROT                  19
#define OP_FADD                 20
#define OP_FSUB                 21 // Same as OP_FADD
#define OP_FMUL                 22
#define OP_FINV                 23
#define OP_FDIV                 24
#define OP_FSQRT                25
#define OP_FINVSQRT             26
#define OP_INT2F                27  // set flags |= float_int2f
#define OP_F2INT                27  // set flags |= float_f2int
#define OP_JMPRA                28
#define OP_JMPRIA               29
#define OP_JMPIR                30
#define OP_SYSCALL              31
#define OP_TRAP                 32

typedef struct 
{
  unsigned char opcode;              // op_*
  unsigned int  reg1;                // register A
  unsigned int  reg2;                // register B
  unsigned int  reg3;                // register C
  unsigned long int imm;             // imm8, imm16, or imm21
  unsigned char flags;               // combined flags
  unsigned char format;              // form 1,2,3,4
  unsigned char size;                // SIZE
  unsigned char simd;                // SIMD
  unsigned char arithm;              //
  unsigned char logic;               // LOGIC_*
  unsigned char roundmode;           // FLOAT_ROUND_*
  unsigned char direc;               // 
  unsigned char predication;         // PR_*
  unsigned char targetlabel[64];     // label to jump to, or reference
                                     // in some other way
} f_cpu_intermediate;

//          ARITH FPU SHIFT L/S  CONTROL TEST
// UNSIGNED   X
// ARITH      X                           
// SIMD       X    X    ?
// SIZE       X         X    X            
// ROUND           X
// DIREC           X    X
// PRED                      X      X     X
// TEST                                   X

typedef struct 
{
  unsigned char label[64];           // label name
  unsigned char type;                
  // 0 == assembler code label,
  // 1 == byte,
  // 2 == dbyte,
  // 3 == qbyte, 
  // 4 == word,
  // 5 == asciz,
  // 6 == array
  union 
  {
    f_cpu_intermediate* code;
    unsigned char* asciz;
    unsigned char byte;
    unsigned int dbyte;
    unsigned long int qbyte;
    unsigned long int word[2];
    unsigned long int* array;
  } data;
  unsigned long int length; 
  // if 0, and type assembler code 
  // label, points into the middle
  // of a peice of code, not the
  // beginning of some code.
} f_cpu_label;

#endif
