%{
#include "globals.h"
#include "y.tab.h"
extern NEW_YYSTYPE yylval;
%}

%%
"add"           { return ADD; }
"sub"           { return SUB; }
"mul"           { return MUL; }
"div"           { return DIV; }
"mod"           { return MOD; }
"shift"         { return SHIFT; }
"rot"           { return ROT; }
"mov"           { return MOV; }
"load"          { return LOAD; }
"store"         { return STORE; }
"test"          { return TEST; }
"jmpra"         { return JMPRA; }
"jmpir"         { return JMPIR; }
"jmpria"        { return JMPRIA; }
"fadd"          { return FADD; }
"fsub"          { return FSUB; }
"fmul"          { return FMUL; }
"fdiv"          { return FDIV; }
"fsqrt"         { return FSQRT; }
"finv"          { return FINV; }
"finvsqrt"      { return FINVSQRT; }
"int2f"         { return INT2F; }
"f2int"         { return F2INT; }
"and"           { return AND; }
"or"            { return OR; }
"xor"           { return XOR; }
"logic"         { return LOGIC; }
"get"           { return GET; }
"put"           { return PUT; }
"prefetch"      { return PREFETCH; }
"syscall"       { return SYSCALL; }
"trap"          { return TRAP; }

"["             { return OP_BRACKET; }
"]"             { return CL_BRACKET; }
"("             { return OP_PAREN; }
")"             { return CL_PAREN; }
":"             { return COLON; }
","             { return COMMA; }
"+"             { return PLUS; }
"-"             { return MINUS; }
"*"             { return STAR; }
"$"             { return DOLLAR; }
"."             { return DOT; }
\n              { return EOL; }

[a-zA-Z][a-zA-Z0-9_]*   { strcpy(yylval.text,yytext); 
                  return (yylval.token = IDENTIFIER); }
[%]r[0-9]+      { strcpy(yylval.text,yytext+2);
                  yylval.ival = atoi(yytext+2);
                  return REGISTER; }
[-]?[0-9]+      { strcpy(yylval.text,yytext); 
                  yylval.ival = atoi(yytext); 
                  return (yylval.token = INTEGER); }
[ \t]*          { ; }
%%
