/*

WINUTILS.C : Whygee's dirty and small X11 library.

*/


/*
   rev.2 : if (gc!=NULL)... 
   rev.3 : ifndef... pour eviter l'inclusion multiple, et aussi
    KeyPressMask pour gerer le clavier, MotionNotify pour la souris...
   rev 4 pour le F-CPU
   rev 5 : english...
*/

#ifndef winutils

#define winutils

#include <string.h>
#include <stdio.h>

/* external files */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
char font_name[]="-ADOBE-NEW CENTURY SCHOOLBOOK-MEDIUM-R-NORMAL--*-140-*-*-P-*";

/*  Window attribute when creating it...  */
#define HIDDEN 1
#define SHOWN 0
#define TRUE 1
#define FALSE 0

/* color definition : */
char *color_table[] = {
 "dark slate blue",
 "light grey",
 "firebrick",
 "blue",
 "red",
 "green",
 "white",
 "black",
 "grey",
 "yellow",
 "orange",
 "sea green",
 "dim grey",
 "grey55" };
#define dark_slate_blue 0
#define light_grey 1
#define firebrick 2
#define blue 3
#define red 4
#define green 5
#define white 6
#define black 7
#define grey 8
#define yellow 9
#define orange 10
#define seagreen 11
#define dim_grey 12
#define grey55 13
/* for more colors, lookup /usr/X11/lib/X11/rgb.txt */

/* Some global variables that makes life a lot  easier :-) */
Font font;
Display *dpy;
Screen *screen;
XSetWindowAttributes xswa;
XSizeHints xsh;
XGCValues xgcv;

static void exitX ()
{
  XCloseDisplay (dpy);
}

void error(const char *str)
{
  fprintf(stderr,"\nerror: %s\n",str);
  exitX();
  exit(1);  
}

/* to be called before any window is displayed */
static void init_X ()
{
  dpy = XOpenDisplay(0);
  if (!dpy)
    error ("Can't open display !\n");
  screen = XDefaultScreenOfDisplay (dpy);
  XSynchronize (dpy, 1);
  xgcv.font = XLoadFont (dpy, font_name); /* I have experienced some troubles with XLoadQueryFont */
  xgcv.line_width = 5; /* F-CPU */
  xgcv.line_style = LineSolid;
}

static int doDefineColor (char a)
{
  XColor exact_color, screen_color;
  if (XAllocNamedColor (dpy,XDefaultColormapOfScreen (screen),
    color_table[a], &screen_color, &exact_color))
    return screen_color.pixel;
  fprintf(stderr,"\nProblem with %s",color_table[a]);
  error("Color not allocated. (lazy allocation)");
  return 0;
}

static void open_window (Window *win_, int win_width, int win_height,
      GC *gc, char win_foreground, char win_background, char *win_name, int hidden)
{
  xsh.x = 0;
  xsh.y = 0;
  xsh.width = win_width;
  xsh.height = win_height;
  xsh.flags = PPosition | PSize ;
  xswa.event_mask = ButtonPressMask | ExposureMask | KeyPressMask |
    PointerMotionMask | ButtonReleaseMask | ResizeRedirectMask;
  xswa.background_pixel = doDefineColor(win_background);
  xgcv.background = xswa.background_pixel;
  xgcv.foreground = doDefineColor (win_foreground);
  *win_ = XCreateWindow( dpy,XRootWindowOfScreen (screen),
    0, 0, win_width, win_height, 0, XDefaultDepthOfScreen (screen), InputOutput,
    XDefaultVisualOfScreen (screen), CWEventMask | CWBackPixel , &xswa);
  XStoreName (dpy, *win_,win_name);
  if (hidden!=HIDDEN)
    XMapWindow (dpy, *win_);
  XSetNormalHints (dpy, *win_,&xsh);
  if (gc!=NULL)
    *gc = XCreateGC (dpy, *win_, GCForeground | GCBackground | GCFont
           | GCLineWidth | GCLineStyle, &xgcv);
}

static void open_daughter_window (Window *win_,
   Window mother_win, int pos_x, int pos_y, int win_width, int win_height,
   GC *gc, char win_foreground, char win_background, int thickness)
{
  xsh.x = pos_x;
  xsh.y = pos_y;
  xsh.width = win_width;
  xsh.height = win_height;
  xsh.flags = PPosition | PSize;
  xswa.event_mask = ButtonPressMask | ExposureMask | KeyPressMask |
    PointerMotionMask | ButtonReleaseMask | ResizeRedirectMask;
  xswa.background_pixel = doDefineColor(win_background);
  xgcv.background = xswa.background_pixel;
  xgcv.foreground = doDefineColor(win_foreground);
  *win_ = XCreateWindow (dpy, mother_win, pos_x, pos_y, win_width,
     win_height, thickness,XDefaultDepthOfScreen(screen), InputOutput,
     XDefaultVisualOfScreen(screen),CWEventMask | CWBackPixel , &xswa);
  XMapWindow (dpy, *win_);
  XSetNormalHints (dpy, *win_, &xsh);
  if (gc!=NULL)
    *gc = XCreateGC (dpy, *win_,GCForeground | GCBackground | GCFont
           | GCLineWidth | GCLineStyle, &xgcv);
}

static void close_window (Window *win_)
{
  XUnmapWindow (dpy, *win_);
  XDestroyWindow (dpy, *win_);
}

#endif
