#include <string.h>

#include "winutils.c"

/* X11 stuffs */

/* main window */
int main_xsize=600, main_ysize=600;  
Window win_main;
Window button_quit; /*  10,10,45,17 */
Window button_init; /*  70,10,45,17 */
Window button_step; /* 125,10,45,17 */
Window button_mem;  /*  10,50,main_xsize-26, 50 */

Window button_LSU;       
Window button_LSU_tags;
Window button_fetch_logic;
Window button_fetcher_tags;
Window button_fetcher;

Window button_TLB;
Window button_decoder;

Window button_scoreboard;
Window button_register;
Window button_SR;

Window button_Xbar;

Window button_ROP2;
Window button_INC;
Window button_SHUFFLER;
Window button_ASU;
Window button_IMU;
Window button_IDU;

XSegment main_segments[30];

/* memory window */

int mem_xsize=400, mem_ysize=400;
Window win_mem;
Window button_hide_mem;
int hide_mem=HIDDEN;

/* Fetcher window */
int fetcher_xsize=400, fetcher_ysize=400;
Window win_fetcher;
Window button_hide_fetcher;
int hide_fetcher=HIDDEN;

/* Fetcher_tags window */

int fetcher_tags_xsize=500, fetcher_tags_ysize=500;
Window win_fetcher_tags;
Window button_hide_fetcher_tags;
int hide_fetcher_tags=HIDDEN;

/* LSU_tags window */

int LSU_tags_xsize=400, LSU_tags_ysize=400;
Window win_LSU_tags;
Window button_hide_LSU_tags;
int hide_LSU_tags=HIDDEN;

/* LSU window */

int LSU_xsize=400, LSU_ysize=400;
Window win_LSU;
Window button_hide_LSU;
int hide_LSU=HIDDEN;

/* TLB window */

int TLB_xsize=400, TLB_ysize=400;
Window win_TLB;
Window button_hide_TLB;
int hide_TLB=HIDDEN;

/* Xbar window */
int Xbar_xsize=400, Xbar_ysize=400;
Window win_Xbar;
Window button_hide_Xbar;
int hide_Xbar=HIDDEN;

/* decoder window */

int decoder_xsize=400, decoder_ysize=400;
Window win_decoder;
Window button_hide_decoder;
int hide_decoder=HIDDEN;

/* register window */

int register_xsize=400, register_ysize=400;
Window win_register;
Window button_hide_register;
int hide_register=HIDDEN;

/* scoreboard window */

int scoreboard_xsize=400, scoreboard_ysize=400;
Window win_scoreboard;
Window button_hide_scoreboard;
int hide_scoreboard=HIDDEN;


/* Bus Arbiter window */

int fetch_logic_xsize=400, fetch_logic_ysize=400;
Window win_fetch_logic;
Window button_hide_fetch_logic;
int hide_fetch_logic=HIDDEN;

/* Special Registers window */

int SR_xsize=400, SR_ysize=400;
Window win_SR;
Window button_hide_SR;
int hide_SR=HIDDEN;

/* ROP2 unit window */

int ROP2_xsize=400, ROP2_ysize=400;
Window win_ROP2;
Window button_hide_ROP2;
int hide_ROP2=HIDDEN;

/* INC unit window */

int INC_xsize=400, INC_ysize=400;
Window win_INC;
Window button_hide_INC;
int hide_INC=HIDDEN;

/* SHUFFLER unit window */

int SHUFFLER_xsize=400, SHUFFLER_ysize=400;
Window win_SHUFFLER;
Window button_hide_SHUFFLER;
int hide_SHUFFLER=HIDDEN;

/* Add/Sub Unit window */

int ASU_xsize=400, ASU_ysize=400;
Window win_ASU;
Window button_hide_ASU;
int hide_ASU=HIDDEN;

/* IMU window */

int IMU_xsize=400, IMU_ysize=400;
Window win_IMU;
Window button_hide_IMU;
int hide_IMU=HIDDEN;

/* IDU window */
 
int IDU_xsize=400, IDU_ysize=400;
Window win_IDU;
Window button_hide_IDU;
int hide_IDU=HIDDEN;



/*  window
int _xsize=400, _ysize=400;
Window win_;
Window button_hide_;
int hide_=HIDDEN;
*/

long int resize_flag=-1L;
int t1,t2,t3,i;

GC gc,gc1,gc2;
XEvent event;
KeySym keysym;
char car;

void main(int argc, char **argv)
{

  /* read the init file here, eventually remember the window positions.... */

  /* init the simulation here */

  /* X11 */
  init_X();

redisplay:

  if (resize_flag & 1L<<0) {
    if (main_xsize<350) {
      main_xsize=350;
    }
    if (main_ysize<350) {
      main_ysize=350;
    }
    open_window(&win_main,main_xsize, main_ysize,&gc,black,grey,"MAIN WINDOW",SHOWN);
    open_daughter_window (&button_quit, win_main,  10, 10, 45, 17, &gc, black, light_grey, 1);
    open_daughter_window (&button_init, win_main,  70, 10, 45, 17, &gc, black, light_grey, 1);
    open_daughter_window (&button_step, win_main, 125, 10, 45, 17, &gc, black, light_grey, 1);

    open_daughter_window (&button_mem,win_main,10,50,main_xsize-26,50,&gc2,black,grey55, 3);
    
    t1=((main_xsize-20)/9);
    t2=((main_ysize-150)/5);

    open_daughter_window (&button_LSU,         win_main,       10, 130, (t1*3)-4, t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_LSU_tags,    win_main,(t1*3)+10, 130, t1-4,     t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_fetch_logic, win_main,(t1*4)+10, 130, t1-4,     t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_fetcher_tags,win_main,(t1*5)+10, 130, t1-4,     t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_fetcher,     win_main,(t1*6)+10, 130, (t1*3)-4, t2-10, &gc, black, light_grey, 3);
    
    /* memory-LSU, memory-fetcher */
    main_segments[0].x1=main_segments[0].x2=(t1*3)>>1;
    main_segments[1].x1=main_segments[1].x2=(t1*15)>>1;
    main_segments[0].y1=main_segments[1].y1=100;
    main_segments[0].y2=main_segments[1].y2=130;

    /* fetcher -> tags + decoder */
    main_segments[6].y1=main_segments[7].y1=
    main_segments[2].y2=main_segments[3].y2=main_segments[4].y2=t2+120;
    main_segments[2].y1=main_segments[3].y1=main_segments[5].y1=main_segments[5].y2=t2+140;
    main_segments[6].y2=main_segments[7].y2=main_segments[4].y1=t2+160;
    main_segments[2].x1=main_segments[2].x2=main_segments[5].x1=(t1*7)>>1;
    main_segments[3].x1=main_segments[3].x2=(t1*11)>>1;
    main_segments[4].x1=main_segments[4].x2=main_segments[5].x2=(t1*15)>>1;
    /* TLB->tags */
    main_segments[6].x1=main_segments[6].x2=main_segments[5].x1+12;
    main_segments[7].x1=main_segments[7].x2=main_segments[3].x1+12;
    
    open_daughter_window (&button_TLB, win_main,
        (((main_xsize-20)*3)>>3)+10, t2+160,
          ((main_xsize-20)>>2), t2-20, &gc, black, light_grey, 3);
    open_daughter_window (&button_decoder, win_main,
         (t1*6)+30, t2+160, (t1*3)-30, t2-10, &gc, black, light_grey, 3);
    
    open_daughter_window (&button_scoreboard, win_main,
         (t1*6)+30, (t2*2)+160, (t1*3)-30, t2-30, &gc, black, light_grey, 3);
    open_daughter_window (&button_register, win_main,
         (t1*6)+30, (t2*3)+140, (t1*3)-30, t2+10, &gc, black, light_grey, 3);
    open_daughter_window (&button_SR, win_main,
         (t1*6)+30, (t2*4)+160, (t1*3)-30, t2-30, &gc, black, light_grey, 3);

    open_daughter_window (&button_Xbar, win_main,
         (t1*4)+20, (t2*2)+180, t1, (t2*3)-50, &gc, black, light_grey, 3);

    /* Fetcher-Xbar */
    main_segments[8].x1=main_segments[8].x2=main_segments[9].x1=(t1*6)+10;
    main_segments[9].x2=main_segments[18].x1=main_segments[18].x2=(t1*5)+13;
    main_segments[8].y1=t2+140;
    main_segments[18].y1=(t2<<1)+180;
    main_segments[18].y2=main_segments[8].y2=
     main_segments[9].y1=main_segments[9].y2=(t2*2)+160;

    /* LSU-Xbar */
    main_segments[19].y1=(t2*2)+180;
    main_segments[20].x1=main_segments[19].x1=main_segments[19].x2=(t1*4)+27;
    main_segments[21].y1=main_segments[20].y1=main_segments[20].y2=main_segments[19].y2=(t2*2)+160;
    main_segments[22].x1=main_segments[21].x1=main_segments[21].x2=main_segments[20].x2=(t1*3)+10;
    main_segments[23].y1=main_segments[22].y1=main_segments[22].y2=main_segments[21].y2=t2+140;
    main_segments[23].x1=main_segments[23].x2=main_segments[22].x2=(t1*3)>>1;
    main_segments[23].y2=t2+120;

    /* Xbar-R7 */
    for (i=1; i<8; i++) {
      main_segments[i+9].y1=main_segments[i+9].y2=((i*(t2+10))/6)+(t2*3)+140;
      main_segments[i+9].x1=(t1*5)+20;
      main_segments[i+9].x2=(t1*6)+30;
    } /* + Xbar-SR */
    main_segments[15].y1=main_segments[15].y2=(t2*4)+160+((t2-30)/3);
    main_segments[16].y1=main_segments[16].y2=(t2*4)+160+(((t2-30)*2)/3);

    /* TLB-Xbar */
    main_segments[17].x1=main_segments[17].x2=(main_xsize+20)>>1;
    main_segments[17].y1=(t2<<1)+140;
    main_segments[17].y2=(t2*2)+180;

    t3=((main_ysize-10)-(t2+160));
    open_daughter_window (&button_ROP2, win_main,
          10, t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);
    open_daughter_window (&button_INC, win_main,
          10, (t3/6)+t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);
    open_daughter_window (&button_SHUFFLER, win_main,
          10, (t3/3)+t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);
    open_daughter_window (&button_ASU, win_main,
          10, (t3>>1)+t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);
    open_daughter_window (&button_IMU, win_main,
          10, ((t3<<1)/3)+t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);
    open_daughter_window (&button_IDU, win_main,
          10, ((t3*5)/6)+t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);

    for (i=1; i<7; i++) {
      main_segments[i+23].x1=(t1*4)+20;
      main_segments[i+23].x2=(t1*3)-10;
      main_segments[i+23].y1=(t2*2)+180+((i* ((t2*3)-50))/7);
      main_segments[i+23].y2=t2+160-(t3/12)+((i*t3)/6);
    }
  }

  if (resize_flag & 1L<<1) {
    if (mem_xsize<200) {
      mem_xsize=200;
    }
    if (mem_ysize<200) {
      mem_ysize=200;
    }
    open_window(&win_mem,mem_xsize, mem_ysize,&gc,black,grey,"MEMORY",hide_mem);
    open_daughter_window (&button_hide_mem, win_mem,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<2) {
    if (fetcher_xsize<200) {
      fetcher_xsize=200;
    }
    if (fetcher_ysize<200) {
      fetcher_ysize=200;
    }
    open_window(&win_fetcher,fetcher_xsize, fetcher_ysize,&gc,black,grey,"FETCHER WINDOW",hide_fetcher);
    open_daughter_window (&button_hide_fetcher, win_fetcher,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<3) {
    if (fetcher_tags_xsize<200) {
      fetcher_tags_xsize=200;
    }
    if (fetcher_tags_ysize<200) {
      fetcher_tags_ysize=200;
    }
    open_window(&win_fetcher_tags,fetcher_tags_xsize, fetcher_tags_ysize,&gc,black,grey,"FETCHER TAGS",hide_fetcher_tags);
    open_daughter_window (&button_hide_fetcher_tags, win_fetcher_tags,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<4 ) {
    if (LSU_tags_xsize<200) {
      LSU_tags_xsize=200;
    }
    if (LSU_tags_ysize<200) {
      LSU_tags_ysize=200;
    }
    open_window(&win_LSU_tags,LSU_tags_xsize, LSU_tags_ysize,&gc,black,grey,"LSU TAGS",hide_LSU_tags);
    open_daughter_window (&button_hide_LSU_tags, win_LSU_tags,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<5) {
    if (LSU_xsize<200) {
      LSU_xsize=200;
    }
    if (LSU_ysize<200) {
      LSU_ysize=200;
    }
    open_window(&win_LSU,LSU_xsize, LSU_ysize,&gc,black,grey,"LSU",hide_LSU);
    open_daughter_window (&button_hide_LSU, win_LSU,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<6) {
    if (TLB_xsize<200) {
      TLB_xsize=200;
    }
    if (TLB_ysize<200) {
      TLB_ysize=200;
    }
    open_window(&win_TLB,TLB_xsize, TLB_ysize,&gc,black,grey,"TLB",hide_TLB);
    open_daughter_window (&button_hide_TLB, win_TLB,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<7) {
    if (Xbar_xsize<200) {
      Xbar_xsize=200;
    }
    if (Xbar_ysize<200) {
      Xbar_ysize=200;
    }
    open_window(&win_Xbar,Xbar_xsize, Xbar_ysize,&gc,black,grey,"Xbar",hide_Xbar);
    open_daughter_window (&button_hide_Xbar, win_Xbar,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<8) {
    if (decoder_xsize<200) {
      decoder_xsize=200;
    }
    if (decoder_ysize<200) {
      decoder_ysize=200;
    }
    open_window(&win_decoder,decoder_xsize, decoder_ysize,&gc,black,grey,"DECODER",hide_decoder);
    open_daughter_window (&button_hide_decoder, win_decoder,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<9) {
    if (register_xsize<200) {
      register_xsize=200;
    }
    if (register_ysize<200) {
      register_ysize=200;
    }
    open_window(&win_register,register_xsize, register_ysize,&gc,black,grey,"REGISTERS",hide_register);
    open_daughter_window (&button_hide_register, win_register,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<10) {
    if (scoreboard_xsize<200) {
      scoreboard_xsize=200;
    }
    if (scoreboard_ysize<200) {
      scoreboard_ysize=200;
    }
    open_window(&win_scoreboard,scoreboard_xsize, scoreboard_ysize,&gc,black,grey,"SCOREBOARD",hide_scoreboard);
    open_daughter_window (&button_hide_scoreboard, win_scoreboard,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<11) {
    if (fetch_logic_xsize<200) {
      fetch_logic_xsize=200;
    }
    if (fetch_logic_ysize<200) {
      fetch_logic_ysize=200;
    }
    open_window(&win_fetch_logic,fetch_logic_xsize, fetch_logic_ysize,&gc,black,grey,"BUS ARBITER",hide_fetch_logic);
    open_daughter_window (&button_hide_fetch_logic, win_fetch_logic,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<12) {
    if (SR_xsize<200) {
      SR_xsize=200;
    }
    if (SR_ysize<200) {
      SR_ysize=200;
    }
    open_window(&win_SR,SR_xsize, SR_ysize,&gc,black,grey,"SPECIAL REGISTERS",hide_SR);
    open_daughter_window (&button_hide_SR, win_SR,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<13) {
    if (ROP2_xsize<200) {
      ROP2_xsize=200;
    }
    if (ROP2_ysize<200) {
      ROP2_ysize=200;
    }
    open_window(&win_ROP2,ROP2_xsize, ROP2_ysize,&gc,black,grey,"ROP2 UNIT",hide_ROP2);
    open_daughter_window (&button_hide_ROP2, win_ROP2,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<14) {
    if (INC_xsize<200) {
      INC_xsize=200;
    }
    if (INC_ysize<200) {
      INC_ysize=200;
    }
    open_window(&win_INC,INC_xsize, INC_ysize,&gc,black,grey,"INC UNIT",hide_INC);
    open_daughter_window (&button_hide_INC, win_INC,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<15) {
    if (SHUFFLER_xsize<200) {
      SHUFFLER_xsize=200;
    }
    if (SHUFFLER_ysize<200) {
      SHUFFLER_ysize=200;
    }
    open_window(&win_SHUFFLER,SHUFFLER_xsize, SHUFFLER_ysize,&gc,black,grey,"SHUFFLER",hide_SHUFFLER);
    open_daughter_window (&button_hide_SHUFFLER, win_SHUFFLER,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<16) {
    if (ASU_xsize<200) {
      ASU_xsize=200;
    }
    if (ASU_ysize<200) {
      ASU_ysize=200;
    }
    open_window(&win_ASU,ASU_xsize, ASU_ysize,&gc,black,grey,"ADD/SUB UNIT",hide_ASU);
    open_daughter_window (&button_hide_ASU, win_ASU,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<17) {
    if (IMU_xsize<200) {
      IMU_xsize=200;
    }
    if (IMU_ysize<200) {
      IMU_ysize=200;
    }
    open_window(&win_IMU,IMU_xsize, IMU_ysize,&gc,black,grey,"INT MULTIPLY UNIT",hide_IMU);
    open_daughter_window (&button_hide_IMU, win_IMU,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<18) {
    if (IDU_xsize<200) {
      IDU_xsize=200;
    }
    if (IDU_ysize<200) {
      IDU_ysize=200;
    }
    open_window(&win_IDU,IDU_xsize, IDU_ysize,&gc,black,grey,"IDU",hide_IDU);
    open_daughter_window (&button_hide_IDU, win_IDU,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }


/****************************************************************************************************************

  if (resize_flag & 1L<<) {
    if (_xsize<200) {
      _xsize=200;
    }
    if (_ysize<200) {
      _ysize=200;
    }
    open_window(&win_,_xsize, _ysize,&gc,black,grey,"",hide_);
    open_daughter_window (&button_hide_, win_,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

****************************************************************************************************************/

  resize_flag=0;

  /* main loop */  

  do {
    XNextEvent(dpy,&event);
    switch(event.type) {

      case Expose:
        if (event.xexpose.window==button_quit){
          XDrawImageString(dpy,button_quit,gc,3,13,"QUIT",4);
	} else if (event.xexpose.window==button_init) {
          XDrawImageString(dpy,button_init,gc,5,13,"INIT",4);
	} else if (event.xexpose.window==button_step) {
          XDrawImageString(dpy,button_step,gc,3,13,"STEP",4);
	} else if (event.xexpose.window==button_hide_mem) {
          XDrawImageString(dpy,button_hide_mem,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_fetcher) {
          XDrawImageString(dpy,button_hide_fetcher,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_fetcher_tags) {
          XDrawImageString(dpy,button_hide_fetcher_tags,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_LSU_tags) {
          XDrawImageString(dpy,button_hide_LSU_tags,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_LSU) {
          XDrawImageString(dpy,button_hide_LSU,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_scoreboard) {
          XDrawImageString(dpy,button_hide_scoreboard,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_TLB) {
          XDrawImageString(dpy,button_hide_TLB,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_Xbar) {
          XDrawImageString(dpy,button_hide_Xbar,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_decoder) {
          XDrawImageString(dpy,button_hide_decoder,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_register) {
          XDrawImageString(dpy,button_hide_register,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_fetch_logic) {
          XDrawImageString(dpy,button_hide_fetch_logic,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_SR) {
          XDrawImageString(dpy,button_hide_SR,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_ROP2) {
          XDrawImageString(dpy,button_hide_ROP2,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_INC) {
          XDrawImageString(dpy,button_hide_INC,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_SHUFFLER) {
          XDrawImageString(dpy,button_hide_SHUFFLER,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_ASU) {
          XDrawImageString(dpy,button_hide_ASU,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_IMU) {
          XDrawImageString(dpy,button_hide_IMU,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_hide_IDU) {
          XDrawImageString(dpy,button_hide_IDU,gc,3,13,"HIDE",4);
	} 
       /* else if (event.xexpose.window==button_hide_) {
          XDrawImageString(dpy,button_hide_,gc,3,13,"HIDE",4);
	}*/
	  else if (event.xexpose.window==button_mem) {
          XDrawImageString(dpy,button_mem,gc2,((main_xsize-(26*2))-52)>>1,(50+12)>>1,"MEMORY",6);
	} else if (event.xexpose.window==win_main) {
          XDrawSegments(dpy,win_main,gc,main_segments, sizeof(main_segments)/sizeof(XSegment));
	} else if (event.xexpose.window==button_LSU) {
          XDrawImageString(dpy,button_LSU,gc,((t1*3)-30)>>1,t2>>1,"LSU",3);
	} else if (event.xexpose.window==button_LSU_tags) {
          XDrawImageString(dpy,button_LSU_tags,gc,((t1)-30)>>1,t2>>1,"tags",4);
	} else if (event.xexpose.window==button_fetch_logic) {
          XDrawImageString(dpy,button_fetch_logic,gc,((t1)-25)>>1,(t2>>1)-8,"Bus",3);
          XDrawImageString(dpy,button_fetch_logic,gc,((t1)-45)>>1,(t2>>1)+8,"Arbiter",7);
	} else if (event.xexpose.window==button_fetcher_tags) {
          XDrawImageString(dpy,button_fetcher_tags,gc,((t1)-30)>>1,t2>>1,"tags",4);
	} else if (event.xexpose.window==button_fetcher) {
          XDrawImageString(dpy,button_fetcher,gc,((t1*3)-70)>>1,t2>>1,"FETCHER",7);
	} else if (event.xexpose.window==button_Xbar) {
          XDrawImageString(dpy,button_Xbar,gc,(t1-30)>>1,((t2*3)>>1)-20,"Xbar",4);
	} else if (event.xexpose.window==button_TLB) {
          XDrawImageString(dpy,button_TLB,gc,(main_xsize>>3)-15,(t2>>1)-6,"TLB",3);
	} else if (event.xexpose.window==button_decoder) {
          XDrawImageString(dpy,button_decoder,gc,(main_xsize>>3)-25,t2>>1,"Decoder",7);
	} else if (event.xexpose.window==button_scoreboard) {
          XDrawImageString(dpy,button_scoreboard,gc,(main_xsize>>3)-35,(t2>>1)-10,"Scoreboard",10);
	} else if (event.xexpose.window==button_register) {
          XDrawImageString(dpy,button_register,gc,(main_xsize>>3)-45,(t2>>1)+10,"REGISTERS",9);
	} else if (event.xexpose.window==button_SR) {
          XDrawImageString(dpy,button_SR,gc,(main_xsize>>3)-50,(t2>>1)-10,
	      "Special Registers",17);
	} else if (event.xexpose.window==button_ROP2) {
          XDrawImageString(dpy,button_ROP2,gc,(main_xsize>>3)-40,(t3/12)+1,"ROP2",4);
	} else if (event.xexpose.window==button_INC) {
          XDrawImageString(dpy,button_INC,gc,(main_xsize>>3)-40,(t3/12)+1,"INC/SORT",8);
	} else if (event.xexpose.window==button_SHUFFLER) {
          XDrawImageString(dpy,button_SHUFFLER,gc,(main_xsize>>3)-40,(t3/12)+1,"SHUFFLER",8);
	} else if (event.xexpose.window==button_ASU) {
          XDrawImageString(dpy,button_ASU,gc,(main_xsize>>3)-40,(t3/12)+1,"ADD/SUB",7);
	} else if (event.xexpose.window==button_IMU) {
          XDrawImageString(dpy,button_IMU,gc,(main_xsize>>3)-40,(t3/12)+1,"MULTIPLY",8);
	} else if (event.xexpose.window==button_IDU) {
          XDrawImageString(dpy,button_IDU,gc,(main_xsize>>3)-40,(t3/12)+1,"DIVIDE",6);
	}

        break;

      case ButtonPress:
	if (event.xbutton.button==1) {
	
	  if ((event.xbutton.window==button_mem)
	    ||(event.xbutton.window==button_hide_mem)) {
            if (hide_mem==HIDDEN) {
              hide_mem=SHOWN;
              XMapWindow (dpy, win_mem);
	    }
	    else {
              hide_mem=HIDDEN;
              XUnmapWindow (dpy, win_mem);
	    }
	  }
	  else
	  if ((event.xbutton.window==button_fetcher)
	    ||(event.xbutton.window==button_hide_fetcher)) {
            if (hide_fetcher==HIDDEN) {
              hide_fetcher=SHOWN;
              XMapWindow (dpy, win_fetcher);
	    }
	    else {
              hide_fetcher=HIDDEN;
              XUnmapWindow (dpy, win_fetcher);
	    }
	  }
	  else
	  if ((event.xbutton.window==button_fetcher_tags)
	    ||(event.xbutton.window==button_hide_fetcher_tags)) {
            if (hide_fetcher_tags==HIDDEN) {
              hide_fetcher_tags=SHOWN;
              XMapWindow (dpy, win_fetcher_tags);
	    }
	    else {
              hide_fetcher_tags=HIDDEN;
              XUnmapWindow (dpy, win_fetcher_tags);
	    }
	  }
	  else
	  if ((event.xbutton.window==button_LSU_tags)
	    ||(event.xbutton.window==button_hide_LSU_tags)) {
            if (hide_LSU_tags==HIDDEN) {
              hide_LSU_tags=SHOWN;
              XMapWindow (dpy, win_LSU_tags);
	    }
	    else {
              hide_LSU_tags=HIDDEN;
              XUnmapWindow (dpy, win_LSU_tags);
	    }
	  }
	  else
	  if ((event.xbutton.window==button_LSU)
	    ||(event.xbutton.window==button_hide_LSU)) {
            if (hide_LSU==HIDDEN) {
              hide_LSU=SHOWN;
              XMapWindow (dpy, win_LSU);
	    }
	    else {
              hide_LSU=HIDDEN;
              XUnmapWindow (dpy, win_LSU);
	    }
	  }
	  else
	  if ((event.xbutton.window==button_TLB)
	    ||(event.xbutton.window==button_hide_TLB)) {
            if (hide_TLB==HIDDEN) {
              hide_TLB=SHOWN;
              XMapWindow (dpy, win_TLB);
	    }
	    else {
              hide_TLB=HIDDEN;
              XUnmapWindow (dpy, win_TLB);
	    }
	  }
	  else
	  if ((event.xbutton.window==button_Xbar)
	    ||(event.xbutton.window==button_hide_Xbar)) {
            if (hide_Xbar==HIDDEN) {
              hide_Xbar=SHOWN;
              XMapWindow (dpy, win_Xbar);
	    }
	    else {
              hide_Xbar=HIDDEN;
              XUnmapWindow (dpy, win_Xbar);
	    }
	  }
	  else
	  if ((event.xbutton.window==button_decoder)
	    ||(event.xbutton.window==button_hide_decoder)) {
            if (hide_decoder==HIDDEN) {
              hide_decoder=SHOWN;
              XMapWindow (dpy, win_decoder);
	    }
	    else {
              hide_decoder=HIDDEN;
              XUnmapWindow (dpy, win_decoder);
	    }
	  }
	  else
	  if ((event.xbutton.window==button_register)
	    ||(event.xbutton.window==button_hide_register)) {
            if (hide_register==HIDDEN) {
              hide_register=SHOWN;
              XMapWindow (dpy, win_register);
	    }
	    else {
              hide_register=HIDDEN;
              XUnmapWindow (dpy, win_register);
	    }
	  }
	  else
	  if ((event.xbutton.window==button_scoreboard)
	    ||(event.xbutton.window==button_hide_scoreboard)) {
            if (hide_scoreboard==HIDDEN) {
              hide_scoreboard=SHOWN;
              XMapWindow (dpy, win_scoreboard);
	    }
	    else {
              hide_scoreboard=HIDDEN;
              XUnmapWindow (dpy, win_scoreboard);
	    }
	  }

	  else
	  if ((event.xbutton.window==button_fetch_logic)
	    ||(event.xbutton.window==button_hide_fetch_logic)) {
            if (hide_fetch_logic==HIDDEN) {
              hide_fetch_logic=SHOWN;
              XMapWindow (dpy, win_fetch_logic);
	    }
	    else {
              hide_fetch_logic=HIDDEN;
              XUnmapWindow (dpy, win_fetch_logic);
	    }
	  }

	  else
	  if ((event.xbutton.window==button_SR)
	    ||(event.xbutton.window==button_hide_SR)) {
            if (hide_SR==HIDDEN) {
              hide_SR=SHOWN;
              XMapWindow (dpy, win_SR);
	    }
	    else {
              hide_SR=HIDDEN;
              XUnmapWindow (dpy, win_SR);
	    }
	  }

	  else
	  if ((event.xbutton.window==button_ROP2)
	    ||(event.xbutton.window==button_hide_ROP2)) {
            if (hide_ROP2==HIDDEN) {
              hide_ROP2=SHOWN;
              XMapWindow (dpy, win_ROP2);
	    }
	    else {
              hide_ROP2=HIDDEN;
              XUnmapWindow (dpy, win_ROP2);
	    }
	  }

	  else
	  if ((event.xbutton.window==button_INC)
	    ||(event.xbutton.window==button_hide_INC)) {
            if (hide_INC==HIDDEN) {
              hide_INC=SHOWN;
              XMapWindow (dpy, win_INC);
	    }
	    else {
              hide_INC=HIDDEN;
              XUnmapWindow (dpy, win_INC);
	    }
	  }

	  else
	  if ((event.xbutton.window==button_SHUFFLER)
	    ||(event.xbutton.window==button_hide_SHUFFLER)) {
            if (hide_SHUFFLER==HIDDEN) {
              hide_SHUFFLER=SHOWN;
              XMapWindow (dpy, win_SHUFFLER);
	    }
	    else {
              hide_SHUFFLER=HIDDEN;
              XUnmapWindow (dpy, win_SHUFFLER);
	    }
	  }

	  else
	  if ((event.xbutton.window==button_ASU)
	    ||(event.xbutton.window==button_hide_ASU)) {
            if (hide_ASU==HIDDEN) {
              hide_ASU=SHOWN;
              XMapWindow (dpy, win_ASU);
	    }
	    else {
              hide_ASU=HIDDEN;
              XUnmapWindow (dpy, win_ASU);
	    }
	  }

	  else
	  if ((event.xbutton.window==button_IMU)
	    ||(event.xbutton.window==button_hide_IMU)) {
            if (hide_IMU==HIDDEN) {
              hide_IMU=SHOWN;
              XMapWindow (dpy, win_IMU);
	    }
	    else {
              hide_IMU=HIDDEN;
              XUnmapWindow (dpy, win_IMU);
	    }
	  }

	  else
	  if ((event.xbutton.window==button_IDU)
	    ||(event.xbutton.window==button_hide_IDU)) {
            if (hide_IDU==HIDDEN) {
              hide_IDU=SHOWN;
              XMapWindow (dpy, win_IDU);
	    }
	    else {
              hide_IDU=HIDDEN;
              XUnmapWindow (dpy, win_IDU);
	    }
	  }
/*

	  else
	  if ((event.xbutton.window==button_)
	    ||(event.xbutton.window==button_hide_)) {
            if (hide_==HIDDEN) {
              hide_=SHOWN;
              XMapWindow (dpy, win_);
	    }
	    else {
              hide_=HIDDEN;
              XUnmapWindow (dpy, win_);
	    }
	  }
*/
	}
        break;

      case MotionNotify: /* pour d'eventuels scrollbars */

        break;

      case ResizeRequest:
        resize_flag=0;
        if (event.xresizerequest.window==win_main){
	  resize_flag=1L<<0;
          main_xsize=event.xresizerequest.width;
          main_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_mem) {
	  resize_flag=1L<<1;
          mem_xsize=event.xresizerequest.width;
          mem_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_fetcher) {
	  resize_flag=1L<<2;
          fetcher_xsize=event.xresizerequest.width;
          fetcher_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_fetcher_tags) {
	  resize_flag=1L<<3;
          fetcher_tags_xsize=event.xresizerequest.width;
          fetcher_tags_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_LSU_tags) {
	  resize_flag=1L<<4;
          LSU_tags_xsize=event.xresizerequest.width;
          LSU_tags_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_LSU) {
	  resize_flag=1L<<5;
          LSU_xsize=event.xresizerequest.width;
          LSU_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_TLB) {
	  resize_flag=1L<<6;
          TLB_xsize=event.xresizerequest.width;
          TLB_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_Xbar) {
	  resize_flag=1L<<7;
          Xbar_xsize=event.xresizerequest.width;
          Xbar_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_decoder) {
	  resize_flag=1L<<8;
          decoder_xsize=event.xresizerequest.width;
          decoder_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_register) {
	  resize_flag=1L<<9;
          register_xsize=event.xresizerequest.width;
          register_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_scoreboard) {
	  resize_flag=1L<<10;
          scoreboard_xsize=event.xresizerequest.width;
          scoreboard_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_fetch_logic) {
	  resize_flag=1L<<11;
          fetch_logic_xsize=event.xresizerequest.width;
          fetch_logic_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_SR) {
	  resize_flag=1L<<12;
          SR_xsize=event.xresizerequest.width;
          SR_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_ROP2) {
	  resize_flag=1L<<13;
          ROP2_xsize=event.xresizerequest.width;
          ROP2_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_INC) {
	  resize_flag=1L<<14;
          INC_xsize=event.xresizerequest.width;
          INC_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_SHUFFLER) {
	  resize_flag=1L<<15;
          SHUFFLER_xsize=event.xresizerequest.width;
          SHUFFLER_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_ASU) {
	  resize_flag=1L<<16;
          ASU_xsize=event.xresizerequest.width;
          ASU_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_IMU) {
	  resize_flag=1L<<17;
          IMU_xsize=event.xresizerequest.width;
          IMU_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_IDU) {
	  resize_flag=1L<<18;
          IDU_xsize=event.xresizerequest.width;
          IDU_ysize=event.xresizerequest.height;
	}
/*
        else if (event.xresizerequest.window==win_) {
	  resize_flag=1L<<;
          _xsize=event.xresizerequest.width;
          _ysize=event.xresizerequest.height;
	}
*/
        break;

      case KeyPress :
        XLookupString(&event.xkey, &car, 1, &keysym, 0);
        if ((car=='q')||(car=='Q'))
          goto the_end;

        break;

    }
  } while (!(((event.type==ButtonRelease)&&(event.xexpose.window==button_quit))
            ||(resize_flag!=0)));

the_end:

  if (resize_flag==0) {
    /* collect the X geometries of the windows and save them to a file */
  }

  if ((resize_flag & 1L<<0)||(resize_flag==0)) {
    close_window(&win_main);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<1)||(resize_flag==0)) {
    close_window(&button_hide_mem);
    close_window(&win_mem);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<2)||(resize_flag==0)) {
    close_window(&button_hide_fetcher);
    close_window(&win_fetcher);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<3)||(resize_flag==0)) {
    close_window(&button_hide_fetcher_tags);
    close_window(&win_fetcher_tags);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<4)||(resize_flag==0)) {
    close_window(&button_hide_LSU_tags);
    close_window(&win_LSU_tags);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<5)||(resize_flag==0)) {
    close_window(&button_hide_LSU);
    close_window(&win_LSU);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<6)||(resize_flag==0)) {
    close_window(&button_hide_TLB);
    close_window(&win_TLB);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<7)||(resize_flag==0)) {
    close_window(&button_hide_Xbar);
    close_window(&win_Xbar);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<8)||(resize_flag==0)) {
    close_window(&button_hide_decoder);
    close_window(&win_decoder);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<9)||(resize_flag==0)) {
    close_window(&button_hide_register);
    close_window(&win_register);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<10)||(resize_flag==0)) {
    close_window(&button_hide_scoreboard);
    close_window(&win_scoreboard);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<11)||(resize_flag==0)) {
    close_window(&button_hide_fetch_logic);
    close_window(&win_fetch_logic);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<12)||(resize_flag==0)) {
    close_window(&button_hide_SR);
    close_window(&win_SR);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<13)||(resize_flag==0)) {
    close_window(&button_hide_ROP2);
    close_window(&win_ROP2);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<14)||(resize_flag==0)) {
    close_window(&button_hide_INC);
    close_window(&win_INC);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<15)||(resize_flag==0)) {
    close_window(&button_hide_SHUFFLER);
    close_window(&win_SHUFFLER);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<16)||(resize_flag==0)) {
    close_window(&button_hide_ASU);
    close_window(&win_ASU);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<17)||(resize_flag==0)) {
    close_window(&button_hide_IMU);
    close_window(&win_IMU);
    if (resize_flag) goto redisplay;
  }

  if ((resize_flag & 1L<<18)||(resize_flag==0)) {
    close_window(&button_hide_IDU);
    close_window(&win_IDU);
    if (resize_flag) goto redisplay;
  }

/*

  if ((resize_flag & 1L<<)||(resize_flag==0)) {
    close_window(&button_hide_);
    close_window(&win_);
    if (resize_flag) goto redisplay;
  }
*/
  exitX();
}








