#ifndef __FCPU_ASM_H__
#define __FCPU_ASM_H__

#define SIZE_B                   0 << 22 // byte (8bit)
#define SIZE_D                   1 << 22 // double byte (16bit)
#define SIZE_Q                   2 << 22 // quad byte (32bit)
#define SIZE_W                   3 << 22 // word (64bit)
#define SIZE_MASK                3 << 22 // word (64bit)

#define ARITHM_UNSIGNED          1 << 21   
#define ARITHM_SIMD              1 << 20
#define ARITHM_SUB               1 << 19   
#define ARITHM_MOD               1 << 19   

#define TEST_EQ                  0 << 18 // equal to
#define TEST_NQ                  1 << 18 // not equal to
#define TEST_GT                  2 << 18 // greater than
#define TEST_GE                  3 << 18 // greater than or equal
#define TEST_LT                  4 << 18 // less than
#define TEST_LE                  5 << 18 // less than or equal to
#define TEST_CF                  6 << 18 // carry flag set
#define TEST_CZ                  7 << 18 // zero flag set
#define TEST_MASK               15 << 18 

#define SHIFTROT_LEFT            0 << 20 // shift/rotate left
#define SHIFTROT_RIGHT           1 << 20 // shift/rotate right
#define SHIFTROT_DIRECTION       1 << 20
#define SHIFTROT_ARITHMETIC      1 << 21 // arithmetic shift/rotate

#define LOGIC_OR                 7 << 18 // 0111
#define LOGIC_AND                1 << 18 // 0001
#define LOGIC_XOR                6 << 18 // 0110
#define LOGIC_NOR                8 << 18 // 1000
#define LOGIC_NAND              14 << 18 // 1110
#define LOGIC_MASK              15 << 18 // 1111

#define FLOAT_DOUBLE             0 << 22 // double size float op
#define FLOAT_FLOAT              1 << 22 // float size float op
#define FLOAT_SIZE_MASK          3 << 22 // float size
#define FLOAT_NEGATE             1 << 20 // FP
#define FLOAT_SIMD               1 << 20 // SIMD float instruction
#define FLOAT_IEEE               0 << 19 // SIMD float instruction
#define FLOAT_NON_IEEE           1 << 19 // SIMD float instruction

#define FLOAT_INT2F              0 << 21 // int2float flag
#define FLOAT_F2INT              1 << 21 // float2int flag
#define FLOAT_DIRECTION          1 << 21 

#define FLOAT_ROUND_NEARES       0 << 16
#define FLOAT_ROUND_TOZERO       1 << 16
#define FLOAT_ROUND_AWZERO       2 << 16
#define FLOAT_ROUND_TOPLUSINFTY  3 << 16
#define FLOAT_ROUND_TOMINUSINFTY 4 << 16
#define FLOAT_ROUND_MASK         7 << 16

#define OP_ADD                   1 << 24
#define OP_SUB                  (OP_ADD | ARITHM_SUB)
#define OP_ADDI                  2 << 24
#define OP_SUBI                 (OP_ADDI | ARITHM_SUB)
#define OP_MUL                   3 << 24
#define OP_MULI                  4 << 24
#define OP_DIV                   5 << 24
#define OP_MOD                  (OP_DIV | ARITHM_MOD)
#define OP_DIVI                  6 << 24
#define OP_MODI                 (OP_DIVI | ARITHM_MOD)
#define OP_LOGIC                 7 << 24
#define OP_TEST                  8 << 24
#define OP_LOAD                  9 << 24
#define OP_STORE                10 << 24
#define OP_MOV                  11 << 24
#define OP_GET                  12 << 24
#define OP_PUT                  13 << 24
#define OP_PREFETCH             14 << 24
#define OP_SHIFT                15 << 24
#define OP_ROT                  16 << 24
#define OP_FADD                 17 << 24
#define OP_FSUB                 (OP_FADD | FLOAT_NEGATE)
#define OP_FMUL                 18 << 24
#define OP_FINV                 19 << 24
#define OP_FDIV                 20 << 24
#define OP_FSQRT                21 << 24
#define OP_FINVSQRT             22 << 24
#define OP_INT2F                23 << 24
#define OP_F2INT                (OP_INT2F | FLOAT_F2INT) 
#define OP_JMP                  24<<24
#define OP_JMPI                 25<<24
#define OP_JMPR                 26<<24
#define OP_SYSCALL              27<<24
#define OP_TRAP                 (OP_TRAP)

#endif
