#!/usr/bin/perl

#########################################################################
#                                                                       #
# Name: f-vote.pl                                                       #
#                                                                       #
# Summary: Keeps a flat text file containing user information and votes #
#   for each issue brought before the Freedom CPU Project (or whoever   #
#   else may use this in the event that (God forbid) someone else       #
#   should try to use this.)                                            #
#                                                                       #
# Version: 0.1                                                          #
#                                                                       #
# Modification History:                                                 #
#   Author		Version		Changes                         #
# --------------------- -------		------------------------------- #
# Brian Fuhs               0.1          Initial version                 #
#                                                                       #
#-----------------------------------------------------------------------#
#                                                                       #
# Usage: CGI.  When called with no arguments, provides a home page.     #
#   Otherwise, will create user, change password, or change vote based  #
#   on input.                                                           #
#                                                                       #
# Uses cgi-lib cuz that was all I had seen when I wrote this.           #
#   cgi-lib is available at http://www.bio.cam.ac.uk/web/form.html      #
#                                                                       #
#-----------------------------------------------------------------------#
# Bugs, future enhancements, note:                                      #
#   None (yet).  Hopefully to be replaced by something less hackish.    #
#                                                                       #
#########################################################################

require "cgi-lib";

# Read data file (f-vote.dat) into memory for future use.

sub read_file {
	open(VOTEFILE,"<f-vote.dat");
	while(<VOTEFILE>) {
		chomp;
		push @data, $_;
	}
	close(VOTEFILE);
}

# Write data file (f-vote.dat) to disk to save changes (new users,
# password changes, etc).

sub write_file {
	open(VOTEFILE,">f-vote.dat");
	my(counter);
	for(counter=0;counter<=$#data;$counter++) {
		print VOTEFILE $data[$counter];
	}
}

# Check correctness of password.  Search for username in data.  If
# found, verify password with crypt.  If it matches, return 0.
# If no match, return 1.  If username not found, return 2.

sub check_pass (username, password) {
	my(counter, tempdata);
	for($counter=0;$counter<=$#data;$counter++) {
		@tempdata=split(/\s+/,$data[$counter]);
		if($tempdata[0] eq $username) {
			if(crypt($password, $salt) eq $tempdata[1]) {
				return 0;
			}
			else
			{
				return 1;
			}		# if crypt
		} 		# if tempdata
	}		# for counter
	return 2;
}		# sub check_pass

# Add new user.  Check to make sure both attempts at password match.
# If not, return 1.  Check for existing user with same name.  If found,
# return 2.  Otherwise, add user and return 0.

sub useradd (username, password, pverify) {
	my(counter, tempdata, tempentry);
	if($password eq $pverify) {
		for($counter=0;$counter<=$#data;$counter++) {
			@tempdata = split(/\s+/,$data[$counter]);
			if($tempdata[0] eq $username) {
				return 2;
			}		# if tempdata
		}		# for counter
		# Username does not already exist, password and pverify
		# match, add user.  Default vote to 0 (no vote).
		$tempentry=$username ." ". crypt($password, $salt) ." ". "0";
		push @data, $tempentry;
		return 0;
	}		# if password
	else		# password != pverify, return 1
		return 1;
	}		# else password
}		sub useradd

# Change password.  Verify password attempts match.  If not return 1.
# Check for username in data.  If not found return 2.  If found, verify
# old password matches current password.  If not return 3.  If everything
# OK, change password and return 0.

sub change_pass(username, old_pass, new_pass, pverify) {
	my(tempdata, counter);
	if(new_pass eq pverify) {
		for($counter=0;$counter<=$#data;$counter++) {
			@tempdata=split(/\s+/, $data[$counter])
			if($tempdata[0] eq $username) {
				if(crypt($old_pass, $salt) eq $tempdata[1]) {
					# everything OK, update password and
					# return 0
					$data[$counter]=$username ." ". crypt($new_pass,$salt) ." ". $tempdata[2];
					return 0;
				}		# if crypt
				else {
					# old password incorrect
					return 3;
				}		# else crypt
			}		# if tempdata
		}		# for counter
		# username not found
		return 2;
	}		# if new_pass
	else {
		# new_pass != pverify
		return 1;
	}		# else new_pass
}		# sub change_pass

# Update vote.  The actual work that all the rest of this stuff supports.  :)
# Check for username in data.  If not found, return 1.  Check password.  If
# doesn't match, return 2.  If it matches, update vote and return 0.

sub change_vote (username, password, vote) {
	my(tempdata, counter);
	for($counter=0;$counter<=$#data;$counter++) {
		@tempdata=split(/\s+/,$data[$counter]);
		if($tempdata[0] eq $username) {
			if(crypt($password,$salt) eq $tempdata[1]) {
				# username and password match, update vote
				$data[$counter]=$username." ".$tempdata[1]." ".$vote;
				return 0;
			}		# if crypt
			else {
				# password doesn't match
				return 2;
			}		# else crypt
		}		# if tempdata
	}		# for counter
	# Username not found.
	return 1;
}		# sub change_vote

# Need to send something back to the user.  Pick an HTML file and basically
# just cat it out.

sub send_file (fname) {
	open(PAGEFILE,"<$fname");
	while(<PAGEFILE>) {
		print $_;
	}
	close(PAGEFILE);
}

# Main.  Use the cgi-lib stuff to get the arguments, figure out what
# the user wants to do, and call the appropriate function.  Check return
# value and send an appropriate page based on the results.

select STDOUT;
$|=1;

# Print header

print &PrintHeader;

# Open file and read in

read_file;

if(&ReadParse(*input)) {
	if($input{'ACTION'} eq 'new') {
		$return=useradd($input{'UNAME'},$input{'PWD'},$input{'PVFY'});
		unless($return) {
			send_file("user_added.html");
			write_file;
			exit;
		}
		if($return==1) {
			send_file("mismatch.html");
			exit;
		}
		elsif($return==2) {
			send_file("uname_exists.html");
			exit;
		}
		else {
			send_file("internal_error.html");
		}
	}		# if ACTION is new
	elsif($input{'ACTION'} eq 'pass') {
		$return=change_pass($input{'UNAME'},$input{'PWD2'},$input{'PWD'},$input{'PVRFY'});
		unless($return) {
			send_file("pwd_chgd.html");
			write_file;
			exit;
		}
		if($return==1) {
			send_file("mismatch.html");
			exit;
		}
		if($return==2 || $return==3) {
			send_file("bad_login.html");
			exit;
		}
		else {
			send_file("internal_error.html");
			exit;
		}
	}
	elseif($input{'ACTION'} eq 'vote') {
		$return=change_vote($input{'UNAME'},$input{'PWD'},$input{'VOTE'});
		unless($return) {
			send_file("vote_chgd.html");
			write_file;
			exit;
		}
		if($return==1 || $return==2) {
			send_file("bad_login.html");
			exit;
		}
		else {
			send_file("internal_error.html");
			exit;
		}
	}
	# Fallen through ACTION switch.  Bad input.
	send_file("internal_error.html");
	exit;
}
