-- blah2.vhdl -- Scalable SRT Divider Row
-- Copyright (C) 2000, 2001 Michael Riepe <michael@s...>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id$

library IEEE;
use IEEE.std_logic_1164.all;

entity Blah2 is
        generic (
                WIDTH : natural := 64
        );
        port (
                -- partial remainder high part (a0-a1)
                A0 : in std_ulogic_vector(WIDTH+1 downto 0);
                A1 : in std_ulogic_vector(WIDTH+1 downto 0);
                -- partial remainder low part
                AV : in std_ulogic_vector(WIDTH-1 downto 0);
                -- divisor
                BV : in std_ulogic_vector(WIDTH+1 downto 0);
        --
                -- partial remainder high part (r0-r1)
                R0 : out std_ulogic_vector(WIDTH+1 downto 0);
                R1 : out std_ulogic_vector(WIDTH+1 downto 0);
                -- partial remainder low part
                RV : out std_ulogic_vector(WIDTH-1 downto 0);
                -- 1-bit quotient
                QP : out std_ulogic;
                QN : out std_ulogic
        ; -- test pads
                TestP : out std_ulogic;
                TestD : out std_ulogic
        );
end Blah2;

architecture Behave_1 of Blah2 is
begin
        process (A0, A1, AV, BV)
                variable t0, t1, bb : std_ulogic_vector(WIDTH+1 downto 0);
                variable tv : std_ulogic_vector(WIDTH-1 downto 0);
                variable gg, pp : std_ulogic_vector(3 downto 0);
                variable d, p : std_ulogic;
                variable t, u, v : std_ulogic_vector(WIDTH+1 downto 0);
        begin
                -- input values
                -- d=0
                tv := AV;
                bb := BV;
                -- d=1
                t0 := A0 xor not A1;    -- (not A1) calculated somewhere else
                t1 := A0 and not A1;    -- (not A1) calculated somewhere else

                -- decision logic
                -- d=1
                pp := t0(WIDTH+1 downto WIDTH-2);
                gg := t1(WIDTH+1 downto WIDTH-2);
                -- p = '1' when remainder is not zero (approximately)
                -- d=2
                p := not (pp(3) and pp(2) and pp(1) and pp(0));
                -- d = '1' when remainder/divisor signs equal (=> subtract)
                -- d=4
                d := ((not bb(WIDTH+1)) xor pp(3))
                 xor (gg(2) or (pp(2) and gg(1)) or (pp(2) and pp(1) and gg(0)));

                -- test pads
                TestP <= p;
                TestD <= d;

                -- 1-bit quotient outputs
                -- d=6
                QN <= p and not d;
                QP <= p and     d;

                -- A0/A1/AV left shift
                -- d=1
                t0 := t0(WIDTH downto 0) & (not tv(WIDTH-1));
                t1 := t1(WIDTH downto 0) & tv(WIDTH-1);
                -- d=0
                tv := tv(WIDTH-2 downto 0) & '0';

                -- add/subtract/no-op depending on p and d:
                -- when p = '1', add/subtract bb, else add/subtract zero.
                -- subtract when d = '1', otherwise add.
                -- d=1
                t := t0;
                u := t1;
                -- d=3
                v := bb and (WIDTH+1 downto 0 => p);
                -- d=5
                t0 := (t xor v) xor (WIDTH+1 downto 0 => d);
                -- d=6
                t1 := (u xor (t and v)) xor (t and (WIDTH+1 downto 0 => d));
                t1 := t1(WIDTH downto 0) & d;

                -- outputs
                R0 <= t0;
                R1 <= not t1;   -- calculated somewhere else
                RV <= tv;
        end process;
end Behave_1;

-- vi: set ts=4 sw=4 equalprg="fmt -72 -p--": please
