#ifndef ___FCPU_H___
#define ___FCPU_H___

#define octbyte  __int64
#define poctbyte octbyte*

#define onebyte  unsigned char
#define ponebyte onebyte*

#define FCPU_EXCEPTION_NONE                 0L
#define FCPU_EXCEPTION_RESET                1L
#define FCPU_EXCEPTION_ALIGNMENT_FAULT      2L
#define FCPU_EXCEPTION_DIVISIONBYZERO       3L
#define FCPU_EXCEPTION_PAGEFAULT            4L
#define FCPU_EXCEPTION_INVALIDINSTRUCTION   5L
#define FCPU_EXCEPTION_HALT                 6L

typedef struct _FCPUCPU {
    octbyte reg[ 64 ];
    octbyte instr_ptr;
    octbyte instr_reg;
    octbyte instr_opcode;
    octbyte instr_r1;
    octbyte instr_r2;
    octbyte instr_r3;
    octbyte instr_imm8;
    octbyte instr_imm16;
    octbyte instr_logop;
    octbyte instr_flgsize;
    onebyte instr_flgsat;
    onebyte instr_flgcy;
    onebyte instr_flgsign;
    onebyte instr_flgmod;
    onebyte instr_flgsimd;
    onebyte instr_flgbitop;
    onebyte exception;
} FCPUCPU, *PFCPUCPU;

void fcpu_reset( PFCPUCPU p );

void fcpu_clock( PFCPUCPU p );

void fcpu_asm( PFCPUCPU p, char* line, poctbyte o, poctbyte a, onebyte flsave );

#endif // ___FCPU_H___
