-- wallace.vhdl - Not So Simple Wallace Tree Adder
-- Copyright (C) 2000 Michael Riepe <michael@s...>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: wallace.vhdl,v 1.3 2000/10/13 22:10:43 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity Wallace is
        generic (
                WIDTH : natural := 4
        );
        port (
                -- inputs
                A0B0, A0B1, A1B0, A1B1 : in std_ulogic_vector(WIDTH-1 downto 0);
                -- mode switches
                Signed01, Signed10 : in std_ulogic;
                -- output
                Y : out std_ulogic_vector(2*WIDTH-1 downto 0)
        );
end Wallace;

architecture Arch_1 of Wallace is
begin
        process (A0B0, A0B1, A1B0, A1B1)
                variable a, b, c, d, e, f : std_ulogic_vector(2*WIDTH-1 downto0);
        begin
                -- tree
                a := A1B1 & A0B0;
                b := (others => '0');
                b(3*WIDTH/2-1 downto WIDTH/2) := A0B1;
                b(2*WIDTH-1 downto 3*WIDTH/2) :=
                        (others => Signed01 and A0B1(A0B1'left));
                c := (others => '0');
                c(3*WIDTH/2-1 downto WIDTH/2) := A1B0;
                c(2*WIDTH-1 downto 3*WIDTH/2) :=
                        (others => Signed10 and A1B0(A1B0'left));
                d := a xor b xor c;
                e := (a and b) or (a and c) or (b and c);
                f := e(e'left-1 downto e'right) & '0';

                -- adder
                a := d xor f;
                b := d and f;
                c(0) := '0';
                for i in 0 to b'left-1 loop
                        c(i+1) := b(i) or (a(i) and c(i));
                end loop;
                Y <= a xor c;
        end process;
end Arch_1;
