#ifndef LoadStoreUnit__HH
#define LoadStoreUnit__HH

#include "ProcessingUnit.hh"
#include "ProcessorUnit.hh"
#include "MemoryUser.hh"

class LoadStoreUnit: 
  public virtual ProcessingUnit,
  public virtual ProcessorUnit,
  public virtual MemoryUser
{
private:
  const static char *const name = "F64 Load/Store Unit";
  MemoryUnit *memory;
  RegType temp;
public:

  const char *getUnitName() { return name; }
  void tick() {}
  void init() {}
  void execute(Instruction i, Operand *o, int n, ProcessorData *data);
  void get(RegType p, int tag) { temp = p; }
  void setMemory(MemoryUnit *m) { memory = m; }
};

#endif
