#include "LoadStoreUnit.hh"
#include "InstructionSet.hh"

void LoadStoreUnit::execute(Instruction i, Operand *o, 
			    int n, ProcessorData *data)
{
  switch(getOp(i))
    {
    case mov: data->setRegister(getReg1(i), data->getRegister(getReg2(i)));
    break;
    case lod:
      {
	memory->Load(data->getRegister(getReg2(i)),this, 0);
	data->setRegister(getReg1(i), temp);
      }
      break;
    case sto:
      {
	memory->Store(data->getRegister(getReg1(i)),
		      data->getRegister(getReg2(i)), 64);
      }
    }
}

