-- ciarow.vhdl -- Carry-Increment Core Element Row
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: ciarow.vhdl,v 1.2 2000/11/17 16:54:35 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity CIA_Row is
	generic (
		WIDTH : natural := 64
	);
	port (
		Gi : in std_ulogic_vector(WIDTH-1 downto 0);
		Pi : in std_ulogic_vector(WIDTH-1 downto 0);
		Co : out std_ulogic_vector(WIDTH-1 downto 0);
		Io : out std_ulogic_vector(WIDTH-1 downto 0);
		Go : out std_ulogic_vector((WIDTH-1)/4 downto 0);
		Po : out std_ulogic_vector((WIDTH-1)/4 downto 0)
	);
end CIA_Row;

architecture Struct_1 of CIA_Row is
	component CIA_Core is
		generic (WIDTH : natural range 1 to 4 := 4);
		port (
			Gi : in std_ulogic_vector(WIDTH-1 downto 0);
			Pi : in std_ulogic_vector(WIDTH-1 downto 0);
			Co : out std_ulogic_vector(WIDTH-1 downto 0);
			Io : out std_ulogic_vector(WIDTH-1 downto 0);
			Go : out std_ulogic;
			Po : out std_ulogic
		);
	end component;

	constant n : natural := WIDTH/4;
begin
	full : for i in 0 to n-1 generate
		core : CIA_Core
			generic map (WIDTH => 4)
			port map (
				Gi => Gi(4*i+3 downto 4*i),
				Pi => Pi(4*i+3 downto 4*i),
				Co => Co(4*i+3 downto 4*i),
				Io => Io(4*i+3 downto 4*i),
				Go => Go(i),
				Po => Po(i)
			);
	end generate;
	partial : if WIDTH mod 4 /= 0 generate
		core : CIA_Core
			generic map (WIDTH => WIDTH mod 4)
			port map (
				Gi => Gi(WIDTH-1 downto 4*n),
				Pi => Pi(WIDTH-1 downto 4*n),
				Co => Co(WIDTH-1 downto 4*n),
				Io => Io(WIDTH-1 downto 4*n),
				Go => Go(n),
				Po => Po(n)
			);
	end generate;
end Struct_1;

-- vi: set ts=4 sw=4 equalprg="fmt -72 -p--": please
