
#ifndef __FCPU_MAP__
#define __FCPU_MAP__

/*

    F-CPU OPCODE MAP, PRELIMINARY VERSION

    (C) Yann Guidon ven mar 31 17:06:42 CEST 2000

This document is derived from the buggy F-CPU manual rev. 0.1
and will change quickly. Be sure to download the most recent
version and include it as "f-cpu_map.h" in your files.

This is free software ; see the GPL for copying condi
tions. There is NO warranty ; not even for MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.

whygee@f-cpu.org or f-cpu@eGroups.com


  Organization of the opcodes :
The defined numbers are a byte located in bits 0 to 7 in the instruction word.
The "-I" suffix is odd, meaning i8rr format (this could be changed, to a MSB for example).
The instruction "blocks" are not much more than 32 opcodes so they can be packed
 with this granularity.
All these numbers will be reorganized later for the VLIW boundary trick.

 total count : 104, without counting multiple occurence of BITOP(I),
COMBINE(xx) and LOADCONS(X) 

If i have time and energy, i'll make a nice colored HTML table one day.
*/


/*
 Format zero : RRR
 -----------------
 count=43

this takes one half of the whole opcode table (256 instructions)

*/

/* not a real "operation" in the sense that the data are not modified */
#define _OP_MOVE         0
/* so NOP is detected with an instruction equal to zero */

/* Integer arithmetics */
#define _OP_ADD          2
#define _OP_SUB          4
#define _OP_MUL          6
#define _OP_DIV          8
#define _OP_MOD          10
#define _OP_ADDSUB       12
#define _OP_MAC          13

/* not really arithmetic... */
#define _OP_POPCOUNT     14

/* INC-based instructions */
#define _OP_CMPL         24
#define _OP_CMPLE        26
#define _OP_MAX          28
#define _OP_MIN          30
#define _OP_SORT         21
14
/* LNS operations */
#define _OP_LADD         32
#define _OP_LSUB         33

/* SHL ("shuffler") operations */
#define _OP_SHIFTL       36
#define _OP_SHIFTR       38
#define _OP_SHIFTRA      40
#define _OP_ROTL         42
#define _OP_ROTR         44
#define _OP_BITOP        46
#define _OP_BITREV       48
/* SIMD and byte-shuffling */
#define _OP_MIX          52
#define _OP_EXPAND       53
#define _OP_SDUP         54

/* ROP2 unit (not complete : combine is new) */
#define _OP_LOGIC        56
#define _OP_COMBINE_OR   58
#define _OP_COMBINE_AND  59

/* FP (not complete) */
#define _OP_FADD         64
#define _OP_FSUB         65
#define _OP_FMUL         66
#define _OP_FDIV         71
#define _OP_FMAC         75
#define _OP_FADDSUB      76

/* LSU, dome forms ar also in intermediary format */
#define _OP_LOAD         80
#define _OP_LOADF        82
#define _OP_STORE        84
#define _OP_STOREF       86
#define _OP_CACHEMM      88

/* MISC : */
/* SRB : */
#define _OP_LOADM        108
#define _OP_STOREM       110

/* control-related */
#define _OP_JMPA         116


/*
 intermediary format : RR
 ------------------------
 can belong to either RRR or I8RR (RRR seems better)
 count=15
*/

/* INC-based instructions */
#define _OP_INC          16
/* the following functions can be
   encoded in the bits 12 and 13 
   #define _OP_DEC          17
   #define _OP_NEG          18
   #define _OP_ABS          19
*/
#define _OP_SCAN         20

/* LNS operations */
#define _OP_L2INT        34
#define _OP_INT2L        35

/* SIMD and byte-shuffling */
#define _OP_BYTEREV      50

/* FP, not complete */
#define _OP_F2INT        67
#define _OP_INT2F        68
#define _OP_FIAPRX       69
#define _OP_FSQRTIAPRX   70
#define _OP_FSQRT        72
#define _OP_FLOG         73
#define _OP_FEXP         74

/* MISC : */
/* SPR : */
#define _OP_GET          104
#define _OP_PUT          106

/* control-related */
#define _OP_LOOP         117

/*
 Format one : I8RR
 -----------------
 (plus sign bit in a 9th bit)
 count=27

 challenge : map it so it corresponds to the RRR format whenever possible.

*/

/* Integer arithmetics */

#define _OP_ADDI         3
#define _OP_SUBI         5
#define _OP_MULI         7
#define _OP_DIVI         9
#define _OP_MODI         11

/* INC-based instructions */

#define _OP_CMPLI        25
#define _OP_CMPLEI       27
#define _OP_MAXI         29
#define _OP_MINI         31

/* not really arithmetic */
#define _OP_POPCOUNTI    15

/* SHL ("shuffler") operations */
#define _OP_SHIFTLI      37
#define _OP_SHIFTRI      39
#define _OP_SHIFTRAI     41
#define _OP_ROTLI        43
#define _OP_ROTRI        45
#define _OP_BITOPI       47
#define _OP_BITREVI      49
/* SIMD and byte-shuffling */
#define _OP_SDUPI        55

/* ROP2 unit (not complete : combine is new) */
#define _OP_LOGICI       57
#define _OP_COMBINE_ORI  60
#define _OP_COMBINE_ANDI 61

/* LSU */
#define _OP_LOADI        81
#define _OP_LOADIF       83
#define _OP_STOREI       85
#define _OP_STOREIF      87
#define _OP_CACHEMMI     88

/* SRB : */
#define _OP_LOADMI       109
#define _OP_STOREMI      111

/*
 Format two : I16R
 -----------------
 count=12
 */

/* MISC : */
/* close to _OP_MOVE */
#define _OP_LOADCONS     96   /* 4-opcode range so we can create 256-bit immediates */
#define _OP_LOADCONSX    100  /* idem */
/* SPR : */
#define _OP_GETI         105
#define _OP_PUTI         107

/* control-related */
#define _OP_LOADADDR     114
#define _OP_LOADADDRI    115

/*
 Format three : I24
 ------------------
 count=7
*/

/* SRB : */
#define _OP_SRB_SAVE     112
#define _OP_SRB_RESTORE  113
/* control-related */
#define _OP_SYSCALL      118
#define _OP_RFE          119
#define _OP_HALT         120
#define _OP_SERIALIZE    121
#define _OP_INS_PACK     122



/* FC0 Execution Units  */

/* Add/Sub Unit */
#define FC0_EU_ASU          1
/* Integer Multiply Unit */ 
#define FC0_EU_IMU          2
/* Integer Divide Unit */
#define FC0_EU_IDU          3
/* bit "Shuffler" */
#define FC0_EU_SHL          4
/* "Incrementer" */
#define FC0_EU_INC          5
/* boolean operations */
#define FC0_EU_ROP2         6
/* Load/Store Unit */
#define FC0_EU_LSU          7
/* Special Register Unit */
#define FC0_EU_SRU          8
/* POPulation count */
#define FC0_EU_POP          9

#define MAX_FC0_EU          10
/* will change later */


#endif
