--------------------------------------------------------------------
-- Icache_addr_tags.vhdl : the address tags of the FC0's Icache.
-- created by Yann Guidon, oct. 24, 2000 (4am) for the F-CPU project
-- First attempt at a +/- synthesisable version. Compiled/simulated
-- with Simili. NOT YET synthetized. GPL applies. Now you're warned.
--------------------------------------------------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--------------------------------------------------------------------
-- warning : this is still an unclocked version. it will be pipelined
-- soon.

library IEEE;
    use IEEE.std_logic_1164.all;
    use IEEE.numeric_std.all;
    use work.FCPU_config.all;

ENTITY Addr_tags_type IS
  PORT(
    Clk, Inv_En, Reset, Read_En, Write_En, Freeze_En : IN Boolean;
    Address_read, Address_write, Address_Mask : IN Std_ulogic_vector(L1ABwidth-1 downto 0);
    Write_signal : IN Std_ulogic_vector(L1NBlines-1 downto 0);
    Icache_hit : OUT Boolean;
    Read_signal : OUT Std_ulogic_vector(L1NBlines-1 downto 0)
  );
END Addr_tags_type;

Architecture Addr_tags1 of Addr_tags_type IS
-- The "valid" bit for every tag line :
  signal tag_valid : Std_ulogic_vector(L1NBlines-1 downto 0) := (others=>'0');
-- the address tags themselves :
  type tag_array_type is array (L1NBlines-1 downto 0) of Std_ulogic_vector(L1ABwidth-1 downto 0);
  signal tag_array : tag_array_type; -- uninitialized : the valid tag does thejob instead.
-- Internal signal that says that the address matches :
  signal addr_match : Std_ulogic_vector(L1NBlines-1 downto 0) := (others=>'0');
  constant zero : Std_ulogic_vector(L1NBlines-1 downto 0) := (others=>'0'); --ugly, ugly !
begin

-- cache hit :
  Icache_hit <= true
    when (addr_match /= zero)
    else false;   -- open collector or hiZ trick here ?

-- FOR each comparator :
  tag_generate : for index_tag in L1NBlines-1 downto 0 generate

-- compare the addresses :
    addr_match(index_tag)<='1'
      when (Address_read=tag_array(index_tag)) and (tag_valid(index_tag)='1')
      else '0';

-- read operation :
    Read_signal(index_tag)<='1'
      when (addr_match(index_tag)='1') and (Read_En=true)
      else '0';

-- invalidation (without mask...) and reset
    tag_valid(index_tag)<='0' when ((reset=true) or ((addr_match(index_tag)='1') and (Inv_En=true))) -- reset the flag / normally, it should be a R/S cell (??timing??)
-- Write an address tag : (set the R/S)
      else '1' when ((Write_signal(index_tag)='1') and (Write_En=true)) -- beware of the clocking ...
      else tag_valid(index_tag);

    tag_array(index_tag)<=Address_write
      when ((Write_signal(index_tag)='1') and (Write_En=true)); -- beware of the clocking ...
-- help, the conditions are similar, should i make a process ?


  end generate tag_generate;

end Addr_tags1;
