DO _NOT_ COMPILE AS IS.

--------------------------------------------------------------------------
-- testbench_template.vhdl : template for the F-CPU project
-- Copyright (C) 2000 Yann GUIDON (whygee@f-cpu.org) 10/22/2000@20h
-- 
-- Do not compile this file. It is only a template.
-- Wherever needed, replace the letters EU with the Execution Unit's name.
-- This file is adapted from the file Icache_testbench.vhdl.
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
--------------------------------------------------------------------------
-- This is an attempt to make a rather generic template for testing
-- Execution Units. It reads an input file, parses a simple syntax
-- that describes the test vectors, and outputs the result on the screen.
-- It can be customised at will, the vector's syntax can be changed easily.
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.std_logic_textio.all;
    USE ieee.numeric_std.all;
LIBRARY std;
    USE std.textio.ALL;
    USE work.FCPU_config.ALL;

-- include here : the declaration of the tested design unit.
    USE work.EUdesign.ALL;


entity EU_testbench is
  GENERIC(
    filename : string := "testvectors.txt" -- name of the vector file
  );
end EU_testbench;

architecture test of EU_testbench is
-- Copy of the design's port declaration, for example :
  signal din, dout, Address_write : Std_ulogic_vector();
  signal reset, clk, Read_En, Write_En : Boolean:=false;

-- internal counter :
  shared variable cycle : natural :=0;
  shared variable lout : line ;

  procedure print is
  begin
    WRITE(lout,"* cycle # : ");
    WRITE(lout,cycle);
-- print all the signals here :

    if clk=true then
      WRITE(lout,"   clk");
    end if;
    if reset=true then
      WRITE(lout,"   reset");
    end if;
    if Read_En=true then
      WRITE(lout,"   Read_En:");
      HWRITE(lout,Address_read);
    end if;
    if Write_En=true then
      WRITE(lout,"   Write_En:");
      HWRITE(lout,Address_write);
      WRITE(lout," Din=");
      HWRITE(lout,Din);
      WRITELINE(OUTPUT, lout);
    end if;
    if Inv_En=true then
      WRITE(lout,"   Inv_En:");
      HWRITE(lout,Address_read);
      WRITE(lout,", address_mask:");
      HWRITE(lout,Address_Mask);
    end if;
    WRITELINE(OUTPUT, lout);
  end;

-- For a dumb parser in VHDL :
  shared variable temp_char : Character := NUL;  -- parsed character
  shared variable buff : line;       -- line from which we parse
  shared variable line_number : natural:=0;
  shared variable i : natural;

  procedure getch is -- "read()" does not have "unread()"...
  begin
    temp_char:=buff(i);
    i:=i+1;
  end;

  -- warning !!! no overflow checks !!!
  function get_hexa(s:Std_ulogic_vector) return Std_ulogic_vector is
    variable t:Std_ulogic_vector(3 downto 0):=(others=>'0');
    variable u:Std_ulogic_vector(s'high downto 0):=(others=>'0');
  begin
    hexa_loop : while i<=buff'high loop
      getch;
      case temp_char is
        when '0' => t:=X"0";
        when '1' => t:=X"1";
        when '2' => t:=X"2";
        when '3' => t:=X"3";
        when '4' => t:=X"4";
        when '5' => t:=X"5";
        when '6' => t:=X"6";
        when '7' => t:=X"7";
        when '8' => t:=X"8";
        when '9' => t:=X"9";
        when 'A' => t:=X"A";
        when 'B' => t:=X"B";
        when 'C' => t:=X"C";
        when 'D' => t:=X"D";
        when 'E' => t:=X"E";
        when 'F' => t:=X"F";
        when 'a' => t:=X"A";
        when 'b' => t:=X"B";
        when 'c' => t:=X"C";
        when 'd' => t:=X"D";
        when 'e' => t:=X"E";
        when 'f' => t:=X"F";
        when others => i:=i-1; return u;
      end case;
-- shift left :
      u(u'high downto 4):=u((u'high)-4 downto 0);
      u(3 downto 0):=t;
    end loop;
-- exits here only if EOL :
    return u;
  end;

begin

 -- Instantiate the tested circuit
 EU_instance : entity EU_type
   port map(
     Din => din,
     Dout => dout,
     clk => clk,
     reset => reset,
     Address_write => Address_write,
     Read_En => Read_En,
     Write_En => Write_En
   );

 -- the testbench routine :
 process
   file test_vector : TEXT OPEN READ_MODE IS filename;
   variable temp_reset,temp_Read_En, temp_Write_En : boolean;
 begin
-- init/reset (for sequential circuits)
   Din<=(others=>'0');
   reset<=true;
   wait for 10 ns;
   reset<=false;
   wait for 10 ns;

-- begin the simulation body :
   while (not endfile(test_vector)) loop
     -- init temp inputs :
     temp_reset:=false;

     -- read one vector line from the file :
     readline(test_vector,buff);
     line_number:=line_number+1;
     write(lout,"*** decoding line #");
     write(lout,line_number);
     writeline(output,lout);

     If buff'length/=0 then

     -- parsing "buff" here ...
       i:=1;
parse_loop:
       while i<=buff'high loop
         getch;
         case temp_char is

           when ';' => -- it's a comment
             exit parse_loop;

           when 'Q' =>
             write(lout,LF&"   ### End of vector file ###."&LF);
             writeline(output,lout);
             wait;

           when 'T' =>
             if temp_reset=true then
               write(lout,"Warning : multiple Reset in vector !"&BEL);
             else
               temp_reset:=true;
             end if;

           when 'W' =>
             if temp_Write_En=true then
               write(lout,"Warning : multiple Writes in vector !"&BEL);
             else
               Address_write<=get_hexa(Address_write);
               i:=i+1; -- correct the index, restore the character that has been already "eaten"
               if temp_char/=':' then
                 report "expected ':' between address & data, not found";
               end if;
               Din<=get_hexa(Din);
               temp_Write_En:=true;
             end if;

           when 'R' =>
             if (temp_Freeze_En=true) then
               write(lout,"Warning : multiple Reads in vector !"&BEL);
             else
               Address_read<=get_hexa(Address_read);
               temp_Read_En:=true;
             end if;

           when others =>
             write(lout,LF&"  # unknown command : ");
             write(lout,temp_char&LF);

         end case;
         writeline(output,lout);
  
-- expect a coma/separator/EOL :
         if (i-1>=buff'High) then   -- do not expect coma if already at end of line
           exit parse_loop;
         end if;
         getch;
         if (temp_char = ';') then
           exit parse_loop;
         end if;
         if (temp_char /= ',') then
           write(lout,"',' expected, got ");
           write(lout,temp_char);
           write(lout," instead");
           writeline(output,lout);
         end if;

       end loop parse_loop;
     end if; -- void string

     -- perform the assignation :
     reset<=temp_reset;
     Read_En<=temp_Read_En;
     Write_En<=temp_Write_En;

     -- cycle :
     clk<=true;        -- rising edge
     cycle:=cycle+1;   -- advance the counter
     wait for 10 ns;   -- let the circuit do the work
     clk<=false;       -- falling edge
     wait for 10 ns;   -- leave some time to react
     print;            -- be happy
   end loop;

   file_close(test_vector);

   wait; -- stop the simulation
 end process;

end test;
