--------------------------------------------------------------------
-- F-CPU project : Instruction cache specification & testbench
-- Yann Guidon, oct. 3, 2000 (2am) with a lot of material
-- from the f-cpu@egroups.com mailing list (mostly Michael & Colin)
-- This file is not finished.
--------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;
use ieee.std_logic_textio.all;

ENTITY  Icache_type  IS
  GENERIC(
    DBwidth  : natural := 256 ; -- Data Bus width, or width of each cache line (32 bytes)
    ABwidth  : natural := 32  ; -- Address Buss width, in 32-byte chuncks (32+5=128GB)
    LogLines : natural := 6   ; -- Log2 of the NumBer of cache Lines (MUST be EVEN)
    NBlines  : natural := 64    -- NumBer of cache Lines (2**LogLines) (small number for the first attempts)
  );
  PORT(
   Clk, Inv_En, Reset, Read_En, Write_En, Freeze_En : IN Boolean;
   Address_read, Address_write, Address_Mask : IN Std_ulogic_vector(ABwidth-1 downto 0);
-- "natural" should be used for the addresses, right ? But how do we handle
-- the AND with the masks ?
   Icache_hit : OUT Boolean;
   Din  :  IN Std_ulogic_vector(DBwidth-1 downto 0);
   Dout : OUT Std_ulogic_vector(DBwidth-1 downto 0)
  );
END Icache_type;

--------------------------------------------------------------------
-- Dumb latch with reset.
--------------------------------------------------------------------
Architecture dumb of Icache_type IS
begin
 process (CLK, reset)
     variable lout : line ;
 begin
   if reset=true then
     Dout<=(others=>'0');
     WRITE(lout,"Reset");
     WRITELINE(OUTPUT, lout);
     WRITE(lout," ");
     WRITELINE(OUTPUT, lout);
   else
     if (CLK'event and CLK=true) then
       Dout<=Din;
     end if;
   end if;
 end process;

end dumb;


--------------------------------------------------------------------
-- Testbenching :
--------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;
use ieee.std_logic_textio.all;
use Work.Icache_type;

entity testbench is
-- copy of the above declaration
  GENERIC(
    DBwidth  : natural := 256 ; -- Data Bus width, or width of each cache line (32 bytes)
    ABwidth  : natural := 32  ; -- Address Buss width, in 32-byte chuncks (32+5=128GB)
    LogLines : natural := 6   ; -- Log2 of the NumBer of cache Lines (MUST be EVEN)
    NBlines  : natural := 64    -- NumBer of cache Lines (2**LogLines) (small number for the first attempts)
  );
end testbench;

architecture test1 of testbench is
-- this is another copy, but here are the signals/ports :
  signal din,dout : Std_ulogic_vector(DBwidth-1 downto 0); -- uninitialized on purpose.
  signal reset,clk,Inv_En,Read_En,Write_En,Freeze_En : Boolean:=false; -- inputs of the cache
  signal Address_read, Address_write, Address_Mask : Std_ulogic_vector(ABwidth-1 downto 0):=(others=>'0');
  signal Icache_hit : Boolean; -- uninitialized : output signal;

-- internal counter :
  shared variable cycle : natural :=1;

  procedure print is
    variable lout : line ;
  begin
    WRITE(lout,"* cycle:");
    WRITE(lout,cycle);
    WRITELINE(OUTPUT, lout);
--    WRITE(lout,"Din :");
--    WRITE(lout,din);
--    WRITELINE(OUTPUT, lout);
--    WRITE(lout,"Dout:");
--    WRITE(lout,dout);
--    WRITELINE(OUTPUT, lout);
    if clk=true then
      WRITE(lout,"   clk");
    end if;
    if reset=true then
      WRITE(lout,"   reset");
    end if;
    if Icache_hit=true then
      WRITE(lout,"   Icache_hit ! Dout=");
      WRITE(lout,Dout);
      WRITELINE(OUTPUT, lout);
    end if;
    if Read_En=true then
      WRITE(lout,"   Read_En:");
      WRITE(lout,Address_read);
    end if;
    if Write_En=true then
      WRITE(lout,"   Write_En:");
      WRITE(lout,Address_write);
      WRITE(lout," Din=");
      WRITE(lout,Din);
      WRITELINE(OUTPUT, lout);
    end if;
    if Inv_En=true then
      WRITE(lout,"   Inv_En:");
      WRITE(lout,Address_read);
      WRITE(lout,", address_mask:");
      WRITE(lout,Address_Mask);
    end if;
    if Freeze_En=true then
      WRITE(lout,"   Freeze_En:");
      WRITE(lout,Address_read);
      WRITE(lout,", address_mask:");
      WRITE(lout,Address_Mask);
    end if;
    WRITELINE(OUTPUT, lout);
    WRITE(lout," ");
    WRITELINE(OUTPUT, lout);
  end;

begin

 -- Instantiate the tested circuit
 Icache : entity Icache_type
   port map(
     Din => din,
     Dout => dout,
     clk => clk,
     reset => reset,
     Inv_En => Inv_En,
     Read_En => Read_En,
     Write_En => Write_En,
     Freeze_En => Freeze_En,
     Address_read => Address_read,
     Address_write => Address_write,
     Address_Mask => Address_Mask,
     Icache_hit => Icache_hit
   );

 process
 begin
   Din<=(others=>'0');
-- init/reset :
   print;
   reset<=true;
   wait for 10 ns;
   print;
   reset<=false;
   wait for 10 ns;
   print;

-- begin the simulation body :

   clk<=true;        -- rising edge
   cycle:=cycle+1;
   wait for 10 ns;   -- let the circuit do the work
   clk<=false;       -- falling edge
   wait for 10 ns;   -- leave some time to react
   print;            -- be happy
   -- now change the parameters
   

--    for azerty in 0 to 10 loop
--      clk<='1';
--      wait for 10 ns;
--      clk<='0';
--      wait for 10 ns;
--      cycle:=cycle+1;
--      print;
--    end loop;

   wait; -- stop the simulation
 end process;

end test1;
