-- tb_inc.vhdl - Testbench for F-CPU inc Unit
-- Copyright (C) 2000 Erik Hansen <erik.hansen@berlin.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

library ieee;
use ieee.std_logic_1164.all;

entity test is
  
end test;

architecture tb of test is

  signal control        : std_ulogic_vector( 8 downto 0);
  signal scontrol       : string (4 downto 1);
  signal size           : std_ulogic_vector( 2 downto 0);
  signal r1, r2, r3, r4 : std_ulogic_vector(63 downto 0);
  
  component inc
    
    port (
      r1   : in  std_ulogic_vector(63 downto 0); 
      r2   : in  std_ulogic_vector(63 downto 0);  
      r3   : out std_ulogic_vector(63 downto 0);
      r4   : out std_ulogic_vector(63 downto 0); 
      iin  : in  std_ulogic;                   
      rev  : in  std_ulogic;                   
      cmp  : in  std_ulogic;                 
      inc  : in  std_ulogic;                  
      scan : in  std_ulogic;                   
      oin  : in  std_ulogic;                  
      smin : in  std_ulogic;               
      smax : in  std_ulogic;                   
      sabs : in  std_ulogic;
      U08  : in  std_ulogic;
      U16  : in  std_ulogic;
      U32  : in  std_ulogic);

  end component inc;
  
begin  -- tb

  -- Enter your test vectors here!
  -- This testbench cycles through all command every 220 ns.
  -- Don't forget the wait command after every bundle of invecs.
  
  in_values: process
    
  begin  -- process in_values

    -- At least this should work OK
    r1 <= "0000000000000000000000000000000000000000000000000000000000000000";
    r2 <= "0000000000000000000000000000000000000000000000000000000000000000";
    wait for 220 ns;
    -- Taken from the examples in the F-CPU Manual rev 0.2
    r1 <= "1111111100000101100010010001001000010011010001010000000100000000";
    wait for 220 ns;
    -- Taken from the examples in the F-CPU Manual rev 0.2
    r1 <= "0000000000000000000000000000010100000000000000000000000000000011";
    r2 <= "0000000000000000000000000000011100000000000000000000000000000001";
    wait for 220 ns;
    -- Taken from the examples in the F-CPU Manual rev 0.2
    r1 <= "0000000000000000000000000000011100000000000000000000000000000001";
    r2 <= "0000000000000000000000000000010100000000000000000000000000000011";
    wait for 220 ns;
    -- Add much more testdata here
    
  end process in_values;

  -- This process cycles through all commands
  -- Needs 220 ns;
  
  commands: process
    
  begin  -- process commands

    scontrol <= "inc ";
    control <= "000100000";
    wait for 20 ns;  -- inc
    
    scontrol <= "dec ";
    control <= "100101000";
    wait for 20 ns;  -- dec
    
    scontrol <= "neg ";
    control <= "100100000";
    wait for 20 ns;  -- neg

    scontrol <= "lsb0";
    control <= "000110000";
    wait for 20 ns;  -- lsb0

    scontrol <= "lsb1";
    control <= "100110000";
    wait for 20 ns;  -- lsb1
    
    scontrol <= "msb0";
    control <= "010110000";
    wait for 20 ns;  -- msb0
    
    scontrol <= "msb1";
    control <= "110110000";
    wait for 20 ns;  -- msb1
    
    scontrol <= "cmpl";
    control <= "001100000";
    wait for 20 ns;  -- cmpl
    
    scontrol <= "abs ";
    control <= "100100001";
    wait for 20 ns;  -- abs

    scontrol <= "max ";
    control <= "001100010";
    wait for 20 ns;  -- max

    scontrol <= "min ";
    control <= "001100001";
    wait for 20 ns;  -- min
    
  end process commands;

  -- This Process cycles through all data sizes
  -- Need 20 ns for one cycle

  psize: process
    
  begin  -- process size

    size <= "000"; wait for 5 ns;       --  8 bit
    size <= "100"; wait for 5 ns;       -- 16 bit
    size <= "110"; wait for 5 ns;       -- 32 bit
    size <= "111"; wait for 5 ns;       -- 64 bit
    
  end process psize;

  incrementer : inc port map (
    r1   => r1,
    r2   => r2,
    r3   => r3,
    r4   => r4,
    iin  => control(8),
    rev  => control(7),
    cmp  => control(6),
    inc  => control(5),
    scan => control(4),
    oin  => control(3),
    smin => control(2),
    smax => control(1),
    sabs => control(0),
    u08  => size(2),
    u16  => size(1),
    u32  => size(0));

end tb;
