#include <stdio.h>

#define NODE bool
#define HI true
#define LO false


// ########## 2 input AND Gate ###################
class and2 {

public:

NODE *in1, *in2, *out;

and2::and2 (NODE *_in1,
                NODE *_in2,
                NODE *_out) {
  in1=_in1;
  in2=_in2;
  out=_out;
};

void and2::delta () {
  *out=*in1 && *in2;
};


}; //end class and2

// ########## array of 32 AND Gates ############
class and2_32 {

public:

and2 *thegates[32];

and2_32::and2_32 (NODE _in1[32],
                    NODE _in2[32],
                    NODE _out[32]) {
 int x;
 for (x=0;x<32;x++) thegates[x]=new and2(&_in1[x],&_in2[x],&_out[x]);
}; //end of constructor

and2_32::~and2_32 () {
  int x;
  for (x=0;x<32;x++) delete thegates[x];
};

void and2_32::delta() {
 int x;
 for (x=0;x<32;x++) {
   thegates[x]->delta();
 };
}; //end of delta function

}; //end of class and2_32


// ########### 2 input NAND Gate #################
class nand2 {

public:

NODE *in1,*in2,*out;

nand2::nand2 (NODE *_in1,
                  NODE *_in2,
                  NODE *_out) {
  in1=_in1;
  in2=_in2;
  out=_out;
}

void nand2::delta () {
  if(*in1 && *in2) {
    *out=LO;
  } else {
    *out=HI;
  };
};

}; //end class nand2



//###################### Tristate Buffer #################

class tribuf1 {

public:

 NODE *in,*enable,*out;

tribuf1::tribuf1 (NODE *_in,
                       NODE *_enable,
                       NODE *_out) {
   in=_in;
   enable=_enable;
   out=_out;
 };

 void tribuf1::delta () {
   if(enable) *out=*in;
 };

}; //end class tribuf1



//################### D Type Flip Flop #######################

class dtype1 {

public:

NODE oldclock,*in,*clock,*out;


dtype1::dtype1 (NODE *_in,
                    NODE *_clock,
                    NODE *_out) {
  in=_in;
  clock=_clock;
  out=_out;
};

void dtype1::delta () {
  if (oldclock == LO && *clock == HI) {
    //positive edge so
    *out=*in;
  };
  oldclock = *clock;
};

}; //end of class dtype1
//---------------------------------------------------



//parts to complete:

//dtype1_32
//tribuf1_32
//and2_32
//nand2_32
//invert1_32
//add2_32 perhaps join up many add2_4??


void main() {

  //################# 2 input AND test ###############
  printf ("AND 2 input test\n\r");
  NODE a,b,c;
  and2 gate1(&a,&b,&c);
  a=HI;  b=HI;
  gate1.delta();
  if (c) {
    printf ("and (11) results in TRUE\n\r");
  } else {
    printf ("and (11) results in FALSE\n\r");
  };

  a=HI;  b=LO;
  gate1.delta();
  if (c) {
    printf ("and (10) results in TRUE\n\r");
  } else {
    printf ("and (10) results in FALSE\n\r");
  };

  a=LO;  b=HI;
  gate1.delta();
  if (c) {
    printf ("and (01) results in TRUE\n\r");
  } else {
    printf ("and (01) results in FALSE\n\r");
  };

  a=LO;  b=LO;
  gate1.delta();
  if (c) {
    printf ("and (00) results in TRUE\n\r");
  } else {
    printf ("and (00) results in FALSE\n\r");
  };

  //buses will be done thus
  //const buswidth=32;
  //NODE a[buswidth];

  NODE a32[32],b32[32],c32[32];
  and2_32 thegate(a32,b32,c32);
  int x;
  int count1=0;
  int count2=0;
  printf ("\n\rStarting 32 bit test\n\r");
  printf ("Test 1 HIHIHILO on a, HILO on b\n\r");
  for (x=0;x<32;x++) {
    if (count1==0) {
      a32[x]=HI;
    } else {
      a32[x]=LO;
    };
    count1++;
    if (count1==2) count1=0;

    if (count2==0) {
      b32[x]=HI;
    } else {
      b32[x]=LO;
    };
    count2++;
    if (count2==5) count2=0;
  };

  thegate.delta();

  printf("A32 = ");
  for (x=0;x<32;x++) {
    if (a32[x]==HI) printf("H"); else printf("L");
  };
  printf("\n\r");

  printf("B32 = ");
  for (x=0;x<32;x++) {
    if (b32[x]==HI) printf("H"); else printf("L");
  };
  printf("\n\r");


  printf("C32 = ");
  for (x=0;x<32;x++) {
    if (c32[x]==HI) printf("H"); else printf("L");
  };
  printf("\n\r");




} //end main













