#ifndef ProcessorDecoder64__HH
#define ProcessorDecoder64__HH

#include "ProcessorSimulator64.hh"
#include "ProcessorData64.hh"
#include "ProcessingUnit.hh"
#include "InstructionSet.hh"

class ProcessorDecoder64: 
  public virtual ProcessorDecoder,
  public virtual ProcessorUnit,
  public virtual MemoryUser,
  public virtual ProcessingUnit
{
private:
  const static char *const name = "Processor Decoder F64";
  ProcessorSimulator *simulator;
  ProcessorData *data;
  MemoryUnit *memory;
  RegType temp;
  RegType iadd;

public:

  void tick();
  void init() {}
  const char *getUnitName() { return name; }
  void initDecoder(ProcessorSimulator *s,ProcessorData *d, MemoryUnit *m);
  void get(RegType p, int tag) { temp = p; };
  void execute(Instruction i, Operand *o, int n, ProcessorData *data);
};

#endif
