#ifndef InstructionSet__HH
#define InstructionSet__HH

const int unitsel = 2;   // only 4 units 
const int oplen   = 3;   // max 8 operations per unit
const int rlen    = 6;   // register are coded on 6 bits

const int unMask  = 0xc0000000; //1100000000000000000000000000000000b
const int opMask  = 0x38000000; //0011100000000000000000000000000000b
const int r1Mask  = 0x0fc00000; //0000011111100000000000000000000000b
const int r2Mask  = 0x001f8000; //0000000000011111100000000000000000b
const int l16Mask = 0x001fffe0; //0000000000011111111111111110000000b

const int shiftun  = 30; // 8*sizeof(int)-unitsel
const int shiftop  = 27; // 8*sizeof(int)-(unitsel+opsel)
const int shiftr1  = 21; // 8*sizeof(int)-(unitsel+opsel-rlen)
const int shiftr2  = 15; // 8*sizeof(int)-(unitsel+opsel-2*rlen)
const int shiftl16 =  7; // 8*sizeof(int)-(unitsel+opsel+rlen+16)


inline char getUnit(Instruction i) { return char ((i&&unMask)>>shiftun);}
inline char getOp(Instruction i)   { return char ((i&&opMask)>>shiftop);}
inline char getReg1(Instruction i) { return char ((i&&r1Mask)>>shiftr1);}
inline char getReg2(Instruction i) { return char ((i&&r2Mask)>>shiftr2);}
inline int  getIm16(Instruction i) { return int  ((i&&l16Mask)>>shiftl16);}

// Decoder
const int jmp =  1; // jmp Ra     (R0=Ra)
const int jz  =  2; // jz  Ra     (if(zf) R0=Ra)
const int jnz =  3; // jnz Ra     (if(!zf) R0=Ra)
const int l64 =  4; // mov Ra, imm64 (Ra=imm64) // Warning 3 instructions
const int l32 =  5; // mov Ra, imm32 (Ra=imm32) // Warning 2 instructions
const int l16 =  6; // mov Ra, imm16 (Ra=imm16)

// Load Store
const int mov =  1; // mov Ra, Rb (Ra=Rb)
const int lod =  2; // lod Ra, Rb (Ra=*Rb)
const int sto =  3; // sto Ra, Rb (*Ra=Rb)

// Logical unit
const int not = 1; // not Ra     (Ra=~Ra)
const int and = 2; // and Ra, Rb (Ra&=Rb)
const int or  = 3; // or  Ra, Rb (Ra|=Rb)
const int xor = 4; // xor Ra, Rb (Ra^=Rb)

// Integer Unit
const int add = 1; // add Ra, Rb (Ra+=Rb)
const int neg = 2; // neg Ra     (Ra=-Ra)
const int mul = 3; // mul Ra, Rb (Ra*=Rb)
const int div = 4; // div Ra, Rb (Ra/=Rb)
const int shl = 5; // shl Ra, Rb (Ra<<Rb)
const int shr = 6; // shr Ra, Rb (Ra>>Rb)
const int rol = 7; // rol Ra, Rb (Ra{{Rb)
const int ror = 8; // ror Ra, Rb (Ra}}Rb) 

#endif
