;; Machine description for FCPU for GNU C compiler
;; Copyright (C) 1999 FCPU Project
;; Contributed by Brossard Mathias (f95mabr@dd.chalmers.se)

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.

;; Processor type -- this attribute must exactly match the processor_type
;; enumeration in alpha.h.

(define_attr "cpu" "f0"
  (const (symbol_ref "f_cpu")))

(define_attr "type" 
  "unknown,load,store,move,alu,branch,jump,fp,multi" 
  (const_string "unknown"))

;; Define the operand size an insn operates on.  Used primarily by mul
;; and div operations that have size dependant timings.

(define_attr "opsize" "qi,hi,si,di" (const_string "di"))

(define_attr "mode" "unknown,none,QI,HI,SI,DI,SF,DF" 
             (const_string "unknown"))

;; The TRAP_TYPE attribute marks instructions that may generate traps
;; (which are imprecise and may need a trapb if software completion
;; is desired).

(define_attr "trap" "no,yes" (const_string "no"))

;; The length of an instruction sequence in bytes.

(define_attr "length" "" (const_int 4))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; movm

(define_insn "movdi"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,=r,=r,=m")
	(match_operand:DI 1 "general_operand" "r, m, i, r"))]
  ""
  "@
   mov %1, %0
   load %1, %0
   ldcns %1, %0
   store %1, %0")

(define_insn "movsi"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r,r,r,m")
	(match_operand:SI 1 "general_operand" "r,m,i,r"))]
  ""
  "@
   mov.q %1, %0
   load.q %1, %0
   ldcns.q %1, %0
   store.q %1, %0")


(define_insn "movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=r,r,r,m")
	(match_operand:HI 1 "general_operand" "r,m,i,r"))]
  ""
  "@
   mov.d %1, %0
   load.d %1, %0
   ldcns.d %1, %0
   store.d %1, %0")

(define_insn "movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=r,=r,=r,=m")
	(match_operand:QI 1 "general_operand" "r, m, i, r"))]
  ""
  "@
   mov.b %1, %0
   load.b %1, %0
   ldcns.b %1, %0
   store.b %1, %0")

(define_insn "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f,m,f,f,r")
	(match_operand:DF 1 "general_operand"      " m,f,f,r,f"))]
  ""
  "@
   load %1, %0
   store %1, %0
   mov %1, %0
   int2f %1, %0
   f2int %1, %0"
   [(set_attr "type" "load,store,move,fp,fp")
    (set_attr "mode" "DF")])

(define_insn "movsf"
  [(set (match_operand:SF 0 "general_operand" "=f,m,f,f,r")
	(match_operand:SF 1 "general_operand" " m,f,f,r,f"))]
  ""
  "@
   load.d %1, %0
   store.d %1, %0
   mov.d %1, %0
   int2f.f %1, %0
   f2int.f %1, %0"
   [(set_attr "type" "load,store,move,fp,fp")
    (set_attr "mode" "SF")])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; arithmetic shift left 
(define_insn "ashldi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
        (ashift:DI (match_operand:DI 1 "register_operand" "r,r")
                   (match_operand:DI 2 "general_operand" " r,i")))]
  ""
  "@
   shiftl %2, %1, %0
   shiftli %2, %1, %0")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; arithmetic shift right 
(define_insn "ashrdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
        (ashiftrt:DI (match_operand:DI 1 "register_operand" "r,r")
                   (match_operand:DI 2 "general_operand" " r,i")))]
  ""
  "@
   shiftra %2, %1, %0
   shiftrai %2, %1, %0")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; logical shift right
(define_insn "lshrdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
        (lshiftrt:DI (match_operand:DI 1 "register_operand" "r,r")
                     (match_operand:DI 2 "general_operand" " r,i")))]
  ""
  "@
   shiftr %2, %1, %0
   shiftri %2, %1, %0")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; unsigned modulo
(define_insn "umoddi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
        (mod:DI (match_operand:DI 1 "register_operand" "%r,r")
                 (match_operand:DI 2 "general_operand" " r,i")))]
  ""
  "@
   umod %1, %2, %0
   umodi %1, %2, %0")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; unsigned division 
(define_insn "udivdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
        (udiv:DI (match_operand:DI 1 "register_operand" "%r,r")
                 (match_operand:DI 2 "general_operand" " r,i")))]
  ""
  "@
   udiv %1, %2, %0
   udivi %1, %2, %0")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; neg
(define_insn "negdi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
        (neg:DI (match_operand:DI 1 "register_operand" "r")))]
  ""
  "neg %1, %0")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; add
(define_insn "adddi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(plus:DI (match_operand:DI 1 "register_operand" "%r,r")
		 (match_operand:DI 2 "general_operand" " r,i")))]
  ""
  "@
   add %1, %2, %0
   addi %1, %2, %0"
  [(set_attr "type"     "alu")
   (set_attr "mode"     "DI")])

(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(plus:SI (match_operand:SI 1 "register_operand" "%r,r")
		 (match_operand:SI 2 "general_operand" " r,i")))]
  ""
  "@
   add.q %1, %2, %0
   addi.q %1, %2, %0"
   [(set_attr "type"     "alu")
    (set_attr "mode"     "SI")])

(define_insn "addhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	(plus:HI (match_operand:HI 1 "register_operand" "%r,r")
		 (match_operand:HI 2 "general_operand" " r,i")))]
  ""
  "@
   add.d %1, %2, %0
   addi.d %1, %2, %0"
  [(set_attr "type"     "alu")
   (set_attr "mode"     "HI")])

(define_insn "addqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	(plus:QI (match_operand:QI 1 "register_operand" "%r,r")
		 (match_operand:QI 2 "general_operand" " r,i")))]
  ""
  "@
   add.b %1, %2, %0
   addi.b %1, %2, %0"
   [(set_attr "type"     "alu")
    (set_attr "mode"     "QI")])


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; sub

(define_insn "subdi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(minus:DI (match_operand:DI 1 "register_operand" "r")
		  (match_operand:DI 2 "register_operand" "r")))]
  ""
  "sub %1, %2, %0")

(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(minus:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "register_operand" "r")))]
  ""
  "sub.q %1, %2, %0")

(define_insn "subhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(minus:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "register_operand" "r")))]
  ""
  "sub.d %1, %2, %0")

(define_insn "subqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(minus:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "register_operand" "r")))]
  ""
  "sub.b %1, %2, %0")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;mul

(define_insn "muldi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(mult:DI (match_operand:DI 1 "register_operand" "%r,r")
		 (match_operand:DI 2 "general_operand" "r,i")))]
  ""
  "@
   mul %1, %2, %0
   muli %1, %2, %0")

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(mult:SI (match_operand:SI 1 "register_operand" "%r")
		 (match_operand:SI 2 "register_operand" "r")))]
  ""
  "mul.q %1, %2, %0")

(define_insn "mulhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(mult:HI (match_operand:HI 1 "register_operand" "%r")
		 (match_operand:HI 2 "register_operand" "r")))]
  ""
  "mul.d %1, %2, %0")

(define_insn "mulqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(mult:QI (match_operand:QI 1 "register_operand" "%r")
		 (match_operand:QI 2 "register_operand" "r")))]
  ""
  "mul.b %1, %2, %0")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; div

(define_insn "divdi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(div:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "general_operand" "r,i")))]
  ""
  "@
   div %1, %2, %0
   divi %1, %2, %0")

(define_insn "divsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(div:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "register_operand" "r")))]
  ""
  "div.q %1, %2, %0")

(define_insn "divhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(div:HI (match_operand:HI 1 "register_operand" "r")
		  (match_operand:HI 2 "register_operand" "r")))]
  ""
  "div.d %1, %2, %0")

(define_insn "divqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(div:QI (match_operand:QI 1 "register_operand" "r")
		  (match_operand:QI 2 "register_operand" "r")))]
  ""
  "div.b %1, %2, %0")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; fadd

(define_insn "adddf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(plus:DF (match_operand:DF 1 "register_operand" "%f")
		(match_operand:DF 2 "register_operand" "f")))]
  ""
  "fadd %1,%2,%0"
  [(set_attr "type"     "fp")
   (set_attr "mode"     "DF")])

(define_insn "addsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(plus:SF (match_operand:SF 1 "register_operand" "%f")
		(match_operand:SF 2 "register_operand" "f")))]
  ""
  "fadd.f %1,%2,%0"
  [(set_attr "type"     "fp")
   (set_attr "mode"     "SF")])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; fsub

(define_insn "subdf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(minus:DF (match_operand:DF 1 "register_operand" "f")
		  (match_operand:DF 2 "register_operand" "f")))]
  ""
  "fsub %1,%2,%0"
  [(set_attr "type"     "fp")
   (set_attr "mode"     "DF")])

(define_insn "subsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(minus:SF (match_operand:SF 1 "register_operand" "f")
		(match_operand:SF 2 "register_operand" "f")))]
  ""
  "fsub.f %1,%2,%0"
  [(set_attr "type"     "fp")
   (set_attr "mode"     "SF")])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; fmul

(define_insn "muldf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(mult:DF (match_operand:DF 1 "register_operand" "%f")
		 (match_operand:DF 2 "register_operand" "f")))]
  ""
  "fmul %1,%2,%0"
  [(set_attr "type"     "fp")
   (set_attr "mode"     "DF")])

(define_insn "mulsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(mult:SF (match_operand:SF 1 "register_operand" "%f")
		 (match_operand:SF 2 "register_operand" "f")))]
  "TARGET_FP"
  "fmul.f %1,%2,%0"
  [(set_attr "type"     "fp")
   (set_attr "mode"     "SF")])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; fdiv

(define_insn "divdf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(div:DF (match_operand:DF 1 "register_operand" "f")
		 (match_operand:DF 2 "register_operand" "f")))]
  ""
  "fdiv %1,%2,%0"
  [(set_attr "type"     "fp")
   (set_attr "mode"     "DF")])

(define_insn "divsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(div:SF (match_operand:SF 1 "register_operand" "f")
		 (match_operand:SF 2 "register_operand" "f")))]
  ""
  "fdiv.f %1,%2,%0"
  [(set_attr "type"     "fp")
   (set_attr "mode"     "SF")])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; floating point neg

(define_insn "negsf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (neg:SF (match_operand:SF 1 "register_operand" "f")))]
  ""
  "fneg.f %1,%0"
  [(set_attr "type" "fp")
   (set_attr "mode" "SF")])

(define_insn "negdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (neg:DF (match_operand:DF 1 "register_operand" "f")))]
  ""
  "fneg %1,%0"
  [(set_attr "type" "fp")
   (set_attr "mode" "DF")])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; comparison
(define_insn "cmpdi"
  [(set (cc0)
        (compare:CC (match_operand:DI 0 "register_operand" "r")
                    (match_operand:DI 1 "general_operand" "g")))]
  ""
  "
{
      fcpu_compare_op0 = operands[0];
      fcpu_compare_op1 = operands[1];
      fcpu_compare_mode = DImode;
      DONE;
}")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; conditional branch
(define_expand "beq"
  [(set (pc) (if_then_else (eq (cc0) (const_int 0))
     (label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ gen_conditional_branch(operands, EQ); DONE; }")

(define_expand "bne"
  [(set (pc) (if_then_else (ne (cc0) (const_int 0))
     (label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ gen_conditional_branch(operands, NE); DONE; }")

(define_expand "blt"
  [(set (pc) (if_then_else (lt (cc0) (const_int 0))
     (label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ gen_conditional_branch(operands, LT); DONE; }")

(define_expand "bgt"
  [(set (pc) (if_then_else (gt (cc0) (const_int 0))
     (label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ gen_conditional_branch(operands, GT); DONE; }")

(define_expand "ble"
  [(set (pc) (if_then_else (le (cc0) (const_int 0))
     (label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ gen_conditional_branch(operands, LE); DONE; }")

(define_expand "bge"
  [(set (pc) (if_then_else (ge (cc0) (const_int 0))
     (label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ gen_conditional_branch(operands, GE); DONE; }")

(define_expand "bltu"
  [(set (pc) (if_then_else (ltu (cc0) (const_int 0))
     (label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ gen_conditional_branch(operands, LTU); DONE; }")

(define_expand "bgtu"
  [(set (pc) (if_then_else (gtu (cc0) (const_int 0))
     (label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ gen_conditional_branch(operands, GTU); DONE; }")

(define_expand "bleu"
  [(set (pc) (if_then_else (leu (cc0) (const_int 0))
     (label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ gen_conditional_branch(operands, LEU); DONE; }")

(define_expand "bgeu"
  [(set (pc) (if_then_else (geu (cc0) (const_int 0))
     (label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ gen_conditional_branch(operands, GEU); DONE; }")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; call

(define_insn "call"
  [(call (match_operand:DI 0 "register_operand" "m")
         (match_operand:SI 1 "immediate_operand" "n"))]
  ""
  "lpe 8, r60\njmpa %0")

(define_insn "call_value"
  [(set (match_operand:DI 0 "" "=r")
	(call (match_operand:DI 1 "register_operand" "m")
              (match_operand:SI 2 "immediate_operand" "n")))]
  ""
  "lpe 8, r60\njmpa %1\nmov r59, %0")

(define_insn "return" [(return)]
  ""
  "jmpa r60" )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_insn "anddi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
        (and:DI (match_operand:DI 1 "register_operand" "%r")
                (match_operand:DI 2 "nonmemory_operand" "r")))]
  ""
  "and %1,%2,%0"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_insn "iordi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
        (ior:DI (match_operand:DI 1 "register_operand" "%r")
                (match_operand:DI 2 "nonmemory_operand" "r")))]
  ""
  "or %1,%2,%0"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_insn "xordi3"
  [(set (match_operand:DI 0 "register_operand" "=r")
        (xor:DI (match_operand:DI 1 "register_operand" "%r")
                (match_operand:DI 2 "nonmemory_operand" "r")))]
  ""
  "xor %1,%2,%0"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_insn "andsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
        (and:SI (match_operand:SI 1 "register_operand" "%r")
                (match_operand:SI 2 "nonmemory_operand" "r")))]
  ""
  "and.q %1,%2,%0"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
        (ior:SI (match_operand:SI 1 "register_operand" "%r")
                (match_operand:SI 2 "nonmemory_operand" "r")))]
  ""
  "or.q %1,%2,%0"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
        (xor:SI (match_operand:SI 1 "register_operand" "%r")
                (match_operand:SI 2 "nonmemory_operand" "r")))]
  ""
  "xor.q %1,%2,%0"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; miscellaneous
(define_insn "nop"
  [(const_int 0)]
  ""
  "nop")

(define_insn "blockage"
  [(unspec_volatile [(const_int 0)] 1)]
  ""
  ""
  [(set_attr "length" "0")])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; jumping
(define_insn "indirect_jump"
  [(set (pc) (match_operand:DI 0 "register_operand" "r"))]
  ""
  "jmpa %0")

(define_insn "jump"
  [(set (pc) (match_operand:DI 0 "general_operand" "r,i"))]
  ""
  "@
   jmpr %0
   jmpri %0")

(define_insn "jumpl"
  [(set (pc) (label_ref (match_operand 0 "" "")))]
  ""
  "jmpi %l0")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define_insn "int_cond_branch"
  [(set (pc) (if_then_else (eq:DI (const_int 0)
                   (match_operand:DI 0 "register_operand" "r"))
             (label_ref (match_operand 1 "" "")) (pc)))]
  ""
  "cjmpi %0,%1"
  [(set_attr "type" "branch")
   (set_attr "mode" "DI")])

(define_insn "int_cond_branch_rev"
  [(set (pc) (if_then_else (ne:DI (const_int 0)
                   (match_operand:DI 0 "register_operand" "r"))
                   (label_ref (match_operand 1 "" "")) (pc)))]
  ""
  "ncjmpi %0,%1"
  [(set_attr "type" "branch")
   (set_attr "mode" "DI")])
