/* Definitions of target machine for GNU compiler, for F-CPU.
   Copyright (C) 1999 FCPU Project
   Contributed by Brossard Mathias (f95mabr@dd.chalmers.se)

   This file is part of GNU CC.
   
   GNU CC is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   GNU CC is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


/* Write out the correct language type definition for the header files.  
   Unless we have assembler language, write out the symbols for C.  */
/*
#define CPP_SPEC "\
%{!undef:\
%{.S:-D__LANGUAGE_ASSEMBLY__ -D__LANGUAGE_ASSEMBLY %{!ansi:-DLANGUAGE_ASSEMBLY }}\
%{.cc|.cxx|.C:-D__LANGUAGE_C_PLUS_PLUS__ -D__LANGUAGE_C_PLUS_PLUS -D__cplusplus }\
%{.m:-D__LANGUAGE_OBJECTIVE_C__ -D__LANGUAGE_OBJECTIVE_C }\
%{!.S:%{!.cc:%{!.cxx:%{!.C:%{!.m:-D__LANGUAGE_C__ -D__LANGUAGE_C %{!ansi:-DLANGUAGE_C }}}}}}\
%{mieee:-D_IEEE_FP }\
%{mieee-with-inexact:-D_IEEE_FP -D_IEEE_FP_INEXACT }}\
%(cpp_cpu) %(cpp_subtarget)"
*/


#ifndef CPP_SUBTARGET_SPEC
#define CPP_SUBTARGET_SPEC ""
#endif
/*
#define SIGNED_CHAR_SPEC "%{funsigned-char:-D__CHAR_UNSIGNED__}"

#define WORD_SWITCH_TAKES_ARG(STR)		\
 (!strcmp (STR, "rpath") || !strcmp (STR, "include")	\
  || !strcmp (STR, "imacros") || !strcmp (STR, "aux-info") \
  || !strcmp (STR, "idirafter") || !strcmp (STR, "iprefix") \
  || !strcmp (STR, "iwithprefix") || !strcmp (STR, "iwithprefixbefore") \
  || !strcmp (STR, "isystem"))

*/

#define TARGET_VERSION printf("F-CPU compiler 0.1 alpha version\n");


enum processor_type  {PROCESSOR_F0};  /* F0 */

extern enum processor_type f_cpu;

enum fcpu_trap_precision
{
  FCPU_TP_PROG, 	/* No precision (default).  */
  FCPU_TP_FUNC,      	/* Trap contained within originating function.  */
  FCP_TP_INSN		/* Instruction accuracy and code is resumption safe. */
};

enum fcpu_fp_rounding_mode
{
  FCPU_FPRM_NORM,	/* Normal rounding mode.  */
  FCPU_FPRM_MINF,	/* Round towards minus-infinity.  */
  FCPU_FPRM_PLSF,	/* Round towards plus-infinity.  */
  FCPU_FPRM_CHOP,	/* Chopped rounding mode (towards 0). */
  FCPU_FPRM_DYN	        /* Dynamic rounding mode.  */
};

enum fcpu_fp_trap_mode
{
  FCPU_FPTM_N,		/* Normal trap mode. */
  FCPU_FPTM_U,		/* Underflow traps enabled.  */
  FCPU_FPTM_SU, 	/* Software completion, w/underflow traps */
  FCPU_FPTM_SUI	        /* Software completion, w/underflow & inexact traps */
};

extern int target_flags;

extern enum fcpu_trap_precision fcpu_tp;
extern enum fcpu_fp_rounding_mode fcpu_fprm;
extern enum fcpu_fp_trap_mode fcpu_fptm;

/* This means that floating-point support exists in the target implementation
   of the fcpu architecture.  This is usually the default.  */
#define MASK_FP		(1 << 0)
#define TARGET_FP	(target_flags & MASK_FP)

/* This means that gas is used to process the assembler file.  */

#define MASK_GAS	(1 << 2)
#define TARGET_GAS	(target_flags & MASK_GAS)

/* This means that we should mark procedures as IEEE conformant. */

#define MASK_IEEE_CONFORMANT (1 << 3)
#define TARGET_IEEE_CONFORMANT	(target_flags & MASK_IEEE_CONFORMANT)

/* This means we should be IEEE-compliant except for inexact.  */

#define MASK_IEEE	(1 << 4)
#define TARGET_IEEE	(target_flags & MASK_IEEE)

/* This means we should be fully IEEE-compliant.  */

#define MASK_IEEE_WITH_INEXACT (1 << 5)
#define TARGET_IEEE_WITH_INEXACT (target_flags & MASK_IEEE_WITH_INEXACT)

/* This means we must construct all constants rather than emitting
   them as literal data.  */

#define MASK_BUILD_CONSTANTS (1 << 6)
#define TARGET_BUILD_CONSTANTS (target_flags & MASK_BUILD_CONSTANTS)


#define TARGET_DEFAULT MASK_FP

#ifndef TARGET_CPU_DEFAULT
#define TARGET_CPU_DEFAULT 0
#endif

#define TARGET_SWITCHES							\
  { {"fcpu-as", -MASK_GAS, "Do not assume GAS"},			\
    {"gas", MASK_GAS, "Assume GAS"},                                    \
    {"", TARGET_DEFAULT | TARGET_CPU_DEFAULT, ""} }

/*
  { {"no-soft-float", MASK_FP, "Use hardware fp"},			\
    {"soft-float", - MASK_FP, "Do not use hardware fp"},		\
    {"fcpu-as", -MASK_GAS, "Do not assume GAS"},			\
    {"gas", MASK_GAS, "Assume GAS"},					\
    {"ieee-conformant", MASK_IEEE_CONFORMANT,				\
     "Request IEEE-conformant math library routines"},  		\
    {"ieee", MASK_IEEE|MASK_IEEE_CONFORMANT,				\
     "Emit IEEE-conformant code, without inexact exceptions"},		\
    {"ieee-with-inexact", MASK_IEEE_WITH_INEXACT|MASK_IEEE_CONFORMANT,	\
     "Emit IEEE-conformant code, with inexact exceptions"},		\
    {"build-constants", MASK_BUILD_CONSTANTS,				\
     "Do not emit complex integer constants to read-only memory"},	\
     }
*/


/* This macro is similar to `TARGET_SWITCHES' but defines names of
   command options that have values.  Its definition is an initializer
   with a subgrouping for each command option.

   Each subgrouping contains a string constant, that defines the fixed
   part of the option name, and the address of a variable.  The
   variable, type `char *', is set to the variable part of the given
   option if the fixed part matches.  The actual option name is made
   by appending `-m' to the specified name.

   Here is an example which defines `-mshort-data-NUMBER'.  If the
   given option is `-mshort-data-512', the variable `m88k_short_data'
   will be set to the string `"512"'.

	extern char *m88k_short_data;
	#define TARGET_OPTIONS { { "short-data-", &m88k_short_data } }  */

extern const char *fcpu_cpu_string;	/* For -mcpu= */
extern const char *fcpu_fprm_string;	/* For -mfp-rounding-mode=[n|m|p|c|d] */
extern const char *fcpu_fptm_string;	/* For -mfp-trap-mode=[n|u|su|sui]  */
extern const char *fcpu_tp_string;	/* For -mtrap-precision=[p|f|i] */

/*
#define TARGET_OPTIONS					\
{							\
  {"cpu=",		&fcpu_cpu_string,		\
   "Generate code for a given CPU"},			\
  {"fp-rounding-mode=",	&fcpu_fprm_string,		\
   "Control the generated fp rounding mode"},		\
  {"fp-trap-mode=",	&fcpu_fptm_string,		\
   "Control the IEEE trap mode"},			\
  {"trap-precision=",	&fcpu_tp_string,		\
   "Control the precision given to fp exceptions"},	\
}
*/

/*
#ifndef CPP_CPU_SPEC
#define CPP_CPU_SPEC "\
%{!undef:-D__fcpu -D__fcpu__ \
%{mcpu=fcpu0|mcpu=f0:%(cpp_cpu_fcpu) }
%{!mcpu*:%(cpp_cpu_default) }}"
#endif

#ifndef SUBTARGET_EXTRA_SPECS
#define SUBTARGET_EXTRA_SPECS
#endif

#define CPP_CPU_F0_SPEC "-D__fcpu_f0__ -Acpu(f0)"

#define CPP_CPU_DEFAULT_SPEC CPP_CPU_F0_SPEC

#define EXTRA_SPECS				\
  { "cpp_cpu_default", CPP_CPU_DEFAULT_SPEC },	\
  { "cpp_cpu", CPP_CPU_SPEC },			\
  { "cpp_subtarget", CPP_SUBTARGET_SPEC },	\
  SUBTARGET_EXTRA_SPECS
*/

/* Sometimes certain combinations of command options do not make sense
   on a particular target machine.  You can define a macro
   `OVERRIDE_OPTIONS' to take account of this.  This macro, if
   defined, is executed once just after all the command options have
   been parsed. */

extern void override_options ();
#define OVERRIDE_OPTIONS override_options ()

/* Define this macro to change register usage conditional on target flags.*/
#define CONDITIONAL_REGISTER_USAGE

/* Show we can debug even without a frame pointer.  */
#define CAN_DEBUG_WITHOUT_FP

/* target machine storage layout */

/* Define to enable software floating point emulation. */
#define REAL_ARITHMETIC

#define FLOAT_VALUE_TYPE	double
#define INTIFY(FLOATVAL)	(FLOATVAL)
#define FLOATIFY(INTVAL)	(INTVAL)
#define FLOAT_ARG_TYPE		double


/* Define the size of `int'.  The default is the same as the word size.  */
#define INT_TYPE_SIZE 32

/* Define the size of `long long'.  The default is the twice the word size.  */
#define LONG_LONG_TYPE_SIZE 64

/* The two floating-point formats we support are S-floating, which is
   4 bytes, and T-floating, which is 8 bytes.  `float' is S and `double'
   and `long double' are T.  */

#define FLOAT_TYPE_SIZE 32
#define DOUBLE_TYPE_SIZE 64
#define LONG_DOUBLE_TYPE_SIZE 64

#define	WCHAR_TYPE "unsigned int"
#define	WCHAR_TYPE_SIZE 32


/* Define this macro if it is advisable to hold scalars in registers
   in a wider mode than that declared by the program.  In such cases, 
   the value is constrained to be within the bounds of the declared
   type, but kept valid in the wider mode.  The signedness of the
   extension may differ from that of the type. */

#define PROMOTE_MODE(MODE,UNSIGNEDP,TYPE)  \
  if (GET_MODE_CLASS (MODE) == MODE_INT		\
      && GET_MODE_SIZE (MODE) < UNITS_PER_WORD)	\
    {						\
      if ((MODE) == SImode)			\
	(UNSIGNEDP) = 0;			\
      (MODE) = DImode;				\
    }

/* Define this if function arguments should also be promoted using the above
   procedure.  */

#define PROMOTE_FUNCTION_ARGS

/* Likewise, if the function return value is promoted.  */

#define PROMOTE_FUNCTION_RETURN

/* Define this if most significant bit is lowest numbered
   in instructions that operate on numbered bit-fields. */
#define BITS_BIG_ENDIAN 0

/* Define this if most significant byte of a word is the lowest numbered.
   This is false on the Alpha.  */
#define BYTES_BIG_ENDIAN 0

/* Define this if most significant word of a multiword number is lowest
   numbered. */
#define WORDS_BIG_ENDIAN 0

/* number of bits in an addressable storage unit */
#define BITS_PER_UNIT 8

/* Width in bits of a "word", which is the contents of a machine register.
   Note that this is not necessarily the width of data type `int';
   if using 16-bit ints on a 68000, this would still be 32.
   But on a machine with 16-bit registers, this would be 16.  */
#define BITS_PER_WORD 64

/* Width of a word, in units (bytes).  */
#define UNITS_PER_WORD 8

/* Width in bits of a pointer.
   See also the macro `Pmode' defined below.  */
#define POINTER_SIZE 64

/* Allocation boundary (in *bits*) for storing arguments in argument list.  */
#define PARM_BOUNDARY 64

/* Boundary (in *bits*) on which stack pointer should be aligned.  */
#define STACK_BOUNDARY 64

/* Allocation boundary (in *bits*) for the code of a function.  */
#define FUNCTION_BOUNDARY 256

/* Alignment of field after `int : 0' in a structure.  */
#define EMPTY_FIELD_BOUNDARY 64

/* Every structure's size must be a multiple of this.  */
#define STRUCTURE_SIZE_BOUNDARY 8

/* A bitfield declared as `int' forces `int' alignment for the struct.  */
#define PCC_BITFIELD_TYPE_MATTERS 1

/* Align loop starts for optimal branching.  */

#define LOOP_ALIGN(LABEL) \
  (optimize > 0 && write_symbols != SDB_DEBUG ? 4 : 0)

/* This is how to align an instruction for optimal branching.*/

#define LABEL_ALIGN_AFTER_BARRIER(FILE)	\
  (optimize > 0 && write_symbols != SDB_DEBUG ? 4 : 0)

/* No data type wants to be aligned rounder than this.  */
#define BIGGEST_ALIGNMENT 64

/* For atomic access to objects, must have at least 32-bit alignment
   unless the machine has byte operations.  */
#define MINIMUM_ATOMIC_ALIGNMENT (8)

/* Set this non-zero if move instructions will actually fail to work
   when given unaligned data.

   Since we get an error message when we do one, call them invalid.  */

#define STRICT_ALIGNMENT 1

/* Set this non-zero if unaligned move instructions are extremely slow.

   On fcpu, they trap.  */

#define SLOW_UNALIGNED_ACCESS 1


/* Standard register usage.  */

/* Number of actual hardware registers.
   The hardware registers are assigned numbers for the compiler
   from 0 to just below FIRST_PSEUDO_REGISTER.
   All registers that the compiler knows about must be given numbers,
   even those that are not normally considered general registers.

   We define all 32 integer registers, even though $31 is always zero,
   and all 32 floating-point registers, even though $f31 is also
   always zero.  We do not bother defining the FP status register and
   there are no other registers. 

   Since $31 is always zero, we will use register number 31 as the
   argument pointer.  It will never appear in the generated code
   because we will always be eliminating it in favor of the stack
   pointer or hardware frame pointer.

   Likewise, we use $f31 for the frame pointer, which will always
   be eliminated in favor of the hardware frame pointer or the
   stack pointer.  */

#define FIRST_PSEUDO_REGISTER 64

/* 1 for registers that have pervasive standard uses
   and are not available for the register allocator.  */
#define FIXED_REGISTERS  \
 { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }

/* 1 for registers not available across function calls.
   These must include the FIXED_REGISTERS and also any
   registers that can be used without being saved.
   The latter must include the registers where values are returned
   and the register where structure-value addresses are passed.
   Aside from that, you can include as many other registers as you like.  */
#define CALL_USED_REGISTERS  \
 { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  \
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }

/* List the order in which to allocate registers.  Each register must be
   listed once, even those in FIXED_REGISTERS.

   We allocate in the following order:
   r1-r15		(nonsaved register)
   r16-r57              (saved registers)
   r58                  (arguments)
   r59                  (return value)
   r60			(return PC)
   r61			(frame pointer)
   r62			(global pointer)
   r63            	(stack pointer) */

#define REG_ALLOC_ORDER  { \
      1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, \
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, \
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, \
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, \
  60, 61, 62, 63, 0 }

/* Return number of consecutive hard regs needed starting at reg REGNO
   to hold something of mode MODE.
   This is ordinarily the length in words of a value of mode MODE
   but can be less for certain modes in special long registers.  */
#define HARD_REGNO_NREGS(REGNO, MODE)   \
  ((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD)

/* Value is 1 if hard register REGNO can hold a value of 
   machine-mode MODE. */
#define HARD_REGNO_MODE_OK(REGNO, MODE) (1)

/* A C expression that is nonzero if a value of mode
   MODE1 is accessible in mode MODE2 without copying. 
   Should be true all the time ??? */
#define MODES_TIEABLE_P(MODE1, MODE2) 1

/* duh... */
#define RETURN_VALUE_REGNUM 59

/* Register to use for pushing function arguments.  */
#define STACK_POINTER_REGNUM 63

/* Base register for access to local variables of the function.  */
#define HARD_FRAME_POINTER_REGNUM 62

/* Value should be nonzero if functions must have frame pointers.
   Zero means the frame pointer need not be set up (and parms
   may be accessed via the stack pointer) in functions that seem suitable.
   This is computed in `reload', in reload1.c.  */
#define FRAME_POINTER_REQUIRED 0

/* Base register for access to arguments of the function.  */
#define ARG_POINTER_REGNUM 58

/* Base register for access to local variables of function.  */
#define FRAME_POINTER_REGNUM 61

/* Register in which static-chain is passed to a function. */
#define STATIC_CHAIN_REGNUM 1

/* Register in which address to store a structure value
   arrives in the function. */
#define STRUCT_VALUE 0 

/* Define the classes of registers for register constraints in the
   machine description.  Also define ranges of constants.

   One of the classes must always be named ALL_REGS and include all hard regs.
   If there is more than one class, another class must be named NO_REGS
   and contain no registers.

   The name GENERAL_REGS must be the name of a class (or an alias for
   another name such as ALL_REGS).  This is the class of registers
   that is allowed by "g" or "r" in a register constraint.
   Also, registers outside this class are allocated only when
   instructions express preferences for them.

   The classes must be numbered in nondecreasing order; that is,
   a larger-numbered class must never be contained completely
   in a smaller-numbered class.

   For any two classes, it is very desirable that there be another
   class that represents their union.  */
   
enum reg_class { NO_REGS, GENERAL_REGS, ALL_REGS, LIM_REG_CLASSES };

#define N_REG_CLASSES (int) LIM_REG_CLASSES

/* Give names of register classes as strings for dump file.   */

#define REG_CLASS_NAMES				\
 {"NO_REGS", "GENERAL_REGS", "ALL_REGS" }

/* Define which registers fit in which classes.
   This is an initializer for a vector of HARD_REG_SET
   of length N_REG_CLASSES.  */

#define REG_CLASS_CONTENTS \
  { { 0, 0 }, { 0xffffffff, 0xffffffff }, { 0xffffffff, 0xffffffff } }

#define REGNO_REG_CLASS(REGNO) \
 ((REGNO) > 0 & (REGNO) < 64 ? GENERAL_REGS: NO_REGS)

/* The class value for index registers, and the one for base regs.  */
#define INDEX_REG_CLASS NO_REGS
#define BASE_REG_CLASS GENERAL_REGS

/* Get reg_class from a letter such as appears in the machine description.  */

#define REG_CLASS_FROM_LETTER(C)	\
 ((C) == 'r' ? GENERAL_REGS : NO_REGS)

#define CONST_OK_FOR_LETTER_P(VALUE, C)         (0)

#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C)  (0)

#define EXTRA_CONSTRAINT(OP, C)			(0)

#define PREFERRED_RELOAD_CLASS(X, CLASS)        (CLASS)

#define SECONDARY_INPUT_RELOAD_CLASS(CLASS,MODE,IN) (0)

#define SECONDARY_OUTPUT_RELOAD_CLASS(CLASS,MODE,OUT) (0)

#define SECONDARY_MEMORY_NEEDED(CLASS1,CLASS2,MODE) (0)

#define SECONDARY_MEMORY_NEEDED_MODE(MODE) (0)

#define CLASS_MAX_NREGS(CLASS, MODE) (1)

#define CLASS_CANNOT_CHANGE_SIZE 0

#define REGISTER_MOVE_COST(CLASS1, CLASS2) (1)

/* A C expressions returning the cost of moving data of MODE from a register to
   or from memory.*/
extern int fcpu_memory_latency;
#define MEMORY_MOVE_COST(MODE,CLASS,IN)  (2*fcpu_memory_latency)

/* Provide the cost of a branch.  Exact meaning under development.  */
#define BRANCH_COST 5

/* Adjust the cost of dependencies.  */

#define ADJUST_COST(INSN,LINK,DEP,COST) \
  (COST) = fcpu_adjust_cost (INSN, LINK, DEP, COST)

/* Stack layout; function entry, exit and calling.  */

/* Define this if pushing a word on the stack
   makes the stack pointer a smaller address.  */
#define STACK_GROWS_DOWNWARD

/* Define this if the nominal address of the stack frame
   is at the high-address end of the local variables;
   that is, each additional local variable allocated
   goes at a more negative offset in the frame.  */
/* #define FRAME_GROWS_DOWNWARD */

/* Offset within stack frame to start allocating local variables at.
   If FRAME_GROWS_DOWNWARD, this is the offset to the END of the
   first local allocated.  Otherwise, it is the offset to the BEGINNING
   of the first local allocated.  */

#define STARTING_FRAME_OFFSET 0

/* If we generate an insn to push BYTES bytes,
   this says how many the stack pointer really advances by.
   On Alpha, don't define this because there are no push insns.  */
/*  #define PUSH_ROUNDING(BYTES) */

/* Define this to be nonzero if stack checking is built into the ABI.  */
#define STACK_CHECK_BUILTIN 1

/* Define this if the maximum size of all the outgoing args is to be
   accumulated and pushed during the prologue.  The amount can be
   found in the variable current_function_outgoing_args_size.  */
#define ACCUMULATE_OUTGOING_ARGS

/* Offset of first parameter from the argument pointer register value.  */

#define FIRST_PARM_OFFSET(FNDECL) 0

/* Definitions for register eliminations.

   We have two registers that can be eliminated on the Alpha.  First, the
   frame pointer register can often be eliminated in favor of the stack
   pointer register.  Secondly, the argument pointer register can always be
   eliminated; it is replaced with either the stack or frame pointer. */

/* This is an array of structures.  Each structure initializes one pair
   of eliminable registers.  The "from" register number is given first,
   followed by "to".  Eliminations of the same "from" register are listed
   in order of preference.  */

#define ELIMINABLE_REGS				     \
{{ ARG_POINTER_REGNUM, STACK_POINTER_REGNUM},	     \
 { ARG_POINTER_REGNUM, HARD_FRAME_POINTER_REGNUM},   \
 { FRAME_POINTER_REGNUM, STACK_POINTER_REGNUM},	     \
 { FRAME_POINTER_REGNUM, HARD_FRAME_POINTER_REGNUM}}

/* Given FROM and TO register numbers, say whether this elimination is allowed.
   Frame pointer elimination is automatically handled.

   All eliminations are valid since the cases where FP can't be
   eliminated are already handled.  */

#define CAN_ELIMINATE(FROM, TO) 1


/* Round up to a multiple of 16 bytes.  */
#define ALPHA_ROUND(X) (((X) + 15) & ~ 15)

/* Define the offset between two registers, one to be eliminated, and the other
   its replacement, at the start of a routine.  */
#define INITIAL_ELIMINATION_OFFSET(FROM, TO, OFFSET)			\
{ if ((FROM) == FRAME_POINTER_REGNUM)					\
    (OFFSET) = (ALPHA_ROUND (current_function_outgoing_args_size)	\
		+ fcpu_sa_size ());					\
  else if ((FROM) == ARG_POINTER_REGNUM)				\
    (OFFSET) = (ALPHA_ROUND (current_function_outgoing_args_size)	\
		+ fcpu_sa_size ()					\
		+ (ALPHA_ROUND (get_frame_size ()			\
			       + current_function_pretend_args_size)	\
		   - current_function_pretend_args_size));		\
}

/* Define this if stack space is still allocated for a parameter passed
   in a register.  */
/* #define REG_PARM_STACK_SPACE */

/* Value is the number of bytes of arguments automatically
   popped when returning from a subroutine call.
   FUNDECL is the declaration node of the function (as a tree),
   FUNTYPE is the data type of the function (as a tree),
   or for a library call it is an identifier node for the subroutine name.
   SIZE is the number of bytes of arguments passed on the stack.  */

#define RETURN_POPS_ARGS(FUNDECL,FUNTYPE,SIZE) 0


/* Define how to find the value returned by a function.
   VALTYPE is the data type of the value (as a tree).
   If the precise function being called is known, FUNC is its FUNCTION_DECL;
   otherwise, FUNC is 0.*/
#define FUNCTION_VALUE(VALTYPE, FUNC) gen_rtx_REG ( \
   ((INTEGRAL_TYPE_P (VALTYPE) && TYPE_PRECISION (VALTYPE) < BITS_PER_WORD) \
       || POINTER_TYPE_P (VALTYPE)) ? word_mode : TYPE_MODE (VALTYPE), \
       RETURN_VALUE_REGNUM )

/* Define how to find the value returned by a library function
   assuming the value has mode MODE.  */
#define LIBCALL_VALUE(MODE) gen_rtx_REG ( MODE, RETURN_VALUE_REGNUM ) 

/* The definition of this macro implies that there are cases where
   a scalar value cannot be returned in registers.

   For the fcpu, any structure or union type is returned in memory, as
   are integers whose size is larger than 64 bits.  */

#define RETURN_IN_MEMORY(TYPE) \
  (TYPE_MODE (TYPE) == BLKmode \
   || (TREE_CODE (TYPE) == INTEGER_TYPE && TYPE_PRECISION (TYPE) > 64))

/* 1 if N is a possible register number for a function value
   as seen by the caller.  */

#define FUNCTION_VALUE_REGNO_P(N)  \
  ((N) == RETURN_VALUE_REGNUM)

#define FUNCTION_ARG_REGNO_P(N) \
  (((N) >= 1 && (N) <= 15))

/* Define a data type for recording info about an argument list
   during the scan of that argument list.  This data type should
   hold all necessary information about the function itself
   and about the args processed so far, enough to enable macros
   such as FUNCTION_ARG to determine where the next arg should go.

   On fcpu, this is a single integer, which is a number of words
   of arguments scanned so far.
   Thus 15 or more means all following args should go on the stack.  */

#define ARGUMENT_REGISTER_START 1
#define ARGUMENT_REGISTER_COUNT 15

#define ARGUMENT_REG_START 1
#define ARGUMENT_REG_COUNT 15

#define ARG_REG_START 1
#define ARG_REG_COUNT 15


#define CUMULATIVE_ARGS int

/* Initialize a variable CUM of type CUMULATIVE_ARGS
   for a call to a function whose data type is FNTYPE.
   For a library call, FNTYPE is 0.  */

#define INIT_CUMULATIVE_ARGS(CUM,FNTYPE,LIBNAME,INDIRECT)  (CUM) = 0

/* Define intermediate macro to compute the size (in registers) of an argument
   for the fpcu */
#define FCPU_ARG_SIZE(MODE, TYPE, NAMED)				\
((MODE) != BLKmode							\
 ? (GET_MODE_SIZE (MODE) + (UNITS_PER_WORD - 1)) / UNITS_PER_WORD 	\
 : (int_size_in_bytes (TYPE) + (UNITS_PER_WORD - 1)) / UNITS_PER_WORD)

/* Update the data in CUM to advance over an argument
   of mode MODE and data type TYPE.
   (TYPE is null for libcalls where that information may not be available.)  */

#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED)			\
  if (MUST_PASS_IN_STACK (MODE, TYPE))					\
    (CUM) = ARGUMENT_REGISTER_COUNT;								\
  else									\
    (CUM) += FCPU_ARG_SIZE (MODE, TYPE, NAMED)

/* Determine where to put an argument to a function.
   Value is zero to push the argument on the stack,
   or a hard register in which to store the argument.

   MODE is the argument's machine mode.
   TYPE is the data type of the argument (as a tree).
    This is null for libcalls where that information may
    not be available.
   CUM is a variable of type CUMULATIVE_ARGS which gives info about
    the preceding args and about the function being called.
   NAMED is nonzero if this argument is a named parameter
    (otherwise it is an extra parameter matching an ellipsis).

   On fcpu the first 6 words of args are normally in registers
   and the rest are pushed.  */

#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED)	\
(((CUM) < ARGUMENT_REGISTER_COUNT) &&  ! MUST_PASS_IN_STACK (MODE, TYPE) \
  ? gen_rtx(REG, (MODE), (CUM) + ARGUMENT_REGISTER_START ) : 0)

/* Specify the padding direction of arguments.

   On the fcpu, we must pad upwards in order to be able to pass args in
   registers.  */

#define FUNCTION_ARG_PADDING(MODE, TYPE)	upward

/* For an arg passed partly in registers and partly in memory,
   this is the number of registers used.
   For args passed entirely in registers or entirely in memory, zero.  */

#define FUNCTION_ARG_PARTIAL_NREGS(CUM, MODE, TYPE, NAMED)	\
((CUM) < ARGUMENT_REGISTER_COUNT && ARGUMENT_REGISTER_COUNT < (CUM) \
  + FCPU_ARG_SIZE (MODE, TYPE, NAMED) ? ARGUMENT_REGISTER_COUNT - (CUM) : 0)

/* Perform any needed actions needed for a function that is receiving a
   variable number of arguments. 

   CUM is as above.

   MODE and TYPE are the mode and type of the current parameter.

   PRETEND_SIZE is a variable that should be set to the amount of stack
   that must be pushed by the prolog to pretend that our caller pushed
   it.

   Normally, this macro will push all remaining incoming registers on the
   stack and set PRETEND_SIZE to the length of the registers pushed. 

   On the Alpha, we allocate space for all 12 arg registers, but only
   push those that are remaining.

   However, if NO registers need to be saved, don't allocate any space.
   This is not only because we won't need the space, but because AP includes
   the current_pretend_args_size and we don't want to mess up any
   ap-relative addresses already made.

   If we are not to use the floating-point registers, save the integer
   registers where we would put the floating-point registers.  This is
   not the most efficient way to implement varargs with just one register
   class, but it isn't worth doing anything more efficient in this rare
   case.  */
   

#define SETUP_INCOMING_VARARGS(CUM,MODE,TYPE,PRETEND_SIZE,NO_RTL)	\
{ if ((CUM) < ARG_REG_COUNT)						\
    {									\
      if (! (NO_RTL))							\
	{								\
	  move_block_from_reg						\
	    (ARG_REG_START + CUM,					\
	     gen_rtx (MEM, BLKmode,					\
		      plus_constant (virtual_incoming_args_rtx,		\
				    ((CUM) + ARG_REG_COUNT)* UNITS_PER_WORD)),	\
	     ARG_REG_COUNT - (CUM), (ARG_REG_COUNT - (CUM)) * UNITS_PER_WORD);  \
	  move_block_from_reg						\
	    (ARG_REG_START  + CUM,	                            	\
	     gen_rtx (MEM, BLKmode,					\
		      plus_constant (virtual_incoming_args_rtx,		\
				     (CUM) * UNITS_PER_WORD)),		\
	     ARG_REG_COUNT - (CUM), (ARG_REG_COUNT - (CUM)) * UNITS_PER_WORD);	 \
	   emit_insn (gen_blockage ());					\
	 }								\
      PRETEND_SIZE = 2 * ARG_REG_COUNT  * UNITS_PER_WORD;		\
    }									\
}


/* Try to output insns to set TARGET equal to the constant C if it can be
   done in less than N insns.  Do all computations in MODE.  Returns the place
   where the output has been placed if it can be done and the insns have been
   emitted.  If it would take more than N insns, zero is returned and no
   insns and emitted.  */
extern struct rtx_def *fcpu_emit_set_const ();
extern struct rtx_def *fcpu_emit_set_long_const ();
extern struct rtx_def *fcpu_emit_conditional_branch ();
extern struct rtx_def *fcpu_emit_conditional_move ();


/* Generate necessary RTL for __builtin_saveregs().
   ARGLIST is the argument list; see expr.c.  */
extern struct rtx_def *fcpu_builtin_saveregs ();
#define EXPAND_BUILTIN_SAVEREGS(ARGLIST) fcpu_builtin_saveregs (ARGLIST)

/* Define the information needed to generate branch and scc insns.  This is
   stored from the compare operation.  Note that we can't use "rtx" here
   since it hasn't been defined!  */

extern struct rtx_def *fcpu_compare_op0, *fcpu_compare_op1;
extern int fcpu_compare_fp_p;

/* Define the information needed to modify the epilogue for EH.  */

extern struct rtx_def *fcpu_eh_epilogue_sp_ofs;

/* Make (or fake) .linkage entry for function call.
   IS_LOCAL is 0 if name is used in call, 1 if name is used in definition.  */
extern void fcpu_need_linkage ();

/* This macro defines the start of an assembly comment.  */

#define ASM_COMMENT_START " #"

/* This macro produces the initial definition of a function.  */

#define ASM_DECLARE_FUNCTION_NAME(FILE,NAME,DECL) \
  fcpu_start_function(FILE,NAME,DECL);
extern void fcpu_start_function ();

/* This macro closes up a function definition for the assembler.  */

#define ASM_DECLARE_FUNCTION_SIZE(FILE,NAME,DECL) \
  fcpu_end_function(FILE,NAME,DECL)
extern void fcpu_end_function ();
   
/* This macro notes the end of the prologue.  */

#define FUNCTION_END_PROLOGUE(FILE)  output_end_prologue (FILE)
extern void output_end_prologue ();

/* Output any profiling code before the prologue.  */

#define PROFILE_BEFORE_PROLOGUE 1

/* Output assembler code to FILE to increment profiler label # LABELNO
   for profiling a function entry.  Under OSF/1, profiling is enabled
   by simply passing -pg to the assembler and linker.  */

#define FUNCTION_PROFILER(FILE, LABELNO)

#define FUNCTION_BLOCK_PROFILER(FILE, LABELNO)			\
    do {							\
    } while (0);

/* Output assembler code to FILE to increment the entry-count for
   the BLOCKNO'th basic block in this source file.  */

#define BLOCK_PROFILER(FILE, BLOCKNO)				\
    do {							\
    } while (0)

/* EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
   the stack pointer does not matter.  The value is tested only in
   functions that have frame pointers.
   No definition is equivalent to always zero.  */

#define EXIT_IGNORE_STACK 1

/* Output assembler code for a block containing the constant parts
   of a trampoline, leaving space for the variable parts. */

#define TRAMPOLINE_TEMPLATE(FILE)		\
do {						\
} while (0)

/* Section in which to place the trampoline.  On Fcpu, instructions
   may only be placed in a text segment.  */

#define TRAMPOLINE_SECTION text_section

/* Length in units of the trampoline for entering a nested function.  */

#define TRAMPOLINE_SIZE    32

/* Emit RTL insns to initialize the variable parts of a trampoline.
   FNADDR is an RTX for the address of the function's pure code.
   CXT is an RTX for the static chain value for the function.  */

#define INITIALIZE_TRAMPOLINE(TRAMP, FNADDR, CXT) \
  fcpu_initialize_trampoline (TRAMP, FNADDR, CXT, 16, 24, 8)
extern void fcpu_initialize_trampoline ();

/* A C expression whose value is RTL representing the value of the return
   address for the frame COUNT steps up from the current frame.
   FRAMEADDR is the frame pointer of the COUNT frame, or the frame pointer of
   the COUNT-1 frame if RETURN_ADDR_IN_PREVIOUS_FRAME is defined.  */

#define RETURN_ADDR_RTX  fcpu_return_addr
extern struct rtx_def *fcpu_return_addr ();

/* Before the prologue, RA lives in r60. */
#define INCOMING_RETURN_ADDR_RTX  gen_rtx_REG (Pmode, 60) 

/* Initialize data used by insn expanders.  This is called from insn_emit,
   once for every function before code is generated.  */

#define INIT_EXPANDERS  fcpu_init_expanders ()
extern void fcpu_init_expanders ();

/* Addressing modes, and classification of registers for them.  */

/* #define HAVE_POST_INCREMENT 0 */
/* #define HAVE_POST_DECREMENT 0 */

/* #define HAVE_PRE_DECREMENT 0 */
/* #define HAVE_PRE_INCREMENT 0 */


/* Macros to check register numbers against specific register classes.  */

/* These assume that REGNO is a hard or pseudo reg number.
   They give nonzero only if REGNO is a hard reg of the suitable class
   or a pseudo reg currently allocated to a suitable hard reg.
   Since they use reg_renumber, they are safe only once reg_renumber
   has been allocated, which happens in local-alloc.c.  */

#define REGNO_OK_FOR_INDEX_P(REGNO) 0

#define REGNO_OK_FOR_BASE_P(REGNO) ((REGNO) < 64)

/* Maximum number of registers that can appear in a valid memory address.  */
#define MAX_REGS_PER_ADDRESS 1

/* Recognize any constant value that is a valid address.  For the Alpha,
   there are only constants none since we want to use LDA to load any
   symbolic addresses into registers.  */

#define CONSTANT_ADDRESS_P(X)  (0)

/* Include all constant integers and constant doubles, but not
   floating-point, except for floating-point zero.  */

#define LEGITIMATE_CONSTANT_P(X) (1)

/* End of gcc port day #1 */



/* Nonzero if X is a hard reg that can be used as an index.  */
#define REG_OK_FOR_INDEX_P(X) REGNO_OK_FOR_INDEX_P (REGNO (X))

/* Nonzero if X is a hard reg that can be used as a base reg.  */
#define REG_OK_FOR_BASE_P(X) REGNO_OK_FOR_BASE_P (REGNO (X))

#define REG_OK_FP_BASE_P(X) (0)

/* GO_IF_LEGITIMATE_ADDRESS recognizes an RTL expression
   that is a valid memory address for an instruction.
   The MODE argument is the machine mode for the MEM expression
   that wants to use this address. */

#define GO_IF_LEGITIMATE_ADDRESS(MODE, X, ADDR)			\
{									\
  rtx tmp = (X);							\
  if (REG_P (tmp) && REG_OK_FOR_BASE_P (tmp))				\
    goto ADDR;								\
}


/* Try machine-dependent ways of modifying an illegitimate address
   to be legitimate.  If we find one, return the new, valid address.
   This macro is used in only one place: `memory_address' in explow.c.

   OLDX is the address as it was before break_out_memory_refs was called.
   In some cases it is useful to look at this to decide what needs to be done.

   MODE and WIN are passed so that this macro can use
   GO_IF_LEGITIMATE_ADDRESS.

   It is always safe for this macro to do nothing.  It exists to recognize
   opportunities to optimize the output. */

#define LEGITIMIZE_ADDRESS(X,OLDX,MODE,WIN)

/* Try a machine-dependent way of reloading an illegitimate address
   operand.  If we find one, push the reload and jump to WIN.  This
   macro is used in only one place: `find_reloads_address' in reload.c.
*/
   
#define LEGITIMIZE_RELOAD_ADDRESS(X,MODE,OPNUM,TYPE,IND_LEVELS,WIN) 

/* Go to LABEL if ADDR (a legitimate address expression)
   has an effect that depends on the machine mode it is used for.
   On the Alpha this is true only for the unaligned modes.   We can
   simplify this test since we know that the address must be valid.  */

#define GO_IF_MODE_DEPENDENT_ADDRESS(ADDR,LABEL)  \
{ if (GET_CODE (ADDR) == AND) goto LABEL; }

/* Compute the cost of an address.  For the Alpha, all valid addresses are
   the same cost.  */

#define ADDRESS_COST(X)  0

/* Machine-dependent reorg pass.   */
#define MACHINE_DEPENDENT_REORG(X)	fcpu_reorg(X)

/* Specify the machine mode that this machine uses
   for the index in the tablejump instruction.  */
#define CASE_VECTOR_MODE SImode

/* Define as C expression which evaluates to nonzero if the tablejump
   instruction expects the table to contain offsets from the address of the
   table.*/
#define CASE_VECTOR_PC_RELATIVE 0

/* Specify the tree operation to be used to convert reals to integers.  */
#define IMPLICIT_FIX_EXPR FIX_ROUND_EXPR

/* This is the kind of divide that is easiest to do in the general case.  */
#define EASY_DIV_EXPR TRUNC_DIV_EXPR

/* Define this as 1 if `char' should by default be signed; else as 0.  */
#define DEFAULT_SIGNED_CHAR 1

/* This flag, if defined, says the same insns that convert to a signed fixnum
   also convert validly to an unsigned one.

   We actually lie a bit here as overflow conditions are different.  But
   they aren't being checked anyway.  */

#define FIXUNS_TRUNC_LIKE_FIX_TRUNC

/* Max number of bytes we can move to or from memory
   in one reasonably fast instruction.  */

#define MOVE_MAX 8

/* If a memory-to-memory move would take MOVE_RATIO or more simple
   move-instruction pairs, we will do a movstr or libcall instead.

   Without byte/word accesses, we want no more than four instructions;
   with, several single byte accesses are better.   */

#define MOVE_RATIO  (8)

/* Largest number of bytes of an object that can be placed in a register.
   On the Alpha we have plenty of registers, so use TImode.  */
#define MAX_FIXED_MODE_SIZE	GET_MODE_BITSIZE (TImode)

/* Nonzero if access to memory by bytes is no faster than for words.
   Also non-zero if doing byte operations (specifically shifts) in registers
   is undesirable. */
#define SLOW_BYTE_ACCESS	1

/* Define if operations between registers always perform the operation
   on the full register even if a narrower mode is specified.  */
#define WORD_REGISTER_OPERATIONS

/* Define if loading in MODE, an integral mode narrower than BITS_PER_WORD
   will either zero-extend or sign-extend.  The value of this macro should
   be the code that says which one of the two operations is implicitly
   done, NIL if none.  */
#define LOAD_EXTEND_OP(MODE) ((MODE) == SImode ? SIGN_EXTEND : ZERO_EXTEND)

/* Define if loading short immediate values into registers sign extends.  */
#define SHORT_IMMEDIATES_SIGN_EXTEND 1

/* Value is 1 if truncating an integer of INPREC bits to OUTPREC bits
   is done just by pretending it is already truncated.  */
#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC) 1

/* We assume that the store-condition-codes instructions store 0 for false
   and some other value for true.  This is the value stored for true.  */
#define STORE_FLAG_VALUE 1

/* Define the value returned by a floating-point comparison instruction.  */
#define FLOAT_STORE_FLAG_VALUE (2.0)

/* Canonicalize a comparison from one we don't have to one we do have.  */

#define CANONICALIZE_COMPARISON(CODE,OP0,OP1) \
  do {									\
  } while (0)

/* Specify the machine mode that pointers have.
   After generation of rtl, the compiler makes no further distinction
   between pointers and any other objects of this machine mode.  */
#define Pmode DImode

/* Mode of a function address in a call instruction (for indexing purposes). */
#define FUNCTION_MODE Pmode

/* Define this if addresses of constant functions
   shouldn't be put through pseudo regs where they can be cse'd.
   Desirable on machines where ordinary constants are expensive
   but a CALL with constant address is cheap.*/
#define NO_FUNCTION_CSE

/* Define this to be nonzero if shift instructions ignore all but the low-order
   few bits. */
#define SHIFT_COUNT_TRUNCATED 1

/* Use atexit for static constructors/destructors, instead of defining
   our own exit function.  */
#define HAVE_ATEXIT

/* The EV4 is dual issue; EV5/EV6 are quad issue.  */
#define ISSUE_RATE  (1)

/* Describe the fact that MULTI instructions are multiple instructions
   and so to assume they don't pair with anything.  */
#define MD_SCHED_VARIABLE_ISSUE(DUMP, SCHED_VERBOSE, INSN, CAN_ISSUE_MORE)

/* Compute the cost of computing a constant rtl expression RTX
   whose rtx-code is CODE.  The body of this macro is a portion
   of a switch statement.  If the code is computed here,
   return it with a return statement.  Otherwise, break from the switch.*/

#define CONST_COSTS(RTX,CODE,OUTER_CODE) \
  case CONST_INT:						\
    if (INTVAL (RTX) >= 0 && INTVAL (RTX) < (1<<16)) 		\
      return COSTS_N_INSNS (1);					\
  case CONST_DOUBLE:						\
    if ((RTX) == CONST0_RTX (GET_MODE (RTX)))			\
      return COSTS_N_INSNS (4);					\
  case CONST:							\
  case SYMBOL_REF:						\
  case LABEL_REF:						\
      return COSTS_N_INSNS (4);					


/* Provide the costs of a rtl expression.  This is in the body of a
   switch on CODE.  */
   
#define RTX_COSTS(X,CODE,OUTER_CODE)			\
  case PLUS:                                            \
  case MINUS:				                \
    if (FLOAT_MODE_P (GET_MODE (X)))			\
          return COSTS_N_INSNS (6);			\
    else  return COSTS_N_INSNS (2);                     \
  case MULT:						\
        if (FLOAT_MODE_P (GET_MODE (X)))		\
          return COSTS_N_INSNS (6);			\
        return COSTS_N_INSNS (6);			\
  case ASHIFT:                                          \
  case ASHIFTRT:                                        \
  case LSHIFTRT:			                \
        return COSTS_N_INSNS (2);			\
  case IF_THEN_ELSE:					\
        return COSTS_N_INSNS (2);			\
  case DIV:  case UDIV:  case MOD:  case UMOD:		\
        return COSTS_N_INSNS (64);			\
  case MEM:						\
        return COSTS_N_INSNS (2); 			\
  case NEG:						\
  case ABS:						\
  case FLOAT:						\
  case UNSIGNED_FLOAT:					\
  case FIX:     					\
  case UNSIGNED_FIX:					\
  case FLOAT_EXTEND:					\
  case FLOAT_TRUNCATE:					\
        return COSTS_N_INSNS (6);		

/* Control the assembler format that we output.  */

/* We don't emit these labels, so as to avoid getting linker errors about
   missing exception handling info.  If we emit a gcc_compiled. label into
   text, and the file has no code, then the DEC assembler gives us a zero
   sized text section with no associated exception handling info.  The
   DEC linker sees this text section, and gives a warning saying that
   the exception handling info is missing.  */
#define ASM_IDENTIFY_GCC(x)
#define ASM_IDENTIFY_LANGUAGE(x)

/* Output to assembler file text saying following lines
   may contain character constants, extra white space, comments, etc.  */

#define ASM_APP_ON ""

/* Output to assembler file text saying following lines
   no longer contain unusual constructs.  */

#define ASM_APP_OFF ""

#define TEXT_SECTION_ASM_OP ".text"

/* Output before read-only data.  */

#define READONLY_DATA_SECTION_ASM_OP ".rdata"

/* Output before writable data.  */

#define DATA_SECTION_ASM_OP ".data"

/* Define an extra section for read-only data, a routine to enter it, and
   indicate that it is for read-only data.*/
#define EXTRA_SECTIONS	readonly_data

#define EXTRA_SECTION_FUNCTIONS					\
void								\
literal_section ()						\
{								\
  if (in_section != readonly_data)				\
    {								\
      static int firsttime = 1;				        \
								\
      fprintf (asm_out_file, "%s\n", READONLY_DATA_SECTION_ASM_OP); \
      if (firsttime)						\
	{							\
	  firsttime = 0;				        \
	  ASM_OUTPUT_DOUBLE_INT (asm_out_file, const0_rtx);	\
	}							\
								\
      in_section = readonly_data;				\
    }								\
}								\

#define READONLY_DATA_SECTION	literal_section

/* If we are referencing a function that is static, make the SYMBOL_REF
   special.  We use this to see indicate we can branch to this function
   without setting PV or restoring GP.  */

#define ENCODE_SECTION_INFO(DECL)  \
  if (TREE_CODE (DECL) == FUNCTION_DECL && ! TREE_PUBLIC (DECL)) \
    SYMBOL_REF_FLAG (XEXP (DECL_RTL (DECL), 0)) = 1;

/* How to refer to registers in assembler output.
   This sequence is indexed by compiler's hard-register-number (see above).  */

#define REGISTER_NAMES { "r0",  "r1",  "r2",  "r3",  "r4",  "r5",  "r6",  "r7", "r8",  "r9",  "r10", "r11", "r12", "r13", "r14", "r15", "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", "r24", "r25", "r26", "r27", "r28", "r29", "r30", "r31", "r32", "r33", "r34", "r35", "r36", "r37", "r38", "r39", "r40", "r41", "r42", "r43", "r44", "r45", "r46", "r47", "r48", "r49", "r50", "r51", "r52", "r53", "r54", "r55", "r56", "r57", "r58", "r59", "r60", "r61", "r62", "r63" }

/* How to renumber registers for dbx and gdb.  */

#define DBX_REGISTER_NUMBER(REGNO) (REGNO)

/* This is how to output the definition of a user-level label named NAME,
   such as the label on a static function or variable NAME.  */

#define ASM_OUTPUT_LABEL(FILE,NAME)	\
  do { assemble_name (FILE, NAME); fputs (":\n", FILE); } while (0)

/* This is how to output a command to make the user-level label named NAME
   defined for reference from other files.  */

#define ASM_GLOBALIZE_LABEL(FILE,NAME)	\
  do { fputs ("\t.globl ", FILE); assemble_name (FILE, NAME); fputs ("\n", FILE);} while (0)

/* The prefix to add to user-visible assembler symbols. */

#define USER_LABEL_PREFIX ""

/* This is how to output an internal numbered label where
   PREFIX is the class of label and NUM is the number within the class.  */

#define ASM_OUTPUT_INTERNAL_LABEL(FILE,PREFIX,NUM)	\
  fprintf (FILE, "$%s%d:\n", PREFIX, NUM)

/* This is how to output a label for a jump table.  Arguments are the same as
   for ASM_OUTPUT_INTERNAL_LABEL, except the insn for the jump table is
   passed. */

#define ASM_OUTPUT_CASE_LABEL(FILE,PREFIX,NUM,TABLEINSN)	\
{ ASM_OUTPUT_ALIGN (FILE, 2); ASM_OUTPUT_INTERNAL_LABEL (FILE, PREFIX, NUM); }

/* This is how to store into the string LABEL
   the symbol_ref name of an internal numbered label where
   PREFIX is the class of label and NUM is the number within the class.
   This is suitable for output with `assemble_name'.  */

#define ASM_GENERATE_INTERNAL_LABEL(LABEL,PREFIX,NUM)	\
  sprintf ((LABEL), "*$%s%ld", (PREFIX), (long)(NUM))

/* Check a floating-point value for validity for a particular machine mode.  */

#define CHECK_FLOAT_VALUE(MODE, D, OVERFLOW) \
  ((OVERFLOW) = check_float_value (MODE, &D, OVERFLOW))


#define ASM_OUTPUT_DOUBLE(FILE,VALUE)					\
  {									\
    if (REAL_VALUE_ISINF (VALUE)					\
        || REAL_VALUE_ISNAN (VALUE)					\
	|| REAL_VALUE_MINUS_ZERO (VALUE))				\
      {									\
	long t[2];							\
	REAL_VALUE_TO_TARGET_DOUBLE ((VALUE), t);			\
	fprintf (FILE, "\t.quad 0x%lx%08lx\n",				\
		t[1] & 0xffffffff, t[0] & 0xffffffff);			\
      }									\
    else								\
      {									\
	char str[30];							\
	REAL_VALUE_TO_DECIMAL (VALUE, "%.20e", str);			\
	fprintf (FILE, "\t.floating %s\n", str);			\
      }									\
  }

/* This is how to output an assembler line defining a `float' constant.  */

#define ASM_OUTPUT_FLOAT(FILE,VALUE)				\
  do {								\
    long t;							\
    REAL_VALUE_TO_TARGET_SINGLE ((VALUE), t);			\
    fprintf (FILE, "\t.long 0x%lx\n", t & 0xffffffff);		\
} while (0)
  
/* This is how to output an assembler line defining an `int' constant.  */

#define ASM_OUTPUT_INT(FILE,VALUE)  		\
( fprintf (FILE, "\t.long "),			\
  output_addr_const (FILE, (VALUE)),		\
  fprintf (FILE, "\n"))

/* This is how to output an assembler line defining a `long' constant.  */

#define ASM_OUTPUT_DOUBLE_INT(FILE,VALUE)	\
( fprintf (FILE, "\t.quad "),			\
  output_addr_const (FILE, (VALUE)),		\
  fprintf (FILE, "\n"))

/* Likewise for `char' and `short' constants.  */

#define ASM_OUTPUT_SHORT(FILE,VALUE)  \
  fprintf (FILE, "\t.word %d\n",		\
    (int)(GET_CODE (VALUE) == CONST_INT		\
     ? INTVAL (VALUE) & 0xffff : (abort (), 0)))

#define ASM_OUTPUT_CHAR(FILE,VALUE)		\
  fprintf (FILE, "\t.byte %d\n",		\
    (int)(GET_CODE (VALUE) == CONST_INT		\
     ? INTVAL (VALUE) & 0xff : (abort (), 0)))

/* We use the default ASCII-output routine, except that we don't write more
   than 50 characters since the assembler doesn't support very long lines.  */

#define ASM_OUTPUT_ASCII(MYFILE, MYSTRING, MYLENGTH) \
  do {									      \
    FILE *_hide_asm_out_file = (MYFILE);				      \
    unsigned char *_hide_p = (unsigned char *) (MYSTRING);		      \
    int _hide_thissize = (MYLENGTH);					      \
    int _size_so_far = 0;						      \
    {									      \
      FILE *asm_out_file = _hide_asm_out_file;				      \
      unsigned char *p = _hide_p;					      \
      int thissize = _hide_thissize;					      \
      int i;								      \
      fprintf (asm_out_file, "\t.ascii \"");				      \
									      \
      for (i = 0; i < thissize; i++)					      \
	{								      \
	  register int c = p[i];					      \
									      \
	  if (_size_so_far ++ > 50 && i < thissize - 4)			      \
	    _size_so_far = 0, fprintf (asm_out_file, "\"\n\t.ascii \"");      \
									      \
	  if (c == '\"' || c == '\\')					      \
	    putc ('\\', asm_out_file);					      \
	  if (c >= ' ' && c < 0177)					      \
	    putc (c, asm_out_file);					      \
	  else								      \
	    {								      \
	      fprintf (asm_out_file, "\\%o", c);			      \
	      /* After an octal-escape, if a digit follows,		      \
		 terminate one string constant and start another.	      \
		 The Vax assembler fails to stop reading the escape	      \
		 after three digits, so this is the only way we		      \
		 can get it to parse the data properly.  */		      \
	      if (i < thissize - 1					      \
		  && p[i + 1] >= '0' && p[i + 1] <= '9')		      \
		_size_so_far = 0, fprintf (asm_out_file, "\"\n\t.ascii \"");  \
	  }								      \
	}								      \
      fprintf (asm_out_file, "\"\n");					      \
    }									      \
  }									      \
  while (0)

/* To get unaligned data, we have to turn off auto alignment.  */
#define UNALIGNED_SHORT_ASM_OP		".align 0\n\t.word"
#define UNALIGNED_INT_ASM_OP		".align 0\n\t.long"
#define UNALIGNED_DOUBLE_INT_ASM_OP	".align 0\n\t.quad"

/* This is how to output an insn to push a register on the stack.
   It need not be very fast code.  */

#define ASM_OUTPUT_REG_PUSH(FILE,REGNO)					\
 fprintf (FILE, "\tsubi r63, 8, r63\n\tstore r%d, [r63]\n", REGNO);	\

/* This is how to output an insn to pop a register from the stack.
   It need not be very fast code.  */
#define ASM_OUTPUT_REG_POP(FILE,REGNO)					\
  fprintf (FILE, "\tload [r63], r%d\n\taddi r63,8, r63\n", REGNO);      \

/* This is how to output an assembler line for a numeric constant byte.  */
#define ASM_OUTPUT_BYTE(FILE,VALUE)  \
  fprintf (FILE, "\t.byte 0x%x\n", (int) ((VALUE) & 0xff))

/* This is how to output an element of a case-vector that is absolute.
   (Alpha does not use such vectors, but we must define this macro anyway.)  */
#define ASM_OUTPUT_ADDR_VEC_ELT(FILE, VALUE) abort ()

/* This is how to output an element of a case-vector that is relative.  */
#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, BODY, VALUE, REL) \
  fprintf (FILE, "\t.%s $L%d\n", "long", (VALUE))

/* This is how to output an assembler line
   that says to advance the location counter
   to a multiple of 2**LOG bytes.  */

#define ASM_OUTPUT_ALIGN(FILE,LOG)	\
  if ((LOG) != 0)			\
    fprintf (FILE, "\t.align %d\n", LOG);



/* This is how to advance the location counter by SIZE bytes.  */

#define ASM_OUTPUT_SKIP(FILE,SIZE)  \
  fprintf (FILE, "\t.space %d\n", (SIZE))

/* This says how to output an assembler line
   to define a global common symbol.  */

#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED)  \
( fputs ("\t.comm ", (FILE)),			\
  assemble_name ((FILE), (NAME)),		\
  fprintf ((FILE), ",%d\n", (SIZE)))

/* This says how to output an assembler line
   to define a local common symbol.  */

#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE,ROUNDED)	\
( fputs ("\t.lcomm ", (FILE)),				\
  assemble_name ((FILE), (NAME)),			\
  fprintf ((FILE), ",%d\n", (SIZE)))

/* Store in OUTPUT a string (made with alloca) containing
   an assembler-name for a local static variable named NAME.
   LABELNO is an integer which is different for each call.  */

#define ASM_FORMAT_PRIVATE_NAME(OUTPUT, NAME, LABELNO)	\
( (OUTPUT) = (char *) alloca (strlen ((NAME)) + 10),	\
  sprintf ((OUTPUT), "%s.%d", (NAME), (LABELNO)))

/* Define the parentheses used to group arithmetic operations
   in assembler code.  */

#define ASM_OPEN_PAREN "("
#define ASM_CLOSE_PAREN ")"


/* Output code to add DELTA to the first argument, and then jump to FUNCTION.
   Used for C++ multiple inheritance.  */

#define ASM_OUTPUT_MI_THUNK(FILE, THUNK_FNDECL, DELTA, FUNCTION)	\
do {									\
  char *fn_name = XSTR (XEXP (DECL_RTL (FUNCTION), 0), 0);		\
  int reg;								\
									\
  /* Mark end of prologue.  */						\
  output_end_prologue (FILE);						\
									\
  /* Rely on the assembler to macro expand a large delta.  */		\
  reg = aggregate_value_p (TREE_TYPE (TREE_TYPE (FUNCTION))) ? 17 : 16;	\
  fprintf (FILE, "\tldcns r%d, %d\nload [r%d], r%d\n", reg,             \
           (long)(DELTA), reg, reg);	                                \
  fprintf (FILE, "\tjmpa ");			      		\
  assemble_name (FILE, fn_name);					\
  fputc ('\n', FILE);							\
} while (0)

/* Define results of standard character escape sequences.  */
#define TARGET_BELL 007
#define TARGET_BS 010
#define TARGET_TAB 011
#define TARGET_NEWLINE 012
#define TARGET_VT 013
#define TARGET_FF 014
#define TARGET_CR 015

/* Print operand X (an rtx) in assembler syntax to file FILE.
   CODE is a letter or dot (`z' in `%z0') or 0 if no letter was specified.
   For `%' followed by punctuation, CODE is the punctuation and X is null.  */

#define PRINT_OPERAND(FILE, X, CODE)  print_operand (FILE, X, CODE)

/* Determine which codes are valid without a following integer.  These must
   not be alphabetic (the characters are chosen so that
   PRINT_OPERAND_PUNCT_VALID_P translates into a simple range change when
   using ASCII).

   &	Generates fp-rounding mode suffix: nothing for normal, 'c' for
   	chopped, 'm' for minus-infinity, and 'd' for dynamic rounding
	mode.  alpha_fprm controls which suffix is generated.

   '	Generates trap-mode suffix for instructions that accept the
        su suffix only (cmpt et al).

   `    Generates trap-mode suffix for instructions that accept the
	v and sv suffix.  The only instruction that needs this is cvtql.

   (	Generates trap-mode suffix for instructions that accept the
	v, sv, and svi suffix.  The only instruction that needs this
	is cvttq.

   )    Generates trap-mode suffix for instructions that accept the
	u, su, and sui suffix.  This is the bulk of the IEEE floating
	point instructions (addt et al).

   +    Generates trap-mode suffix for instructions that accept the
	sui suffix (cvtqt and cvtqs).

   ,    Generates single precision suffix for floating point
	instructions (s for IEEE, f for VAX)

   -	Generates double precision suffix for floating point
	instructions (t for IEEE, g for VAX)
   */

#define PRINT_OPERAND_PUNCT_VALID_P(CODE)  (0)
/*  ((CODE) == '&' || (CODE) == '`' || (CODE) == '\'' || (CODE) == '('	\
    || (CODE) == ')' || (CODE) == '+' || (CODE) == ',' || (CODE) == '-')*/

/* Print a memory address as an operand to reference that memory location.  */

#define PRINT_OPERAND_ADDRESS(FILE, ADDR) \
  print_operand_address((FILE), (ADDR))

/* Define the codes that are matched by predicates in alpha.c.  */

#define PREDICATE_CODES 						\
  {"reg_or_0_operand", {SUBREG, REG, CONST_INT}},			\
  {"reg_or_6bit_operand", {SUBREG, REG, CONST_INT}},			\
  {"reg_or_8bit_operand", {SUBREG, REG, CONST_INT}},			\
  {"cint8_operand", {CONST_INT}},					\
  {"reg_or_cint_operand", {SUBREG, REG, CONST_INT}},			\
  {"add_operand", {SUBREG, REG, CONST_INT}},				\
  {"sext_add_operand", {SUBREG, REG, CONST_INT}},			\
  {"const48_operand", {CONST_INT}},					\
  {"and_operand", {SUBREG, REG, CONST_INT}},				\
  {"or_operand", {SUBREG, REG, CONST_INT}},				\
  {"mode_mask_operand", {CONST_INT}},					\
  {"mul8_operand", {CONST_INT}},					\
  {"mode_width_operand", {CONST_INT}},					\
  {"reg_or_fp0_operand", {SUBREG, REG, CONST_DOUBLE}},			\
  {"fcpu_comparison_operator", {EQ, LE, LT, LEU, LTU}},		\
  {"fcpu_swapped_comparison_operator", {EQ, GE, GT, GEU, GTU}},	\
  {"signed_comparison_operator", {EQ, NE, LE, LT, GE, GT}},		\
  {"divmod_operator", {DIV, MOD, UDIV, UMOD}},				\
  {"fp0_operand", {CONST_DOUBLE}},					\
  {"current_file_function_operand", {SYMBOL_REF}},			\
  {"call_operand", {REG, SYMBOL_REF}},					\
  {"input_operand", {SUBREG, REG, MEM, CONST_INT, CONST_DOUBLE,		\
		     SYMBOL_REF, CONST, LABEL_REF}},			\
  {"some_operand", {SUBREG, REG, MEM, CONST_INT, CONST_DOUBLE,		\
		    SYMBOL_REF, CONST, LABEL_REF}},			\
  {"aligned_memory_operand", {MEM}},					\
  {"unaligned_memory_operand", {MEM}},					\
  {"reg_or_unaligned_mem_operand", {SUBREG, REG, MEM}},			\
  {"any_memory_operand", {MEM}},					\
  {"hard_fp_register_operand", {SUBREG, REG}},				\
  {"reg_not_elim_operand", {SUBREG, REG}},				\
  {"reg_no_subreg_operand", {REG}},

/* Tell collect that the object format is ECOFF.  */
#define OBJECT_FORMAT_ELF

/* If we use NM, pass -g to it so it only lists globals.  */
#define NM_FLAGS "-pg"

#define DBX_DEBUGGING_INFO

#ifndef PREFERRED_DEBUGGING_TYPE	/* assume SDB_DEBUGGING_INFO */
#define PREFERRED_DEBUGGING_TYPE  DBX_DEBUG
#endif

/* Correct the offset of automatic variables and arguments.  Note that
   the Fcpu debug format wants all automatic variables and arguments
   to be in terms of two different offsets from the virtual frame pointer,
   which is the stack pointer before any adjustment in the function.
   The offset for the argument pointer is fixed for the native compiler,
   it is either zero (for the no arguments case) or large enough to hold
   all argument registers.
   The offset for the auto pointer is the fourth argument to the .frame
   directive (local_offset).
   To stay compatible with the native tools we use the same offsets
   from the virtual frame pointer and adjust the debugger arg/auto offsets
   accordingly. These debugger offsets are set up in output_prolog.  */

extern long fcpu_arg_offset;
extern long fcpu_auto_offset;
#define DEBUGGER_AUTO_OFFSET(X) \
  ((GET_CODE (X) == PLUS ? INTVAL (XEXP (X, 1)) : 0) + fcpu_auto_offset)
#define DEBUGGER_ARG_OFFSET(OFFSET, X) (OFFSET + fcpu_arg_offset)


#define ASM_OUTPUT_SOURCE_LINE(STREAM, LINE)				\
  fcpu_output_lineno (STREAM, LINE)
extern void fcpu_output_lineno ();

#define ASM_OUTPUT_SOURCE_FILENAME(STREAM, NAME)			\
  fcpu_output_filename (STREAM, NAME)
extern void fcpu_output_filename ();


/* mips-tfile.c limits us to strings of one page.  We must underestimate this
   number, because the real length runs past this up to the next
   continuation point.  This is really a dbxout.c bug.  */
#define DBX_CONTIN_LENGTH 3000

/* By default, turn on GDB extensions.  */
#define DEFAULT_GDB_EXTENSIONS 1

/*#define NO_DBX_FUNCTION_END 1*/

/* If we are smuggling stabs through the ALPHA ECOFF object
   format, put a comment in front of the .stab<x> operation so
   that the ALPHA assembler does not choke.  The mips-tfile program
   will correctly put the stab into the object file.  */

#define ASM_STABS_OP	((TARGET_GAS) ? ".stabs" : " #.stabs")
#define ASM_STABN_OP	((TARGET_GAS) ? ".stabn" : " #.stabn")
#define ASM_STABD_OP	((TARGET_GAS) ? ".stabd" : " #.stabd")

/* The linker will stick __main into the .init section.  */
#define HAS_INIT_SECTION
#define LD_INIT_SWITCH "-init"
#define LD_FINI_SWITCH "-fini"

/* The system headers under Alpha systems are generally C++-aware.  */
#define NO_IMPLICIT_EXTERN_C

/* Prototypes for fcpu.c functions used in the md file & elsewhere.  */
extern struct rtx_def *get_unaligned_address ();
extern void fcpu_write_verstamp ();
extern void fcpu_reorg ();
extern int check_float_value ();
extern int direct_return ();
extern int const48_operand ();
extern int add_operand ();
extern int and_operand ();
extern int unaligned_memory_operand ();
extern int zap_mask ();
extern int current_file_function_operand ();
extern int fcpu_sa_size ();
extern int fcpu_adjust_cost ();
extern void print_operand ();
extern void print_operand_address ();
extern int reg_or_0_operand ();
extern int reg_or_8bit_operand ();
extern int mul8_operand ();
extern int reg_or_6bit_operand ();
extern int fcpu_comparison_operator ();
extern int fcpu_swapped_comparison_operator ();
extern int sext_add_operand ();
extern int cint8_operand ();
extern int mode_mask_operand ();
extern int or_operand ();
extern int mode_width_operand ();
extern int reg_or_fp0_operand ();
extern int signed_comparison_operator ();
extern int fp0_operand ();
extern int some_operand ();
extern int input_operand ();
extern int divmod_operator ();
extern int call_operand ();
extern int reg_or_cint_operand ();
extern int hard_fp_register_operand ();
extern int reg_not_elim_operand ();
extern void fcpu_set_memflags ();
extern int aligned_memory_operand ();
extern void get_aligned_mem ();
extern void fcpu_expand_unaligned_load ();
extern void fcpu_expand_unaligned_store ();
extern int fcpu_expand_block_move ();
extern int fcpu_expand_block_clear ();
extern void fcpu_expand_prologue ();
extern void fcpu_expand_epilogue ();
extern int gen_conditional_branch();

extern struct rtx_def *fcpu_compare_op0, *fcpu_compare_op1;
extern int fcpu_compare_mode;















