-- ia8test.vhdl -- F-CPU 8-Bit Adder Testbench
-- Copyright (C) 2000 Michael Riepe <michael@s...>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: ia8test.vhdl,v 1.2 2000/10/22 12:15:34 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

use IEEE.numeric_std.all;
use std.textio.all;
use IEEE.std_logic_textio.all;

entity IAdd8_test is
end IAdd8_test;

architecture Arch_1 of IAdd8_test is
        constant WIDTH : natural := 8;
        signal A, B, Y : std_ulogic_vector(WIDTH-1 downto 0);
        signal Cin, Cout : std_ulogic;
begin
        mut : entity work.IAdd8
                generic map (WIDTH => WIDTH)
                port map (A => A, B => B, Cin => Cin, Y => Y, Cout => Cout);

        process
                variable res, prod : natural;
                variable lout : line;
        begin
                for i in 0 to 2**WIDTH-1 loop
                        A <= std_ulogic_vector(to_unsigned(i, A'length));
                        for j in 0 to 2**WIDTH-1 loop
                                B <= std_ulogic_vector(to_unsigned(j, B'length));
                                for k in 0 to 1 loop
                                        if k = 1 then
                                                Cin <= '1';
                                        else
                                                Cin <= '0';
                                        end if;
                                        wait for 1 ns;
                                        res := to_integer(unsigned(Cout & Y));
                                        prod := i + j + k;
                                        if (res /= prod) then
                                                write(lout, "WHOA THERE!!! ");
                                                write(lout, i);
                                                write(lout, " + ");
                                                write(lout, j);
                                                write(lout, " + ");
                                                write(lout, k);
                                                write(lout, " => ");
                                                write(lout, Cout & Y);
                                                write(lout, " /= ");
                                                write(lout, prod);
                                                writeline(output, lout);
                                        end if;
                                end loop;
                        end loop;
                end loop;
                wait;
        end process;
end Arch_1;
