-- t-imul7.vhdl - F-CPU 8x8-Bit Integer Multiplication Unit
-- Copyright (C) 2000 Michael Riepe <michael@s...>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: t-imul7.vhdl,v 1.2 2000/10/10 02:44:12 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;
use IEEE.std_logic_textio.all;

entity mul8xn_test is
end mul8xn_test;

architecture Arch_1 of mul8xn_test is
        signal A, B : std_ulogic_vector(7 downto 0);
        signal X, Y : std_ulogic_vector(15 downto 0);
        signal Smul : std_ulogic;
begin
        mut: entity work.Mul8xN
                generic map (BWIDTH => 8)
                port map (A => A, B => B, X => X, Smul => Smul, Y => Y);

        process
                variable i, j, k, prod, res : integer;
                variable lout : line;
        begin
                write(lout, "*******************************************");
                writeline(output, lout);
                write(lout, "Multiplier Testbench (C) 2000 Michael Riepe");
                writeline(output, lout);
                write(lout, "*******************************************");
                writeline(output, lout);
                write(lout, "Expect this to run for quite some time...");
                writeline(output, lout);
                write(lout, "Get some coffee now, or go dating your SO.");
                writeline(output, lout);
                writeline(output, lout);

                write(lout, "*** Testing 8-bit signed multiplication");
                writeline(output, lout);
                Smul <= '1';
                for i in -128 to 127 loop
                        A <= std_ulogic_vector(to_signed(i, A'length));
                        for j in -128 to 127 loop
                                B <= std_ulogic_vector(to_signed(j, B'length));
                                for k in -128 to 127 loop
                                        X <= std_ulogic_vector(to_signed(k, X'length));
                                        wait for 1 ns;
                                        res := to_integer(signed(Y));
                                        prod := i * j + k;
                                        if (res /= prod) then
                                                write(lout, "WHOA THERE!!! ");
                                                write(lout, i);
                                                write(lout, " * ");
                                                write(lout, j);
                                                write(lout, " + ");
                                                write(lout, k);
                                                write(lout, " => ");
                                                write(lout, Y);
                                                write(lout, " /= ");
                                                write(lout, prod);
                                                write(lout, " d = ");
                                                write(lout, res - prod);
                                                writeline(output, lout);
                                        end if;
                                end loop;
                        end loop;
                end loop;

                write(lout, "*** Testing 8-bit unsigned multiplication");
                writeline(output, lout);
                Smul <= '0';
                for i in 0 to 255 loop
                        A <= std_ulogic_vector(to_unsigned(i, A'length));
                        for j in 0 to 255 loop
                                B <= std_ulogic_vector(to_unsigned(j, B'length));
                                for k in 0 to 255 loop
                                        X <= std_ulogic_vector(to_unsigned(k, X'length));
                                        wait for 1 ns;
                                        res := to_integer(unsigned(Y));
                                        prod := i * j + k;
                                        if (res /= prod) then
                                                write(lout, "WHOA THERE!!! ");
                                                write(lout, i);
                                                write(lout, " * ");
                                                write(lout, j);
                                                write(lout, " + ");
                                                write(lout, k);
                                                write(lout, " => ");
                                                write(lout, Y);
                                                write(lout, " /= ");
                                                write(lout, prod);
                                                write(lout, " d = ");
                                                write(lout, res - prod);
                                                writeline(output, lout);
                                        end if;
                                end loop;
                        end loop;
                end loop;

                write(lout, "*** Testing 16-bit pass-through (unsigned)");
                writeline(output, lout);
                A <= (others => '0');
                B <= (others => '0');
                for k in 0 to 65535 loop
                        X <= std_ulogic_vector(to_unsigned(k, X'length));
                        wait for 1 ns;
                        res := to_integer(unsigned(Y));
                        if (res /= k) then
                                write(lout, "WHOA THERE!!! ");
                                write(lout, k);
                                write(lout, " => ");
                                write(lout, Y);
                                write(lout, " /= ");
                                write(lout, k);
                                write(lout, " d = ");
                                write(lout, res - k);
                                writeline(output, lout);
                        end if;
                end loop;

                write(lout, "*** Testing 16-bit pass-through (signed)");
                writeline(output, lout);
                Smul <= '1';
                for k in 0 to 65535 loop
                        X <= std_ulogic_vector(to_unsigned(k, X'length));
                        wait for 1 ns;
                        res := to_integer(unsigned(Y));
                        if (res /= k) then
                                write(lout, "WHOA THERE!!! ");
                                write(lout, k);
                                write(lout, " => ");
                                write(lout, Y);
                                write(lout, " /= ");
                                write(lout, k);
                                write(lout, " d = ");
                                write(lout, res - k);
                                writeline(output, lout);
                        end if;
                end loop;
                wait;
        end process;
end Arch_1;
