-----------------------------------------------------------
-- testbenching testbenches... YG
-----------------------------------------------------------

-- A simple 8*8 bit FIFO
entity my_fifo is 
  port (clk, reset : in bit;
        Din : in bit_vector(0 to 7);
        Dout : out bit_vector(0 to 7));
end my_fifo;

architecture arch of my_fifo is
  type fifo_array is array  (0 to 7) of bit_vector(0 to 7);
  signal ar :  fifo_array;
  shared variable cycle : integer:=0;

  -- my own conversion utility :
  function conv_bit_vector(i,j:integer) return bit_vector is
    variable v: bit_vector(j-1 downto 0):=(others=>'0');
    variable t:integer:=i;
  begin
    for k in 0 to j-1 loop
      if (t mod 2) = 1 then
        v(k) := '1';
        t:=t-1;
      end if;
      t:= t/2;
    end loop;
    return v;
  end;

begin

 process (CLK, reset)
 begin
   if reset='1' then
     for i in 7 downto 0 loop
       ar(i)<=conv_bit_vector(i,8);
     end loop;
   else
     if (CLK'event and CLK = '1') then
       for i in 7 downto 1 loop
         ar(i)<=ar(i-1);
       end loop;
       ar(0)<=Din;
     end if;
   end if;
 end process;

 Dout<=ar(7);

end arch;

library ieee;
use std.textio.all;
use ieee.std_logic_textio.all;

-- testbenching the fifo
entity testbench is 
end testbench;

use WORK.my_fifo;

architecture test1 of testbench is
  signal din,dout : bit_vector(0 to 7):=(others=>'0');
  signal reset,clk : bit:='0';
  shared variable cycle : natural :=1;

  procedure print is
    variable lout : line ;
  begin
    WRITE(lout,din);
    WRITE(lout," ");
    WRITE(lout,dout);
    WRITE(lout," ");
    WRITE(lout,clk);
    WRITE(lout," ");
    WRITE(lout,reset);
    WRITE(lout," ");
    WRITE(lout,cycle);
    WRITELINE(OUTPUT, lout);
  end;

begin

 -- Instantiate the tested circuit
 stuff: entity my_fifo
   port map(
     Din => din,
     Dout => dout,
     clk => clk,
     reset => reset
   );

 process
 begin
   print;
   reset<='1';
   wait for 10 ns;
   print;
   reset<='0';
   wait for 10 ns;
   print;

   for azerty in 0 to 10 loop
     clk<='1';
     wait for 10 ns;
     clk<='0';
     wait for 10 ns;
     cycle:=cycle+1;
     print;
   end loop;

   wait; -- stop the simulation
 end process;

end test1;
