#include <string.h>

#include "winutils.c"

/* X11 stuffs */

/* main window */
int main_xsize=600, main_ysize=600;
Window win_main;
Window button_quit; /*  10,10,45,17 */
Window button_init; /*  70,10,45,17 */
Window button_step; /* 125,10,45,17 */
Window button_mem;  /*  10,50,main_xsize-26, 50 */

Window button_LSU;
Window button_LSU_tags;
Window button_fetch_logic;
Window button_fetcher_tags;
Window button_fetcher;

Window button_TLB;
Window button_decoder;

Window button_scoreboard;
Window button_registers;
Window button_SR;

Window button_Xbar;

Window button_ROP2;
Window button_INC;
Window button_SHUFFLER;
Window button_ASU;
Window button_IMU;
Window button_IDU;

XSegment main_segments[30];

/* memory window */

int mem_xsize=400, mem_ysize=400;
Window win_mem;
Window button_hide_mem;
int hide_mem=HIDDEN;

/* Fetcher window */
int fetcher_xsize=400, fetcher_ysize=400;
Window win_fetcher;
Window button_hide_fetcher;
int hide_fetcher=HIDDEN;

/* Fetcher_tags window */

int fetcher_tags_xsize=500, fetcher_tags_ysize=500;
Window win_fetcher_tags;
Window button_hide_fetcher_tags;
int hide_fetcher_tags=HIDDEN;

/* LSU_tags window */

int LSU_tags_xsize=400, LSU_tags_ysize=400;
Window win_LSU_tags;
Window button_hide_LSU_tags;
int hide_LSU_tags=HIDDEN;

/* LSU window */

int LSU_xsize=400, LSU_ysize=400;
Window win_LSU;
Window button_hide_LSU;
int hide_LSU=HIDDEN;

/* TLB window */

int TLB_xsize=400, TLB_ysize=400;
Window win_TLB;
Window button_hide_TLB;
int hide_TLB=HIDDEN;

/* Xbar window */
int Xbar_xsize=400, Xbar_ysize=400;
Window win_Xbar;
Window button_hide_Xbar;
int hide_Xbar=HIDDEN;

/* decoder window */

int decoder_xsize=400, decoder_ysize=400;
Window win_decoder;
Window button_hide_decoder;
int hide_decoder=HIDDEN;

/* register window */

int register_xsize=400, register_ysize=400;
Window win_register;
Window button_hide_register;
int hide_register=HIDDEN;

/* scoreboard window */

int scoreboard_xsize=400, scoreboard_ysize=400;
Window win_scoreboard;
Window button_hide_scoreboard;
int hide_scoreboard=HIDDEN;

/*  window
int _xsize=400, _ysize=400;
Window win_;
Window button_hide_;
int hide_=HIDDEN;
*/

int resize_flag=-1;
int t1,t2,t3,i;

GC gc,gc1,gc2;
XEvent event;
KeySym keysym;
char car;

void main(int argc, char **argv)
{

  /* read the init file here, eventually remember the window positions.... */

  /* init the simulation here */

  /* X11 */
  init_X();

redisplay:

  if (resize_flag & 1L<<0) {
    if (main_xsize<350) {
      main_xsize=350;
    }
    if (main_ysize<350) {
      main_ysize=350;
    }
    open_window(&win_main,main_xsize, main_ysize,&gc,black,grey,"MAIN WINDOW",SHOWN);
    open_daughter_window (&button_quit, win_main,  10, 10, 45, 17, &gc, black,light_grey, 1);
    open_daughter_window (&button_init, win_main,  70, 10, 45, 17, &gc, black,light_grey, 1);
    open_daughter_window (&button_step, win_main, 125, 10, 45, 17, &gc, black,light_grey, 1);

    open_daughter_window (&button_mem,win_main,10,50,main_xsize-26,50,&gc2,black,grey55, 3);

    t1=((main_xsize-20)/9);
    t2=((main_ysize-150)/5);

    open_daughter_window (&button_LSU,         win_main,       10, 130, (t1*3)-4, t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_LSU_tags,    win_main,(t1*3)+10, 130, t1-4,   t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_fetch_logic, win_main,(t1*4)+10, 130, t1-4,   t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_fetcher_tags,win_main,(t1*5)+10, 130, t1-4,   t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_fetcher,     win_main,(t1*6)+10, 130, (t1*3)-4, t2-10, &gc, black, light_grey, 3);

    /* memory-LSU, memory-fetcher */
    main_segments[0].x1=main_segments[0].x2=(t1*3)>>1;
    main_segments[1].x1=main_segments[1].x2=(t1*15)>>1;
    main_segments[0].y1=main_segments[1].y1=100;
    main_segments[0].y2=main_segments[1].y2=130;

    /* fetcher -> tags + decoder */
    main_segments[6].y1=main_segments[7].y1=
    main_segments[2].y2=main_segments[3].y2=main_segments[4].y2=t2+120;
    main_segments[2].y1=main_segments[3].y1=main_segments[5].y1=main_segments[5].y2=t2+140;
    main_segments[6].y2=main_segments[7].y2=main_segments[4].y1=t2+160;
    main_segments[2].x1=main_segments[2].x2=main_segments[5].x1=(t1*7)>>1;
    main_segments[3].x1=main_segments[3].x2=(t1*11)>>1;
    main_segments[4].x1=main_segments[4].x2=main_segments[5].x2=(t1*15)>>1;
    /* TLB->tags */
    main_segments[6].x1=main_segments[6].x2=main_segments[5].x1+12;
    main_segments[7].x1=main_segments[7].x2=main_segments[3].x1+12;

    open_daughter_window (&button_TLB, win_main,
        (((main_xsize-20)*3)>>3)+10, t2+160,
          ((main_xsize-20)>>2), t2-20, &gc, black, light_grey, 3);
    open_daughter_window (&button_decoder, win_main,
         (t1*6)+30, t2+160, (t1*3)-30, t2-10, &gc, black, light_grey, 3);

    open_daughter_window (&button_scoreboard, win_main,
         (t1*6)+30, (t2*2)+160, (t1*3)-30, t2-30, &gc, black, light_grey, 3);
    open_daughter_window (&button_registers, win_main,
         (t1*6)+30, (t2*3)+140, (t1*3)-30, t2+10, &gc, black, light_grey, 3);
    open_daughter_window (&button_SR, win_main,
         (t1*6)+30, (t2*4)+160, (t1*3)-30, t2-30, &gc, black, light_grey, 3);

    open_daughter_window (&button_Xbar, win_main,
         (t1*4)+20, (t2*2)+180, t1, (t2*3)-50, &gc, black, light_grey, 3);

    /* Fetcher-Xbar */
    main_segments[8].x1=main_segments[8].x2=main_segments[9].x1=(t1*6)+10;
    main_segments[9].x2=main_segments[18].x1=main_segments[18].x2=(t1*5)+13;
    main_segments[8].y1=t2+140;
    main_segments[18].y1=(t2<<1)+180;
    main_segments[18].y2=main_segments[8].y2=
     main_segments[9].y1=main_segments[9].y2=(t2*2)+160;

    /* LSU-Xbar */
    main_segments[19].y1=(t2*2)+180;
    main_segments[20].x1=main_segments[19].x1=main_segments[19].x2=(t1*4)+27;
    main_segments[21].y1=main_segments[20].y1=main_segments[20].y2=main_segments[19].y2=(t2*2)+160;
    main_segments[22].x1=main_segments[21].x1=main_segments[21].x2=main_segments[20].x2=(t1*3)+10;
    main_segments[23].y1=main_segments[22].y1=main_segments[22].y2=main_segments[21].y2=t2+140;
    main_segments[23].x1=main_segments[23].x2=main_segments[22].x2=(t1*3)>>1;
    main_segments[23].y2=t2+120;

    /* Xbar-R7 */
    for (i=1; i<8; i++) {
      main_segments[i+9].y1=main_segments[i+9].y2=((i*(t2+10))/6)+(t2*3)+140;
      main_segments[i+9].x1=(t1*5)+20;
      main_segments[i+9].x2=(t1*6)+30;
    } /* + Xbar-SR */
    main_segments[15].y1=main_segments[15].y2=(t2*4)+160+((t2-30)/3);
    main_segments[16].y1=main_segments[16].y2=(t2*4)+160+(((t2-30)*2)/3);

    /* TLB-Xbar */
    main_segments[17].x1=main_segments[17].x2=(main_xsize+20)>>1;
    main_segments[17].y1=(t2<<1)+140;
    main_segments[17].y2=(t2*2)+180;

    t3=((main_ysize-10)-(t2+160));
    open_daughter_window (&button_ROP2, win_main,
          10, t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);
    open_daughter_window (&button_INC, win_main,
          10, (t3/6)+t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);
    open_daughter_window (&button_SHUFFLER, win_main,
          10, (t3/3)+t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);
    open_daughter_window (&button_ASU, win_main,
          10, (t3>>1)+t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);
    open_daughter_window (&button_IMU, win_main,
          10, ((t3<<1)/3)+t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);
    open_daughter_window (&button_IDU, win_main,
          10, ((t3*5)/6)+t2+160,(t1*3)-20, (t3/6)-8, &gc, black, light_grey, 3);

    for (i=1; i<7; i++) {
      main_segments[i+23].x1=(t1*4)+20;
      main_segments[i+23].x2=(t1*3)-10;
      main_segments[i+23].y1=(t2*2)+180+((i* ((t2*3)-50))/7);
      main_segments[i+23].y2=t2+160-(t3/12)+((i*t3)/6);
    }
  }

  if (resize_flag & 1L<<1) {
    if (mem_xsize<250) {
      mem_xsize=250;
    }
    if (mem_ysize<250) {
      mem_ysize=250;
    }
    open_window(&win_mem,mem_xsize, mem_ysize,&gc,black,grey,"MEMORY",hide_mem);
    open_daughter_window (&button_hide_mem, win_mem,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<2) {
    if (fetcher_xsize<250) {
      fetcher_xsize=250;
    }
    if (fetcher_ysize<250) {
      fetcher_ysize=250;
    }
    open_window(&win_fetcher,fetcher_xsize, fetcher_ysize,&gc,black,grey,"FETCHER WINDOW",hide_fetcher);
    open_daughter_window (&button_hide_fetcher, win_fetcher,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<3) {
    if (fetcher_tags_xsize<250) {
      fetcher_tags_xsize=250;
    }
    if (fetcher_tags_ysize<250) {
      fetcher_tags_ysize=250;
    }
    open_window(&win_fetcher_tags,fetcher_tags_xsize, fetcher_tags_ysize,&gc,black,grey,"FETCHER TAGS",hide_fetcher_tags);
    open_daughter_window (&button_hide_fetcher_tags, win_fetcher_tags,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<4 ) {
    if (LSU_tags_xsize<250) {
      LSU_tags_xsize=250;
    }
    if (LSU_tags_ysize<250) {
      LSU_tags_ysize=250;
    }
    open_window(&win_LSU_tags,LSU_tags_xsize, LSU_tags_ysize,&gc,black,grey,"LSU TAGS",hide_LSU_tags);
    open_daughter_window (&button_hide_LSU_tags, win_LSU_tags,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<5) {
    if (LSU_xsize<250) {
      LSU_xsize=250;
    }
    if (LSU_ysize<250) {
      LSU_ysize=250;
    }
    open_window(&win_LSU,LSU_xsize, LSU_ysize,&gc,black,grey,"LSU",hide_LSU);
    open_daughter_window (&button_hide_LSU, win_LSU,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<6) {
    if (TLB_xsize<250) {
      TLB_xsize=250;
    }
    if (TLB_ysize<250) {
      TLB_ysize=250;
    }
    open_window(&win_TLB,TLB_xsize, TLB_ysize,&gc,black,grey,"TLB",hide_TLB);
    open_daughter_window (&button_hide_TLB, win_TLB,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<7) {
    if (Xbar_xsize<250) {
      Xbar_xsize=250;
    }
    if (Xbar_ysize<250) {
      Xbar_ysize=250;
    }
    open_window(&win_Xbar,Xbar_xsize, Xbar_ysize,&gc,black,grey,"Xbar",hide_Xbar);
    open_daughter_window (&button_hide_Xbar, win_Xbar,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<8) {
    if (decoder_xsize<250) {
      decoder_xsize=250;
    }
    if (decoder_ysize<250) {
      decoder_ysize=250;
    }
    open_window(&win_decoder,decoder_xsize, decoder_ysize,&gc,black,grey,"DECODER",hide_decoder);
    open_daughter_window (&button_hide_decoder, win_decoder,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<9) {
    if (register_xsize<250) {
      register_xsize=250;
    }
    if (register_ysize<250) {
      register_ysize=250;
    }
    open_window(&win_register,register_xsize, register_ysize,&gc,black,grey,"REGISTERS",hide_register);
    open_daughter_window (&button_hide_register, win_register,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  if (resize_flag & 1L<<10) {
    if (scoreboard_xsize<250) {
      scoreboard_xsize=250;
    }
    if (scoreboard_ysize<250) {
      scoreboard_ysize=250;
    }
    open_window(&win_scoreboard,scoreboard_xsize, scoreboard_ysize,&gc,black,grey,"SCOREBOARD",hide_scoreboard);
    open_daughter_window (&button_hide_scoreboard, win_scoreboard,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

/****************************************************************************************************************

  if (resize_flag & 1L<<) {
    if (_xsize<250) {
      _xsize=250;
    }
    if (_ysize<250) {
      _ysize=250;
    }
    open_window(&win_,_xsize, _ysize,&gc,black,grey,"",hide_);
    open_daughter_window (&button_hide_, win_,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

****************************************************************************************************************/

  resize_flag=0;

  /* main loop */

  do {
    XNextEvent(dpy,&event);
    switch(event.type) {

      case Expose:
        if (event.xexpose.window==button_quit){
          XDrawImageString(dpy,button_quit,gc,3,13,"QUIT",4);
        } else if (event.xexpose.window==button_init) {
          XDrawImageString(dpy,button_init,gc,5,13,"INIT",4);
        } else if (event.xexpose.window==button_step) {
          XDrawImageString(dpy,button_step,gc,3,13,"STEP",4);
        } else if (event.xexpose.window==button_hide_mem) {
          XDrawImageString(dpy,button_hide_mem,gc,3,13,"HIDE",4);
        } else if (event.xexpose.window==button_hide_fetcher) {
          XDrawImageString(dpy,button_hide_fetcher,gc,3,13,"HIDE",4);
        } else if (event.xexpose.window==button_hide_fetcher_tags) {
          XDrawImageString(dpy,button_hide_fetcher_tags,gc,3,13,"HIDE",4);
        } else if (event.xexpose.window==button_hide_LSU_tags) {
          XDrawImageString(dpy,button_hide_LSU_tags,gc,3,13,"HIDE",4);
        } else if (event.xexpose.window==button_hide_LSU) {
          XDrawImageString(dpy,button_hide_LSU,gc,3,13,"HIDE",4);
        } else if (event.xexpose.window==button_hide_scoreboard) {
          XDrawImageString(dpy,button_hide_scoreboard,gc,3,13,"HIDE",4);
        } else if (event.xexpose.window==button_hide_TLB) {
          XDrawImageString(dpy,button_hide_TLB,gc,3,13,"HIDE",4);
        } else if (event.xexpose.window==button_hide_Xbar) {
          XDrawImageString(dpy,button_hide_Xbar,gc,3,13,"HIDE",4);
        } else if (event.xexpose.window==button_hide_decoder) {
          XDrawImageString(dpy,button_hide_decoder,gc,3,13,"HIDE",4);
        } else if (event.xexpose.window==button_hide_register) {
          XDrawImageString(dpy,button_hide_register,gc,3,13,"HIDE",4);
        }
       /* else if (event.xexpose.window==button_hide_) {
          XDrawImageString(dpy,button_hide_,gc,3,13,"HIDE",4);
        }*/
          else if (event.xexpose.window==button_mem) {
          XDrawImageString(dpy,button_mem,gc2,((main_xsize-(26*2))-52)>>1,(50+12)>>1,"MEMORY",6);
        } else if (event.xexpose.window==win_main) {
          XDrawSegments(dpy,win_main,gc,main_segments, sizeof(main_segments)/sizeof(XSegment));
        } else if (event.xexpose.window==button_LSU) {
          XDrawImageString(dpy,button_LSU,gc,((t1*3)-30)>>1,t2>>1,"LSU",3);
        } else if (event.xexpose.window==button_LSU_tags) {
          XDrawImageString(dpy,button_LSU_tags,gc,((t1)-30)>>1,t2>>1,"tags",4);
        } else if (event.xexpose.window==button_fetch_logic) {
          XDrawImageString(dpy,button_fetch_logic,gc,((t1)-25)>>1,(t2>>1)-8,"Bus",3);
          XDrawImageString(dpy,button_fetch_logic,gc,((t1)-45)>>1,(t2>>1)+8,"Arbiter",7);
        } else if (event.xexpose.window==button_fetcher_tags) {
          XDrawImageString(dpy,button_fetcher_tags,gc,((t1)-30)>>1,t2>>1,"tags",4);
        } else if (event.xexpose.window==button_fetcher) {
          XDrawImageString(dpy,button_fetcher,gc,((t1*3)-70)>>1,t2>>1,"FETCHER",7);
        } else if (event.xexpose.window==button_Xbar) {
          XDrawImageString(dpy,button_Xbar,gc,(t1-30)>>1,((t2*3)>>1)-20,"Xbar",4);
        } else if (event.xexpose.window==button_TLB) {
          XDrawImageString(dpy,button_TLB,gc,(main_xsize>>3)-15,(t2>>1)-6,"TLB",3);
        } else if (event.xexpose.window==button_decoder) {
          XDrawImageString(dpy,button_decoder,gc,(main_xsize>>3)-25,t2>>1,"Decoder",7);
        } else if (event.xexpose.window==button_scoreboard) {
          XDrawImageString(dpy,button_scoreboard,gc,(main_xsize>>3)-35,(t2>>1)-10,"Scoreboard",10);
        } else if (event.xexpose.window==button_registers) {
          XDrawImageString(dpy,button_registers,gc,(main_xsize>>3)-45,(t2>>1)+10,"REGISTERS",9);
        } else if (event.xexpose.window==button_SR) {
          XDrawImageString(dpy,button_SR,gc,(main_xsize>>3)-50,(t2>>1)-10,
              "Special Registers",17);
        } else if (event.xexpose.window==button_ROP2) {
          XDrawImageString(dpy,button_ROP2,gc,(main_xsize>>3)-40,(t3/12)+1,"ROP2",4);
        } else if (event.xexpose.window==button_INC) {
          XDrawImageString(dpy,button_INC,gc,(main_xsize>>3)-40,(t3/12)+1,"INC/SORT",8);
        } else if (event.xexpose.window==button_SHUFFLER) {
          XDrawImageString(dpy,button_SHUFFLER,gc,(main_xsize>>3)-40,(t3/12)+1,"SHUFFLER",8);
        } else if (event.xexpose.window==button_ASU) {
          XDrawImageString(dpy,button_ASU,gc,(main_xsize>>3)-40,(t3/12)+1,"ADD/SUB",7);
        } else if (event.xexpose.window==button_IMU) {
          XDrawImageString(dpy,button_IMU,gc,(main_xsize>>3)-40,(t3/12)+1,"MULTIPLY",8);
        } else if (event.xexpose.window==button_IDU) {
          XDrawImageString(dpy,button_IDU,gc,(main_xsize>>3)-40,(t3/12)+1,"DIVIDE",6);
        }

        break;

      case ButtonPress:
        if ((event.xexpose.window==button_mem)
          ||(event.xexpose.window==button_hide_mem)) {
          if (hide_mem==HIDDEN) {
            hide_mem=SHOWN;
            XMapWindow (dpy, win_mem);
          }
          else {
            hide_mem=HIDDEN;
            XUnmapWindow (dpy, win_mem);
          }
        }
        else
        if ((event.xexpose.window==button_fetcher)
          ||(event.xexpose.window==button_hide_fetcher)) {
          if (hide_fetcher==HIDDEN) {
            hide_fetcher=SHOWN;
            XMapWindow (dpy, win_fetcher);
          }
          else {
            hide_fetcher=HIDDEN;
            XUnmapWindow (dpy, win_fetcher);
          }
        }
        else
        if ((event.xexpose.window==button_fetcher_tags)
          ||(event.xexpose.window==button_hide_fetcher_tags)) {
          if (hide_fetcher_tags==HIDDEN) {
            hide_fetcher_tags=SHOWN;
            XMapWindow (dpy, win_fetcher_tags);
          }
          else {
            hide_fetcher_tags=HIDDEN;
            XUnmapWindow (dpy, win_fetcher_tags);
          }
        }
        else
        if ((event.xexpose.window==button_LSU_tags)
          ||(event.xexpose.window==button_hide_LSU_tags)) {
          if (hide_LSU_tags==HIDDEN) {
            hide_LSU_tags=SHOWN;
            XMapWindow (dpy, win_LSU_tags);
          }
          else {
            hide_LSU_tags=HIDDEN;
            XUnmapWindow (dpy, win_LSU_tags);
          }
        }
        else
        if ((event.xexpose.window==button_LSU)
          ||(event.xexpose.window==button_hide_LSU)) {
          if (hide_LSU==HIDDEN) {
            hide_LSU=SHOWN;
            XMapWindow (dpy, win_LSU);
          }
          else {
            hide_LSU=HIDDEN;
            XUnmapWindow (dpy, win_LSU);
          }
        }
        else
        if ((event.xexpose.window==button_TLB)
          ||(event.xexpose.window==button_hide_TLB)) {
          if (hide_TLB==HIDDEN) {
            hide_TLB=SHOWN;
            XMapWindow (dpy, win_TLB);
          }
          else {
            hide_TLB=HIDDEN;
            XUnmapWindow (dpy, win_TLB);
          }
        }
        else
        if ((event.xexpose.window==button_Xbar)
          ||(event.xexpose.window==button_hide_Xbar)) {
          if (hide_Xbar==HIDDEN) {
            hide_Xbar=SHOWN;
            XMapWindow (dpy, win_Xbar);
          }
          else {
            hide_Xbar=HIDDEN;
            XUnmapWindow (dpy, win_Xbar);
          }
        }
        else
        if ((event.xexpose.window==button_decoder)
          ||(event.xexpose.window==button_hide_decoder)) {
          if (hide_decoder==HIDDEN) {
            hide_decoder=SHOWN;
            XMapWindow (dpy, win_decoder);
          }
          else {
            hide_decoder=HIDDEN;
            XUnmapWindow (dpy, win_decoder);
          }
        }
        else
        if ((event.xexpose.window==win_register)
          ||(event.xexpose.window==button_hide_register)) {
          if (hide_register==HIDDEN) {
            hide_register=SHOWN;
            XMapWindow (dpy, win_register);
          }
          else {
            hide_register=HIDDEN;
            XUnmapWindow (dpy, win_register);
          }
        }
        else
        if ((event.xexpose.window==button_scoreboard)
          ||(event.xexpose.window==button_hide_scoreboard)) {
          if (hide_scoreboard==HIDDEN) {
            hide_scoreboard=SHOWN;
            XMapWindow (dpy, win_scoreboard);
          }
          else {
            hide_scoreboard=HIDDEN;
            XUnmapWindow (dpy, win_scoreboard);
          }
        }
/*
        else
        if ((event.xexpose.window==button_)
          ||(event.xexpose.window==button_hide_)) {
          if (hide_==HIDDEN) {
            hide_=SHOWN;
            XMapWindow (dpy, win_);
          }
          else {
            hide_=HIDDEN;
            XUnmapWindow (dpy, win_);
          }
        }
*/
        break;

      case MotionNotify: /* pour d'eventuels scrollbars */

        break;

      case ResizeRequest:
        resize_flag=0;
        if (event.xresizerequest.window==win_main){
          resize_flag=1L<<0;
          main_xsize=event.xresizerequest.width;
          main_ysize=event.xresizerequest.height;
        }
        else if (event.xresizerequest.window==win_mem) {
          resize_flag=1L<<1;
          mem_xsize=event.xresizerequest.width;
          mem_ysize=event.xresizerequest.height;
        }
        else if (event.xresizerequest.window==win_fetcher) {
          resize_flag=1L<<2;
          fetcher_xsize=event.xresizerequest.width;
          fetcher_ysize=event.xresizerequest.height;
        }
        else if (event.xresizerequest.window==win_fetcher_tags) {
          resize_flag=1L<<3;
          fetcher_tags_xsize=event.xresizerequest.width;
          fetcher_tags_ysize=event.xresizerequest.height;
        }
        else if (event.xresizerequest.window==win_LSU_tags) {
          resize_flag=1L<<4;
          LSU_tags_xsize=event.xresizerequest.width;
          LSU_tags_ysize=event.xresizerequest.height;
        }
        else if (event.xresizerequest.window==win_LSU) {
          resize_flag=1L<<5;
          LSU_xsize=event.xresizerequest.width;
          LSU_ysize=event.xresizerequest.height;
        }
        else if (event.xresizerequest.window==win_TLB) {
          resize_flag=1L<<6;
          TLB_xsize=event.xresizerequest.width;
          TLB_ysize=event.xresizerequest.height;
        }
        else if (event.xresizerequest.window==win_Xbar) {
          resize_flag=1L<<7;
          Xbar_xsize=event.xresizerequest.width;
          Xbar_ysize=event.xresizerequest.height;
        }
        else if (event.xresizerequest.window==win_decoder) {
          resize_flag=1L<<8;
          decoder_xsize=event.xresizerequest.width;
          decoder_ysize=event.xresizerequest.height;
        }
        else if (event.xresizerequest.window==win_register) {
          resize_flag=1L<<9;
          register_xsize=event.xresizerequest.width;
          register_ysize=event.xresizerequest.height;
        }
        else if (event.xresizerequest.window==win_scoreboard) {
          resize_flag=1L<<10;
          scoreboard_xsize=event.xresizerequest.width;
          scoreboard_ysize=event.xresizerequest.height;
        }
/*
        else if (event.xresizerequest.window==win_) {
          resize_flag=1L<<;
          _xsize=event.xresizerequest.width;
          _ysize=event.xresizerequest.height;
        }
*/
        break;

      case KeyPress :
        XLookupString(&event.xkey, &car, 1, &keysym, 0);
        if ((car=='q')||(car=='Q'))
          goto the_end;

        break;

    }
  } while (!(((event.type==ButtonRelease)&&(event.xexpose.window==button_quit))
            ||(resize_flag!=0)));

the_end:

  if (resize_flag==0) {
    /* collect the X geometries of the windows and save them to a file */
  }

  if ((resize_flag & 1L<<0)||(resize_flag==0)) {
    close_window(&win_main);
    if (resize_flag & 1L<<0) goto redisplay;
  }

  if ((resize_flag & 1L<<1)||(resize_flag==0)) {
    close_window(&button_hide_mem);
    close_window(&win_mem);
    if (resize_flag & 1L<<1) goto redisplay;
  }

  if ((resize_flag & 1L<<2)||(resize_flag==0)) {
    close_window(&button_hide_fetcher);
    close_window(&win_fetcher);
    if (resize_flag & 1L<<2) goto redisplay;
  }

  if ((resize_flag & 1L<<3)||(resize_flag==0)) {
    close_window(&button_hide_fetcher_tags);
    close_window(&win_fetcher_tags);
    if (resize_flag & 1L<<3) goto redisplay;
  }

  if ((resize_flag & 1L<<4)||(resize_flag==0)) {
    close_window(&button_hide_LSU_tags);
    close_window(&win_LSU_tags);
    if (resize_flag & 1L<<4) goto redisplay;
  }

  if ((resize_flag & 1L<<5)||(resize_flag==0)) {
    close_window(&button_hide_LSU);
    close_window(&win_LSU);
    if (resize_flag & 1L<<5) goto redisplay;
  }

  if ((resize_flag & 1L<<6)||(resize_flag==0)) {
    close_window(&button_hide_TLB);
    close_window(&win_TLB);
    if (resize_flag & 1L<<6) goto redisplay;
  }

  if ((resize_flag & 1L<<7)||(resize_flag==0)) {
    close_window(&button_hide_Xbar);
    close_window(&win_Xbar);
    if (resize_flag & 1L<<7) goto redisplay;
  }

  if ((resize_flag & 1L<<8)||(resize_flag==0)) {
    close_window(&button_hide_decoder);
    close_window(&win_decoder);
    if (resize_flag & 1L<<8) goto redisplay;
  }

  if ((resize_flag & 1L<<9)||(resize_flag==0)) {
    close_window(&button_hide_register);
    close_window(&win_register);
    if (resize_flag & 1L<<9) goto redisplay;
  }

  if ((resize_flag & 1L<<10)||(resize_flag==0)) {
    close_window(&button_hide_scoreboard);
    close_window(&win_scoreboard);
    if (resize_flag & 1L<<10) goto redisplay;
  }

/*
  if ((resize_flag & 1L<<)||(resize_flag==0)) {
    close_window(&button_hide_);
    close_window(&win_);
    if (resize_flag & 1L<<) goto redisplay;
  }
*/
  exitX();
}

