 /*

 F-CPU CORE #0 simulator #2
 Whygee 9/29/1999

 now, a more modular design.

 */


#include <string.h>
#include <stdlib.h>
#include <stdio.h>


void error(char * message) {
 printf("\n\nSimulator error: %s\n",message);
 exit(-1);
}


/*******************
 * DATA DEFINITION *
 *******************/


/* for the simulator */
typedef unsigned long long int ulli;
/* "uli" is used when much precision is needed, at least 32 bits,
   with an attempt to use 64-bit precision.
   "int" is used when simple numbers (less than 1000 for example) are used.*/

/* Programming model type definitions : */

/* for the processor */
typedef unsigned char u8;
typedef unsigned char u16[2];
typedef unsigned char u32[4];
typedef unsigned char u64[8];

/* implementation dependent: */
#define MAXSIZE 8
#define UMAX u64
/* here, the characteristic data size is 64 bits */



/**********************
 * LOW LEVEL ROUTINES *
 **********************/


/* converts a word to an int */
ulli read_value (unsigned int size, u8 *c) {
 ulli t=0;

 do {
  size--;
  t<<=8;
  t|=c[size];
 } while (size);

 return t;
}


/* converts an int to a word */
void write_value (unsigned int size, u8 *c, ulli value) {
 do {
  *(c++)= (u8)(value);
  value>>=8;
  size--;
 } while (size);
}

/* compares two words */
int compare_superior_values(unsigned int size, u8 * s1, u8 *s2) {
 do {
  size--;
  if (s1[size]>s2[size]) return 1;
  if (s1[size]<s2[size]) return 0;
 } while (size);
 return 0;
}

int compare_equal_values(unsigned int size, u8 * s1, u8 *s2) {
 do {
  size--;
  if (s1[size]!=s2[size]) return 0;
 } while (size);
 return 1;
}

/* adds two words with carry */
int add_values (unsigned int size, u8 *res, u8 *op1, u8 *op2, int carry) {
 unsigned int i=0, j=carry;
 do {
  j+=op1[i]+op2[i];
  res[i]=(char)j;
  j>>=8;
  i++;
 } while (i<size);
 return j;
}

/* displays a word */

u8 h2c(u8 c) {
 if (c>'9') return c-'A'+10;
 return c-'0';
}

u8 c2h(u8 c) {
 if (c>9) return c+('A'-10);
 return c+'0';
}

void display_value(unsigned int size, u8 *c) {
 unsigned int i;
 do {
  i=c[--size];
  putchar(c2h(i>>4));
  putchar(c2h(i&15));
 } while (size);
}

#include "fcpu_r7_01.c"
/*
  this file imports the register set definition
  and defines the following functions :
     void display_register(u8 r)       [ displays a register's content ]
     void display_register_set (void)  [ displays all the registers ]
     void cycle_r7 (void)              [ performs one clock cycle operation ] 


*/




void main() {
 cycle_r7 ();
 display_register_set();
}
