-- reg.vhdl -- Clocked Variable-Width Register
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: reg.vhdl,v 1.3 2000/10/31 05:26:04 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity Reg is
	generic (
		WIDTH : natural := 64
	);
	port (
		Clk, Rst : in std_ulogic;
		D : in std_ulogic_vector(WIDTH-1 downto 0);
		Q : out std_ulogic_vector(WIDTH-1 downto 0)
	);
end Reg;

architecture Behave_1 of Reg is
begin
	process (Clk, Rst)
	begin
		if Rst = '1' then
			Q <= (others => '0');
		elsif rising_edge(Clk) then
			Q <= D;
		end if;
	end process;
end Behave_1;
