-- mc2.vhdl -- 2-input Muller-C gate
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: mc2.vhdl,v 1.3 2000/10/31 05:26:04 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity MC2 is
	port (
		A, B : in std_ulogic;
		Y : out std_ulogic
	);
end MC2;

architecture Behave_1 of MC2 is
begin
	process (A, B)
	begin
		if (A = '1') and (B = '1') then
			Y <= '1';
		elsif (A = '0') and (B = '0') then
			Y <= '0';
		end if;
	end process;
end Behave_1;
