%{
 /*

Whygee's GNL parser (C) Yann Guidon 29 mars 2000
This is free software ; see the GPL for copying condi
tions. There is NO warranty; not even for MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.
To say the least, this program is buggy and nobody should
rely on it, it's only a first version. its purpose is to
evaluate functionalities, it will be recoded later more
cleanly.

whygee@f-cpu.org

rev. 2 : adapted it for inclusion as a module in gnl.c (ie avoided the use of exit()).

 */

string_cell *first_warning=NULL, *last_warning=NULL;
 /* we must read the messages in the correct order ! */

void lex_warning(char *s) {
  string_cell * p;
  char c[200];
  int l;
  sprintf(c,"warning : %s",s);
  if (yytext)
    sprintf(c+strlen(c)," (%s)",yytext);
  l=strlen(c);
  p=my_alloc(&ll_warning,sizeof(string_cell)+l+1);
  memcpy(sizeof(string_cell)+((char*)p),c,l);
  if (last_warning!=NULL)
    last_warning->next=p;
  else
    first_warning=p;
  last_warning=p;
  p->size=l;
}

#define _GHEADER      300
#define _GNODE        301
#define _GNODES       302
#define _GTITLE       303
#define _GCOPYRIGHT   304
#define _GREVISION    305
#define _GCOMMENT     306
#define _GNUMBER      307
#define _GTYPE        308
#define _GVALUE       309
#define _GSHEETS      310
#define _GSHEET       311
#define _GDATE        312
#define _GLIBRARY     313
#define _GCYCLE       314
#define _GYOFFSET     315
#define _GALIAS       316
#define _GXOFFSET     317
#define _G2DOT        318
#define _GCOMADOT     319
#define _GCOMA        320
#define _GOPEN        321
#define _GCLOSE       322
#define _GEQUAL       323
#define _GDECIMAL     324
#define _GSTRING      325
#define _GERROR       326
#define _GEOF         327
#define _GADDRESS     328
#define _GBBOX        329
#define _GBOX         330
#define _GCODE        331
#define _GCOLOR       332
#define _GDATA        333
#define _GINPUT       334
#define _GINITVAL     335
#define _GLINE        336
#define _GNAME        337
#define _GOUTPUT      338
#define _GPROFILE     339
#define _GSHAPES      340
#define _GSHAPE       341
#define _GSIGNED      342
#define _GSTATIC      343
#define _GTEXTXY      344
#define _GUSED        345
#define _GWIDTH       346
#define _GNODEEQ      347
#define _GVALID       348

%}

%option noyywrap
%option never-interactive

%%

[ \x0D\n\t]+ /* separators, space, buggers... */

\< { /* comments */
  int c;
  do {
    c=input();
  } while ((c!='>')&&(c!=EOF));
}

["].*["][;] {
  string_cell *p=my_alloc(&ll_string,sizeof(string_cell)+yyleng-2); /* adds a trailing zero*/
  memcpy(sizeof(string_cell)+((char*)p),yytext+1,yyleng-3);
  p->next=last_string;
  p->size=yyleng-3;
  last_string=p;
  return _GSTRING;
}

"address="     return _GADDRESS;
"alias="       return _GALIAS;
"bbox="        return _GBBOX;
"box="         return _GBOX;
"code="        return _GCODE;
"color="       return _GCOLOR;
"comment="     return _GCOMMENT;
"copyright="   return _GCOPYRIGHT;
"cycle{"       return _GCYCLE;
"data{"        return _GDATA;
"date="        return _GDATE;
"header{"      return _GHEADER;
"input="       return _GINPUT;
"initval="     return _GINITVAL;
"library="     return _GLIBRARY;
"line="        return _GLINE;
"name="        return _GNAME;
"node{"        return _GNODE;
"node="        return _GNODEEQ;
"nodes{"       return _GNODES;
"number="      return _GNUMBER;
"output="      return _GOUTPUT;
"profile{"     return _GPROFILE;
"revision="    return _GREVISION;
"shapes{"      return _GSHAPES;
"shape{"       return _GSHAPE;
"sheets{"      return _GSHEETS;
"sheet{"       return _GSHEET;
"signed="      return _GSIGNED;
"static{"      return _GSTATIC;
"textxy="      return _GTEXTXY;
"title="       return _GTITLE;
"type="        return _GTYPE;
"used="        return _GUSED;
"valid="       return _GVALID;
"value="       return _GVALUE;
"width="       return _GWIDTH;
"xoffset="     return _GXOFFSET;
"yoffset="     return _GYOFFSET;

:           return _G2DOT;
;           return _GCOMADOT;
,           return _GCOMA;
\}          return _GCLOSE;
\{          return _GCLOSE;
=           return _GEQUAL;
[0-9]+      return _GDECIMAL;
<<EOF>>     return _GEOF;

 /* remaining : */
[_A-Za-z][_A-Za-z0-9]+ lex_warning("unknown token"); return _GERROR;
.                      lex_warning("unknown token"); return _GERROR;

%%

void getstring(string_cell **sc){
  if (yylex()!=_GSTRING)
    lex_warning("not a string");

  if (*sc!=NULL) {
    lex_warning("field already defined");
    return;
  }
  *sc=last_string;
}

void getint(int *i){
  if (yylex()!=_GDECIMAL)
    lex_warning("not a decimal number");
  *i=atoi(yytext);
}

void getend(void){
  if (yylex()!=_GCOMADOT)
    lex_warning("not a correct format");
}

int scan_GNL(char *filename){
  int readamount,i,j;
  char signature_buffer[5];

  if (first_warning!=NULL) {
    ll_free(&ll_warning);
    first_warning=NULL;
    last_warning=NULL;
  }

  if (last_string!=NULL) {
    ll_free(&ll_string);
    last_string=NULL;
  }

  yyin=fopen(filename,"rb");
  if (yyin==NULL) {
    lex_warning("can't open source file");
    return(1);
  }

  readamount=fread(signature_buffer, 1,5, yyin);
  if ((readamount!=5)||(memcmp(signature_buffer,".GNL0",5))) {
    lex_warning("signature not found");
    return(2);
  }

/* parsing of the file : */

  j=0;
  do {
    i=yylex();
    switch(i) {

      case _GHEADER:
/* create the root structure */
        do {
          i=yylex();
          switch(i) {
            case _GEOF:       lex_warning("EOF reached in header");  return 3;
            case _GERROR:     break;
            case _GCOPYRIGHT: getstring(&root_cell.copyright);  break;
               /* linked lists should be implemented here */
            case _GTITLE:     getstring(&root_cell.title);      break;
            case _GREVISION:  getint(&root_cell.revision);      getend();  break;
            case _GCOMMENT:   getstring(&root_cell.comment);    break;
            default : lex_warning("unexpected token");
            case _GCLOSE:
          }
        }
        while (i!=_GCLOSE);
        break;

/*
        printf("header found\nrevision : %d\n",root_cell.revision);
        if (root_cell.title!=NULL)
          printf("title : %s\n",((char *)root_cell.title)+sizeof(struct struct_string_cell));
        if (root_cell.copyright!=NULL)
          printf("copyright : %s\n",((char *)root_cell.copyright)+sizeof(struct struct_string_cell));
        if (root_cell.comment!=NULL)
          printf("comment : %s\n",((char *)root_cell.comment)+sizeof(struct struct_string_cell));
*/

      default :

    }

  }
  while ((i!=_GEOF)&&(i!=_GERROR));

  if (i!=_GEOF)
    lex_warning("scan aborted.");

  return 0;
}
