/*
<HTML><TITLE>Whygee's dirty Xlib'ed interface</TITLE><BODY BGCOLOR="#FFFFFF" FGCOLOR="#000000"><PRE>

 (C) mars 2000 by Yann Guidon, placed under GPL

*/

/* for the directory listing : */
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <dirent.h>

#define PATHNAMELENGTH 300
char
 directory_load[PATHNAMELENGTH],
 directory_save[PATHNAMELENGTH],
 current_directory[PATHNAMELENGTH],
 current_file[PATHNAMELENGTH];
block_header *ll_browse=NULL; /* linked list of file names */
string_cell first_file_name;

int
 min_browse_menu,
 max_browse_menu,
 current_browse_sel,
 current_browse_line=0,
 toolbar_in_use=0, /* ==1 if load, ==2 if save as */
 nb_fic=0;

int create_descriptors(char *c) {
  string_cell *p, *q;
  DIR *dir;
  struct direct *file;
  struct stat state;
  int i,len,oldlen;

  if (c[0]==0) {
    /* setup the default directory */
    if (getcwd(c,PATHNAMELENGTH)==NULL) {
      XBell(dpy,1);
      change_message("can't get current working directory");
      return 1;
    }
  }

  if (c!=current_directory)
    memcpy(current_directory,c,PATHNAMELENGTH); /* banzaii ! */

  if ((dir=opendir(current_directory))==NULL) {
    XBell(dpy,1);
    memcpy(error_msg,"can't open this directory : ",29);
    memcpy(error_msg+28,current_directory,51);
    error_msg[80]=0;
    change_message(error_msg);
    return 2;
  }

  /* free the list etc */
  if (ll_browse)
    ll_free(&ll_browse);
  len=strlen(current_directory);
  first_file_name.next=NULL;
  nb_fic=0;
  oldlen=len;
  if (len>1) {
    current_directory[len]='/';
    len++;
    current_directory[len]=0;
  }

  while ((file=readdir(dir))!=NULL) {  /* while there is a file */
    if (strcmp(".",file->d_name)) {   /* skip the unuseful "." entry */
      i=strlen(file->d_name);
      if (i+len< PATHNAMELENGTH) {
	memcpy(current_directory+len,file->d_name,i+1); /* make a full absolute file name */
	if (stat(current_directory,&state)==0) {
	  p=my_alloc(&ll_browse,sizeof(string_cell)+i+2);
	  c=sizeof(string_cell)+((char*)p);
	  memcpy(c,file->d_name,i+2);
	  if (S_ISDIR(state.st_mode)) {
	    c[i++]='/';
	    c[i]=0;
	  }
	  p->size=i;
	  nb_fic++;

	  q=&first_file_name;

	  while ((q->next)&&((i=strcmp(sizeof(string_cell)+((char*)q->next),
                                      sizeof(string_cell)+((char*)p)))<=0))
	    q=q->next;

	  p->next=q->next;  
	  q->next=p;	    
	}
      }
    }
  }

  current_directory[oldlen]=0; /* cleanup the '/' */

  closedir(dir);
  return 0;
}

void display_browse(void) {
  string_cell * p;
  int m;
  XDrawImageString(dpy,win_toolbar,gc2,4,font->ascent+2,current_directory,strlen(current_directory));
  m=hmenu;
  XDrawLine(dpy,win_toolbar,gcgrey3,0,m,lright,m); m++;
  XDrawLine(dpy,win_toolbar,gcgrey5,0,m,lright,m); m++;
  XDrawLine(dpy,win_toolbar,gcgrey6,0,m,lright,m); m++;
  XDrawLine(dpy,win_toolbar,gcgrey5,0,m,lright,m); m++;
  XDrawLine(dpy,win_toolbar,gcgrey3,0,m,lright,m); m++;
  min_browse_menu=m;
  p=&first_file_name;
loop:
  p=p->next;
  if ((p)&&(m<htoolbar-hmenu)) {
    XDrawImageString(dpy,win_toolbar,gc2,4,m+font->ascent+2,sizeof(string_cell)+((char*)p),p->size);
    m+=hmenu;
    goto loop;
  }

  max_browse_menu=m;
  if ((current_browse_line)&&(current_browse_line<max_browse_menu)) {
    XDrawRectangle(dpy,win_toolbar,gcgrey6,0,current_browse_line,lright,hmenu+2);
    XDrawRectangle(dpy,win_toolbar,gcgrey5,1,current_browse_line+1,lright-2,hmenu);
    XDrawRectangle(dpy,win_toolbar,gcgrey3,2,current_browse_line+2,lright-4,hmenu-2);
  }
}

void (*display_toolbar)(void)=NULL;

void callback_load(){
  if (toolbar_in_use!=1) {
    toolbar_in_use=1;
    current_browse_line=0;
    current_browse_sel=0;
    if (create_descriptors(directory_load)) {
      directory_load[0]='/';
      directory_load[1]=0;
      create_descriptors(directory_load);
    }
    display_toolbar=display_browse; /* change the function that displays the toolbar */
    XClearWindow(dpy,win_toolbar);
    display_browse();  }
}
