/*****************************************************************************/
/*Fichier : ram_interface.h Auteur : Pierre Tardy,Francois Vieville ISIMA   */
/*Description : interface de la ram              		             */
/*             							             */
/*****************************************************************************/

#ifndef _RAM_INTERFACE_H_
#define _RAM_INTERFACE_H_

#include "emu.h"
#include "systemc.h"


template <class T, int n>
class ram_read_if: virtual public sc_interface
{
public:
  virtual T getData(int i) = 0;
  virtual BOOL request(U64 addr) = 0;
};

template <class T,int n>
class ram_write_if: virtual public sc_interface
{
public:
  virtual BOOL write(U64 addr, T * source) = 0 ;
} ;
template <class T,int n>
class ram_read_write_if: virtual public ram_read_if<T,n>,virtual public ram_write_if<T,n>
{
};
#endif
